/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import com.google.common.base.Function;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogFormatter;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NavMeshCache {
    public static LogCategory log = new LogCategory("AnalysedNavMeshCache");
    private static Map<String, SoftReference<NavMesh>> cache;

    public static void loadNavMesh(NavMesh navMesh, final Map<UnrealId, NavPoint> navGraph, String mapName) {
        NavMesh cachedNavMesh = NavMeshCache.getNavMeshFromCache(mapName);
        if (cachedNavMesh != null) {
            navMesh.copyFrom(cachedNavMesh);
            navMesh.setNavGraph(new Function<UnrealId, NavPoint>(){

                @Override
                public NavPoint apply(UnrealId input) {
                    return (NavPoint)navGraph.get(input);
                }
            });
        } else {
            NavMeshCache.reloadNavMesh(navMesh, navGraph, mapName);
        }
    }

    private static NavMesh getNavMeshFromCache(String mapName) {
        SoftReference<NavMesh> reference = cache.get(mapName);
        if (reference == null) {
            return null;
        }
        NavMesh result = reference.get();
        if (result != null) {
            return result;
        }
        cache.remove(mapName);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadNavMesh(NavMesh navMesh, final Map<UnrealId, NavPoint> navGraph, String mapName) {
        NavMesh cachedNavmesh = null;
        String navMeshFileName = NavMesh.processedMeshDir + "/" + mapName + ".anm";
        File navMeshFile = new File(navMeshFileName);
        ObjectInputStream in = null;
        try {
            log.warning("Loading previously stored NavMesh from binary file: " + navMeshFile.getAbsolutePath());
            in = new ObjectInputStream(new FileInputStream(navMeshFile));
            cachedNavmesh = (NavMesh)in.readObject();
            cachedNavmesh.setNavGraph(new Function<UnrealId, NavPoint>(){

                @Override
                public NavPoint apply(UnrealId input) {
                    return (NavPoint)navGraph.get(input);
                }
            });
        }
        catch (InvalidClassException e) {
            log.warning("Analysed navmesh file was generated by a different version of the software and must be regenerated.");
        }
        catch (ClassNotFoundException e) {
            log.warning("Analysed navmesh file was generated by a different version of the software and must be regenerated.");
        }
        catch (IOException e) {
            log.warning("Previously saved analysed navmesh file could not have been restored, looking for original files.");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (cachedNavmesh != null) {
            cache.put(mapName, new SoftReference<Object>(cachedNavmesh));
            navMesh.copyFrom(cachedNavmesh);
            return;
        }
        try {
            cachedNavmesh = new NavMesh(log);
            cachedNavmesh.load(navGraph, mapName);
            cache.put(mapName, new SoftReference<NavMesh>(cachedNavmesh));
            log.info("NavMesh LOADED SUCCESSFULLY.");
            navMesh.copyFrom(cachedNavmesh);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load navmesh file; the navmesh is expected to be inside 'navmesh' directory; you can download some from: https://github.com/kefik/Pogamut3/tree/master/Addons/UT2004/Map/UT2004NavMeshTools/04-NavMeshes", e);
        }
    }

    static {
        LogPublisher.ConsolePublisher publisher = new LogPublisher.ConsolePublisher();
        publisher.setFormatter(new LogFormatter(new AgentId("Platform")));
        log.addHandler(publisher);
        cache = Collections.synchronizedMap(new HashMap());
    }
}

