/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navgraph.internal;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import javax.vecmath.Vector3d;

public class JsonParser {
    private String body;
    private int index;

    public JsonParser(String body) {
        this.body = body;
        this.index = 0;
    }

    protected boolean isEnd() {
        return this.index < 0 || this.index >= this.body.length();
    }

    protected void nextChar() {
        ++this.index;
        if (this.index >= this.body.length()) {
            this.index = -1;
        }
    }

    protected void skipWhitespace() {
        while (!this.isEnd() && this.isWhitespace()) {
            ++this.index;
        }
    }

    private boolean isWhitespace() {
        char c = this.body.charAt(this.index);
        return c == ' ' || c == '\t';
    }

    protected boolean startsWith(String prefix) {
        return this.body.substring(this.index).startsWith(prefix);
    }

    protected String nextTo(String needle) {
        int indexOfNeedle = this.body.substring(this.index).indexOf(needle);
        indexOfNeedle = indexOfNeedle >= 0 ? (indexOfNeedle += this.index) : this.body.length();
        String result = this.body.substring(this.index, indexOfNeedle);
        this.index = indexOfNeedle;
        return result.trim();
    }

    protected String nextPast(String needle) {
        String retval = this.nextTo(needle);
        if (this.index < this.body.length()) {
            this.index += needle.length();
        }
        return retval + needle;
    }

    protected boolean nextBoolean() {
        String literal = this.nextTo(",");
        return literal.toLowerCase().equals("true");
    }

    protected int nextInt() {
        String literal = this.nextTo(",");
        return Integer.parseInt(literal);
    }

    protected double nextDouble() {
        String literal = this.nextTo(",");
        return Double.parseDouble(literal);
    }

    protected String nextString() {
        this.skipWhitespace();
        if (this.startsWith("null")) {
            this.nextPast("null");
            return null;
        }
        this.nextPast("\"");
        String literal = this.nextTo("\"");
        this.nextChar();
        return literal;
    }

    protected double[] nextNumbers() {
        this.skipWhitespace();
        if (this.startsWith("null")) {
            this.nextPast("null");
            return null;
        }
        this.nextPast("[");
        String[] numberStrings = this.nextTo("]").split(",");
        this.nextChar();
        double[] result = new double[numberStrings.length];
        for (int i = 0; i < numberStrings.length; ++i) {
            result[i] = Double.parseDouble(numberStrings[i]);
        }
        return result;
    }

    protected Vector3d nextVector3d() {
        double[] xyz = this.nextNumbers();
        if (xyz == null) {
            return null;
        }
        return new Vector3d(xyz[0], xyz[1], xyz[2]);
    }

    protected UnrealId nextId() {
        String literal = this.nextString();
        if (literal == null) {
            return null;
        }
        return UnrealId.get(literal);
    }

    protected Location nextLocation() {
        double[] xyz = this.nextNumbers();
        if (xyz == null) {
            return null;
        }
        return new Location(xyz);
    }

    protected Rotation nextRotation() {
        double[] numbers = this.nextNumbers();
        if (numbers == null) {
            return null;
        }
        return new Rotation(numbers[0], numbers[1], numbers[2]);
    }

    protected Velocity nextVelocity() {
        double[] numbers = this.nextNumbers();
        if (numbers == null) {
            return null;
        }
        return new Velocity(numbers[0], numbers[1], numbers[2]);
    }
}

