/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.IVisibilityAdapter;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004Draw;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Spawn;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.StopWatch;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class NavPointVisibility
extends SensorModule<UT2004Bot> {
    private boolean useFieldOfView = true;
    private double fovAngleDeg = 120.0;
    private boolean updateWorldView = true;
    private double navPointVisionDistance = 2000.0;
    private Boolean navpointsOff = null;
    private Set<NavPoint> visibleNavPoints;
    private Set<NavPoint> nextVisibleNavPoints;
    private SelfListener selfListener;
    BotKilledListener botKilledListener;
    ConfigChangeListener configChangeListener;
    private SpawnListener spawnListener;
    private boolean beginMessage = false;
    private BeginMessageListener beginMessageListener;
    private AgentInfo info;
    private IVisibilityAdapter visibilityAdapter;

    public void drawNavPointVisibility(UT2004Draw draw) {
        for (NavPoint navPoint : this.worldView.getAll(NavPoint.class).values()) {
            Color color = this.isNavPointVisible(navPoint) ? Color.green : Color.red;
            draw.drawCube(color, navPoint.getLocation(), 15.0);
        }
    }

    public void drawNavPointVisibilityWorldView(UT2004Draw draw) {
        for (NavPoint navPoint : this.worldView.getAll(NavPoint.class).values()) {
            Color color = navPoint.isVisible() ? Color.green : Color.red;
            draw.drawCube(color, navPoint.getLocation(), 15.0);
        }
    }

    public boolean isUseFOV() {
        return this.useFieldOfView;
    }

    public double getFOVAngleDeg() {
        return this.fovAngleDeg;
    }

    public boolean isInFOV(ILocated location, double fovAngleDeg) {
        if (location == null) {
            return false;
        }
        Location loc = location.getLocation();
        if (loc == null) {
            return false;
        }
        if (this.info.getLocation().getDistance(loc) < 70.0) {
            return true;
        }
        Location dir = loc.add(this.info.getLocation().invert()).getNormalized();
        Location heading = this.info.getRotation().toLocation().setZ(0.0).getNormalized();
        double angleDeg = Math.acos(heading.dot(dir)) / Math.PI * 180.0;
        if (angleDeg < -180.0) {
            angleDeg += 360.0;
        }
        if (angleDeg > 180.0) {
            angleDeg -= 360.0;
        }
        if (angleDeg < -fovAngleDeg / 2.0) {
            return false;
        }
        return !(angleDeg > fovAngleDeg / 2.0);
    }

    public boolean isUpdateWorldView() {
        return this.updateWorldView;
    }

    public void setUpdateWorldView(boolean updateWorldView) {
        this.updateWorldView = updateWorldView;
    }

    public boolean isInitialized() {
        return this.visibilityAdapter != null && this.visibilityAdapter.isInitialized();
    }

    public double getNavPointVisionDistance() {
        return this.navPointVisionDistance;
    }

    public void setNavPointVisionDistance(double navPointVisionDistance) {
        this.navPointVisionDistance = navPointVisionDistance;
    }

    protected void refreshNavPointVisibility() {
        if (this.visibilityAdapter == null || !this.visibilityAdapter.isInitialized()) {
            return;
        }
        if (this.updateWorldView && (this.navpointsOff == null || !this.navpointsOff.booleanValue())) {
            ((UT2004Bot)this.agent).getAct().act(new Configuration().setSyncNavPointsOff(true));
            this.navpointsOff = true;
        } else if (!this.updateWorldView && this.navpointsOff != null && this.navpointsOff.booleanValue()) {
            ((UT2004Bot)this.agent).getAct().act(new Configuration().setSyncNavPointsOff(false));
            this.navpointsOff = false;
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Self update => checking navpoint visibility...");
        }
        StopWatch watch = new StopWatch();
        Location myLocation = this.info.getLocation();
        int visibilityQueryCount = 0;
        for (NavPoint navPoint : this.worldView.getAll(NavPoint.class).values()) {
            double navPointDistance = this.info.getDistance(navPoint);
            if (navPointDistance > this.navPointVisionDistance) continue;
            ++visibilityQueryCount;
            if (!this.doNavPointVisibilityQuery(navPoint)) continue;
            this.nextVisibleNavPoints.add(navPoint);
        }
        int navPointsDisappeared = 0;
        for (NavPoint navPoint : this.visibleNavPoints) {
            if (this.nextVisibleNavPoints.contains(navPoint)) continue;
            ++navPointsDisappeared;
            this.updateNavPointVisibilityInWorldView(navPoint, false);
        }
        int navPointsAppeared = 0;
        for (NavPoint navPoint : this.nextVisibleNavPoints) {
            if (this.visibleNavPoints.contains(navPoint)) continue;
            ++navPointsAppeared;
            this.updateNavPointVisibilityInWorldView(navPoint, true);
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("#Navpoint querries = " + visibilityQueryCount + ", #Appeared = " + navPointsAppeared + ", #Disappeared = " + navPointsDisappeared + ", #TotalVisible = " + this.nextVisibleNavPoints.size());
            this.log.fine("Total time: " + watch.stopStr());
        }
        Set<NavPoint> temp = this.visibleNavPoints;
        this.visibleNavPoints = this.nextVisibleNavPoints;
        this.nextVisibleNavPoints = temp;
        this.nextVisibleNavPoints.clear();
    }

    private boolean doNavPointVisibilityQuery(NavPoint navPoint) {
        if (this.useFieldOfView && !this.isInFOV(navPoint, this.fovAngleDeg)) {
            return false;
        }
        return this.visibilityAdapter.isVisible(this.info.getLocation(), navPoint);
    }

    private void updateNavPointVisibilityInWorldView(NavPoint navPoint, boolean visible) {
        if (navPoint.isVisible() == visible) {
            return;
        }
        if (!this.updateWorldView) {
            return;
        }
        NavPointMessage update = new NavPointMessage(navPoint.getId(), navPoint.getLocation(), navPoint.getVelocity(), visible, navPoint.getItem(), navPoint.getItemClass(), navPoint.isItemSpawned(), navPoint.isDoorOpened(), navPoint.getMover(), navPoint.getLiftOffset(), navPoint.isLiftJumpExit(), navPoint.isNoDoubleJump(), navPoint.isInvSpot(), navPoint.isPlayerStart(), navPoint.getTeamNumber(), navPoint.isDomPoint(), navPoint.getDomPointController(), navPoint.isDoor(), navPoint.isLiftCenter(), navPoint.isLiftExit(), navPoint.isAIMarker(), navPoint.isJumpSpot(), navPoint.isJumpPad(), navPoint.isJumpDest(), navPoint.isTeleporter(), navPoint.getRotation(), navPoint.isRoamingSpot(), navPoint.isSnipingSpot(), navPoint.getItemInstance(), navPoint.getOutgoingEdges(), navPoint.getIncomingEdges(), navPoint.getPreferedWeapon());
        this.worldView.notifyImmediately(update);
    }

    private void dropNavPointVisibilityFlags() {
        for (NavPoint navPoint : this.visibleNavPoints) {
            this.updateNavPointVisibilityInWorldView(navPoint, false);
        }
        this.visibleNavPoints.clear();
    }

    public boolean isNavPointVisible(NavPoint navPoint) {
        return this.visibleNavPoints.contains(navPoint);
    }

    public NavPointVisibility(UT2004Bot bot, AgentInfo info, IVisibilityAdapter visibilityAdapter) {
        super(bot);
        this.info = info;
        this.visibilityAdapter = visibilityAdapter;
        NullCheck.check(info, "info");
        NullCheck.check(visibilityAdapter, "visibilityAdapter");
        this.selfListener = new SelfListener(this.worldView);
        this.botKilledListener = new BotKilledListener(this.worldView);
        this.spawnListener = new SpawnListener(this.worldView);
        this.beginMessageListener = new BeginMessageListener(this.worldView);
        this.configChangeListener = new ConfigChangeListener(this.worldView);
        this.visibleNavPoints = new HashSet<NavPoint>();
        this.nextVisibleNavPoints = new HashSet<NavPoint>();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.navpointsOff = null;
        if (this.visibleNavPoints == null) {
            this.visibleNavPoints = new HashSet<NavPoint>();
        } else {
            this.visibleNavPoints.clear();
        }
        if (this.nextVisibleNavPoints == null) {
            this.nextVisibleNavPoints = new HashSet<NavPoint>();
        } else {
            this.nextVisibleNavPoints.clear();
        }
    }

    private class BeginMessageListener
    implements IWorldEventListener<BeginMessage> {
        private IWorldView worldView;

        public BeginMessageListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, this);
            this.worldView = worldView;
        }

        @Override
        public void notify(BeginMessage event) {
            NavPointVisibility.this.beginMessage = true;
        }
    }

    private class SpawnListener
    implements IWorldEventListener<Spawn> {
        private IWorldView worldView;

        public SpawnListener(IWorldView worldView) {
            worldView.addEventListener(Spawn.class, this);
            this.worldView = worldView;
        }

        @Override
        public void notify(Spawn event) {
            NavPointVisibility.this.dropNavPointVisibilityFlags();
        }
    }

    private class ConfigChangeListener
    implements IWorldEventListener<ConfigChange> {
        public ConfigChangeListener(IWorldView worldView) {
            worldView.addEventListener(ConfigChange.class, this);
        }

        @Override
        public void notify(ConfigChange event) {
        }
    }

    private class BotKilledListener
    implements IWorldEventListener<BotKilled> {
        public BotKilledListener(IWorldView worldView) {
            worldView.addEventListener(BotKilled.class, this);
        }

        @Override
        public void notify(BotKilled event) {
            NavPointVisibility.this.dropNavPointVisibilityFlags();
        }
    }

    private class SelfListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        private IWorldView worldView;

        public SelfListener(IWorldView worldView) {
            this.worldView = worldView;
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this);
        }

        @Override
        public void notify(WorldObjectUpdatedEvent<Self> event) {
            if (NavPointVisibility.this.beginMessage) {
                NavPointVisibility.this.refreshNavPointVisibility();
                NavPointVisibility.this.beginMessage = false;
            }
        }
    }
}

