/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.ManualControlWindow;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavPointVisibility;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.LevelGeometryModule;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.RayCastResult;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004Draw;
import cz.cuni.amis.pogamut.ut2004.bot.command.CompleteBotCommandsWrapper;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.utils.StopWatch;

public class ManualControl
extends SensomotoricModule<UT2004Bot> {
    private ManualControlWindow window;
    private ManualControlWindow.IManualControlCallback manualControlCallback = new ManualControlWindow.IManualControlCallback(){

        @Override
        public void raycast() {
            ManualControl.this.raycast();
        }

        @Override
        public void jump() {
            ManualControl.this.jump();
        }

        @Override
        public void drawLevelGeometry() {
            ManualControl.this.drawLevelGeometry();
        }

        @Override
        public void drawLevelGeometryBSP() {
            ManualControl.this.drawLevelGeometryBSP();
        }

        @Override
        public void drawClear() {
            ManualControl.this.drawClear();
        }

        @Override
        public void drawNavPointVisibility() {
            ManualControl.this.drawNavPointVisibility();
        }

        @Override
        public void drawNavPointVisibilityWorldView() {
            ManualControl.this.drawNavPointVisibilityGB2004();
        }
    };
    private EndMessageListener endMessageListener;
    private AgentInfo info;
    private CompleteBotCommandsWrapper body;
    private LevelGeometryModule levelGeometryModule;
    private UT2004Draw draw;
    private NavPointVisibility navPointVisibility;

    public void showWindow() {
        if (this.window == null) {
            this.createWindow();
        }
        this.window.setVisible(true);
        this.window.setLocation(10, 10);
    }

    private void createWindow() {
        this.window = new ManualControlWindow();
        this.window.callback = this.manualControlCallback;
    }

    public void hideWindow() {
        if (this.window == null) {
            return;
        }
        this.window.setVisible(false);
    }

    protected void tick() {
        if (this.window == null) {
            return;
        }
        if (this.window.forward) {
            this.body.getLocomotion().moveContinuos();
        }
        if (this.window.left) {
            this.body.getLocomotion().turnHorizontal(-15);
        }
        if (this.window.right) {
            this.body.getLocomotion().turnHorizontal(15);
        }
        if (!(this.window.forward || this.window.left || this.window.right || this.window.backward)) {
            this.body.getLocomotion().stopMovement();
        }
    }

    protected void drawClear() {
        if (this.draw == null) {
            return;
        }
        this.draw.clearAll();
        this.say("ALL DRAWING CLEARED");
    }

    protected void drawLevelGeometryBSP() {
        if (this.levelGeometryModule == null) {
            return;
        }
        if (!this.levelGeometryModule.isInitialized()) {
            return;
        }
        this.say("Drawing level geometry BSP...");
        this.levelGeometryModule.getDraw().drawBSP();
        this.say("LEVEL GEOMETRY BSP DRAWN");
    }

    protected void drawLevelGeometry() {
        if (this.levelGeometryModule == null) {
            return;
        }
        if (!this.levelGeometryModule.isInitialized()) {
            return;
        }
        this.say("Drawing level geometry... This will take a long time, like 10-20 minutes.");
        this.levelGeometryModule.getDraw().draw();
        this.say("LEVEL GEOMETRY DRAWN");
    }

    protected void jump() {
        this.body.getLocomotion().jump();
    }

    protected void raycast() {
        if (this.levelGeometryModule == null) {
            return;
        }
        if (!this.levelGeometryModule.isInitialized()) {
            return;
        }
        int raycastDistance = 1000;
        this.say("Let's do some raycasting from here (client-side of course) up to " + raycastDistance + " UT units distance. ");
        StopWatch watch = new StopWatch();
        watch.start();
        Location rayVector = this.info.getRotation().toLocation().getNormalized().scale(raycastDistance);
        RayCastResult raycast = this.levelGeometryModule.getLevelGeometry().rayCast(this.info.getLocation(), this.info.getLocation().add(rayVector));
        watch.stop();
        this.log.info("RAYCAST RESULT");
        this.log.info("    +-- RAY:  " + raycast.ray.getOrigin() + " -> " + raycast.ray.getExamplePoint2());
        this.log.info("    +-- VEC:  " + raycast.ray.getVector());
        this.log.info("    +-- HIT:  " + raycast.isHit());
        if (raycast.isHit()) {
            this.log.info("        +-- LOCATION: " + raycast.hitLocation);
            this.log.info("        +-- DISTANCE: " + raycast.hitDistance);
        }
        this.say("1 Raycast, performed in " + watch.timeStr() + ", result: " + (raycast.isHit() ? "HIT" : "NO-HIT"));
        this.levelGeometryModule.getDraw().drawRaycast(raycast);
    }

    protected void drawNavPointVisibility() {
        if (this.draw == null) {
            return;
        }
        if (this.navPointVisibility == null) {
            return;
        }
        this.say("Drawing nav point visibility (according to NavPointVisibility)...");
        this.navPointVisibility.drawNavPointVisibility(this.draw);
        this.say("Drawing DONE!");
    }

    protected void drawNavPointVisibilityGB2004() {
        if (this.draw == null) {
            return;
        }
        if (this.navPointVisibility == null) {
            return;
        }
        this.say("Drawing nav point visibility (according to WorldView)...");
        this.navPointVisibility.drawNavPointVisibilityWorldView(this.draw);
        this.say("Drawing DONE!");
    }

    private void say(String text) {
        this.body.getCommunication().sendGlobalTextMessage(text);
    }

    public ManualControl(UT2004Bot bot, AgentInfo info, CompleteBotCommandsWrapper body, LevelGeometryModule levelGeometryModule, UT2004Draw draw, NavPointVisibility navPointVisibility) {
        super(bot);
        this.info = info;
        this.body = body;
        this.levelGeometryModule = levelGeometryModule;
        this.draw = draw;
        this.navPointVisibility = navPointVisibility;
        this.endMessageListener = new EndMessageListener(this.worldView);
    }

    @Override
    protected void start(boolean startToPaused) {
        super.start(startToPaused);
        this.showWindow();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.hideWindow();
    }

    private class EndMessageListener
    implements IWorldEventListener<EndMessage> {
        private IWorldView worldView;

        public EndMessageListener(IWorldView worldView) {
            worldView.addEventListener(EndMessage.class, this);
            this.worldView = worldView;
        }

        @Override
        public void notify(EndMessage event) {
            ManualControl.this.tick();
        }
    }
}

