/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.maps.HashMapMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;

public abstract class Items
extends SensorModule<UT2004Bot> {
    private Random random = new Random(System.currentTimeMillis());
    private IPathPlanner<NavPoint> pathPlanner = null;
    private DistanceUtils.IGetDistance<ILocated> pathPlannerGetDistance = new DistanceUtils.IGetDistance<ILocated>(){

        @Override
        public double getDistance(ILocated object, ILocated target) {
            if (object == null || target == null) {
                return Double.POSITIVE_INFINITY;
            }
            if (Items.this.pathPlanner == null) {
                return target.getLocation().getDistance(object.getLocation());
            }
            NavPoint objectNP = Items.this.obtainNavPoint(object);
            NavPoint targetNP = Items.this.obtainNavPoint(target);
            if (objectNP == null || targetNP == null) {
                return Double.POSITIVE_INFINITY;
            }
            return Items.this.pathPlanner.getDistance(objectNP, targetNP);
        }
    };
    private ItemMaps items;
    protected ItemsListener itemsListener;
    protected MapPointsListener mapPointsListener;
    protected Map<UnrealId, NavPoint> navPoints = new HashMap<UnrealId, NavPoint>();
    protected List<NavPoint> navPointsToProcess = new ArrayList<NavPoint>();
    protected NavPointListener navPointListener;
    protected EndMessageListener endMessageListener;
    protected ItemPickedUpListener itemPickedUpListener;
    protected AgentInfo agentInfo;
    protected Weaponry weaponry;
    protected Game game;

    private NavPoint obtainNavPoint(ILocated obj) {
        if (obj instanceof NavPoint) {
            return (NavPoint)obj;
        }
        if (obj instanceof Item) {
            return ((Item)obj).getNavPoint();
        }
        return null;
    }

    public void setPathPlanner(IPathPlanner<NavPoint> pathPlanner) {
        this.pathPlanner = pathPlanner;
    }

    public abstract boolean isPickable(Item var1);

    public Map<UnrealId, Item> getAllItems() {
        return Collections.unmodifiableMap(this.items.all);
    }

    public Map<UnrealId, Item> getAllItems(ItemType type) {
        return Collections.unmodifiableMap(this.items.allCategories.get(type));
    }

    public Map<UnrealId, Item> getAllItems(ItemType.Category category) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (ItemType type : category.getTypes()) {
            result.putAll(this.getAllItems(type));
        }
        return result;
    }

    public Map<UnrealId, Item> getAllItems(ItemType.Group group) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (ItemType type : group.getTypes()) {
            result.putAll(this.getAllItems(type));
        }
        return result;
    }

    public Item getItem(UnrealId id) {
        Item item = (Item)this.items.all.get(id);
        if (item == null) {
            item = (Item)this.items.visible.get(id);
        }
        return item;
    }

    public Item getItem(String stringUnrealId) {
        return this.getItem(UnrealId.get(stringUnrealId));
    }

    public Item getRandomItem() {
        if (this.getAllItems().size() == 0) {
            return null;
        }
        int num = this.random.nextInt(this.getAllItems().size());
        Iterator<Item> iter = this.getAllItems().values().iterator();
        for (int i = 0; i < num - 1; ++i) {
            iter.next();
        }
        return iter.next();
    }

    public Item getNearestItem() {
        return DistanceUtils.getNearest(this.getAllItems().values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestItem() {
        return DistanceUtils.getNearest(this.getAllItems().values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Item getNearestItem(ItemType.Category category) {
        return DistanceUtils.getNearest(this.getAllItems(category).values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestItem(ItemType.Category category) {
        return DistanceUtils.getNearest(this.getAllItems(category).values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Item getNearestItem(ItemType.Group group) {
        return DistanceUtils.getNearest(this.getAllItems(group).values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestItem(ItemType.Group group) {
        return DistanceUtils.getNearest(this.getAllItems(group).values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Item getNearestItem(ItemType type) {
        return DistanceUtils.getNearest(this.getAllItems(type).values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestItem(ItemType type) {
        return DistanceUtils.getNearest(this.getAllItems(type).values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Map<UnrealId, Item> getVisibleItems() {
        return Collections.unmodifiableMap(this.items.visible);
    }

    public Map<UnrealId, Item> getVisibleItems(ItemType type) {
        return Collections.unmodifiableMap(this.items.visibleCategories.get(type));
    }

    public Map<UnrealId, Item> getVisibleItems(ItemType.Category category) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (ItemType type : category.getTypes()) {
            result.putAll(this.getVisibleItems(type));
        }
        return result;
    }

    public Map<UnrealId, Item> getVisibleItems(ItemType.Group group) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (ItemType type : group.getTypes()) {
            result.putAll(this.getVisibleItems(type));
        }
        return result;
    }

    public Item getVisibleItem(UnrealId id) {
        Item item = (Item)this.items.visible.get(id);
        return item;
    }

    public Item getVisibleItem(String stringUnrealId) {
        return this.getVisibleItem(UnrealId.get(stringUnrealId));
    }

    public Item getNearestVisibleItem() {
        return DistanceUtils.getNearest(this.getVisibleItems().values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestVisibleItem() {
        return DistanceUtils.getNearest(this.getVisibleItems().values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Item getNearestVisibleItem(ItemType.Category category) {
        return DistanceUtils.getNearest(this.getVisibleItems(category).values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestVisibleItem(ItemType.Category category) {
        return DistanceUtils.getNearest(this.getVisibleItems(category).values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Item getNearestVisibleItem(ItemType.Group group) {
        return DistanceUtils.getNearest(this.getVisibleItems(group).values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestVisibleItem(ItemType.Group group) {
        return DistanceUtils.getNearest(this.getVisibleItems(group).values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Item getNearestVisibleItem(ItemType type) {
        return DistanceUtils.getNearest(this.getVisibleItems(type).values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestVisibleItem(ItemType type) {
        return DistanceUtils.getNearest(this.getVisibleItems(type).values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Map<UnrealId, Item> getKnownPickups() {
        return Collections.unmodifiableMap(this.items.known);
    }

    public Map<UnrealId, Item> getKnownPickups(ItemType type) {
        return Collections.unmodifiableMap(this.items.knownCategories.get(type));
    }

    public Map<UnrealId, Item> getKnownPickups(ItemType.Category category) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (ItemType type : category.getTypes()) {
            result.putAll(this.getKnownPickups(type));
        }
        return result;
    }

    public Map<UnrealId, Item> getKnownPickups(ItemType.Group group) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (ItemType type : group.getTypes()) {
            result.putAll(this.getKnownPickups(type));
        }
        return result;
    }

    public Item getKnownPickup(UnrealId id) {
        return (Item)this.items.known.get(id);
    }

    public Item getKnownPickup(String stringUnrealId) {
        return this.getKnownPickup(UnrealId.get(stringUnrealId));
    }

    public Map<UnrealId, Item> getSpawnedItems() {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (Item item : this.getAllItems().values()) {
            if (!this.isPickupSpawned(item)) continue;
            result.put(item.getId(), item);
        }
        return result;
    }

    public Map<UnrealId, Item> getSpawnedItems(ItemType type) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (Item item : this.getAllItems(type).values()) {
            if (!this.isPickupSpawned(item)) continue;
            result.put(item.getId(), item);
        }
        return result;
    }

    public Map<UnrealId, Item> getSpawnedItems(ItemType.Category category) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (ItemType type : category.getTypes()) {
            result.putAll(this.getSpawnedItems(type));
        }
        return result;
    }

    public Map<UnrealId, Item> getSpawnedItems(ItemType.Group group) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (ItemType type : group.getTypes()) {
            result.putAll(this.getSpawnedItems(type));
        }
        return result;
    }

    public Item getNearestSpawnedItem() {
        return DistanceUtils.getNearest(this.getSpawnedItems().values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestSpawnedItem() {
        return DistanceUtils.getNearest(this.getSpawnedItems().values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Item getNearestSpawnedItem(ItemType.Category category) {
        return DistanceUtils.getNearest(this.getSpawnedItems(category).values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestSpawnedItem(ItemType.Category category) {
        return DistanceUtils.getNearest(this.getSpawnedItems(category).values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Item getNearestSpawnedItem(ItemType.Group group) {
        return DistanceUtils.getNearest(this.getSpawnedItems(group).values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestSpawnedItem(ItemType.Group group) {
        return DistanceUtils.getNearest(this.getSpawnedItems(group).values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public Item getNearestSpawnedItem(ItemType type) {
        return DistanceUtils.getNearest(this.getSpawnedItems(type).values(), this.agentInfo.getLocation());
    }

    public Item getPathNearestSpawnedItem(ItemType type) {
        return DistanceUtils.getNearest(this.getSpawnedItems(type).values(), (ILocated)this.agentInfo.getNearestNavPoint(), this.pathPlannerGetDistance);
    }

    public double getItemRespawnUT2004Time(Item item) {
        return this.getItemRespawnTime(item.getType()) * 1.1;
    }

    public double getItemRespawnUT2004Time(ItemType itemType) {
        return this.getItemRespawnTime(itemType) * 1.1;
    }

    public double getItemRespawnTime(Item item) {
        return this.getItemRespawnTime(item.getType());
    }

    public abstract double getItemRespawnTime(ItemType var1);

    public boolean isPickupSpawned(Item item) {
        if (item == null) {
            return false;
        }
        if (item.isVisible()) {
            return true;
        }
        NavPoint np = item.getNavPoint();
        if (np == null) {
            np = this.navPoints.get(item.getNavPointId());
        }
        if (np != null) {
            if (np.isVisible()) {
                return np.isItemSpawned();
            }
            return !this.items.itemMissing.isTaboo(item);
        }
        return !this.items.itemMissing.isTaboo(item);
    }

    public boolean willPickupBeSpawnedIn(Item item, double seconds) {
        if (this.isPickupSpawned(item)) {
            return true;
        }
        return !this.items.itemMissing.willBeTaboo(item, seconds);
    }

    public boolean isPickupSpawned(UnrealId itemId) {
        return this.isPickupSpawned((Item)this.items.all.get(itemId));
    }

    protected ItemsListener createItemsListener(IWorldView worldView) {
        return new ItemsListener(worldView);
    }

    protected MapPointsListener createMapPointsListener(IWorldView worldView) {
        return new MapPointsListener(worldView);
    }

    public Items(UT2004Bot bot, AgentInfo agentInfo, Game game, Weaponry weaponry, Logger log) {
        super(bot, log);
        this.agentInfo = agentInfo;
        NullCheck.check(this.agentInfo, "agentInfo");
        this.weaponry = weaponry;
        NullCheck.check(this.weaponry, "weaponry");
        this.game = game;
        NullCheck.check(this.game, "game");
        this.items = new ItemMaps(bot);
        this.itemsListener = this.createItemsListener(this.worldView);
        this.mapPointsListener = this.createMapPointsListener(this.worldView);
        this.navPointListener = new NavPointListener(this.worldView);
        this.endMessageListener = new EndMessageListener(this.worldView);
        this.itemPickedUpListener = new ItemPickedUpListener(this.worldView);
        this.cleanUp();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.navPoints.clear();
        this.items.clear();
    }

    protected class ItemPickedUpListener
    implements IWorldEventListener<ItemPickedUp> {
        public ItemPickedUpListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, this);
        }

        @Override
        public void notify(ItemPickedUp event) {
            Items.this.items.notify(event);
        }
    }

    protected class EndMessageListener
    implements IWorldEventListener<EndMessage> {
        public EndMessageListener(IWorldView worldView) {
            worldView.addEventListener(EndMessage.class, this);
        }

        @Override
        public void notify(EndMessage event) {
            Items.this.items.notifyBatchEnd(Items.this.navPointsToProcess);
        }
    }

    protected class NavPointListener
    implements IWorldObjectEventListener<NavPoint, WorldObjectUpdatedEvent<NavPoint>> {
        public NavPointListener(IWorldView worldView) {
            worldView.addObjectListener(NavPoint.class, WorldObjectUpdatedEvent.class, this);
        }

        @Override
        public void notify(WorldObjectUpdatedEvent<NavPoint> event) {
            Items.this.items.notify((NavPoint)event.getObject());
            if (((NavPoint)event.getObject()).isVisible() || ((NavPoint)event.getObject()).isItemSpawned()) {
                Items.this.navPointsToProcess.add((NavPoint)event.getObject());
            } else {
                Items.this.navPointsToProcess.remove(event.getObject());
            }
        }
    }

    protected class MapPointsListener
    implements IWorldEventListener<MapPointListObtained> {
        public MapPointsListener(IWorldView worldView) {
            worldView.addEventListener(MapPointListObtained.class, this);
        }

        @Override
        public void notify(MapPointListObtained event) {
            Items.this.navPoints = event.getNavPoints();
            Items.this.items.notify(event.getItems());
        }
    }

    protected class ItemsListener
    implements IWorldObjectEventListener<Item, IWorldObjectEvent<Item>> {
        public ItemsListener(IWorldView worldView) {
            worldView.addObjectListener(Item.class, IWorldObjectEvent.class, this);
        }

        @Override
        public void notify(IWorldObjectEvent<Item> event) {
            Items.this.items.notify(event.getObject());
        }
    }

    private class ItemMaps {
        private HashMap<UnrealId, Item> all = new HashMap();
        private HashMap<UnrealId, Item> visible = new HashMap();
        private HashMap<UnrealId, Item> reachable = new HashMap();
        private HashMap<UnrealId, Item> known = new HashMap();
        private HashMapMap<ItemType, UnrealId, Item> allCategories = new HashMapMap();
        private HashMapMap<ItemType, UnrealId, Item> visibleCategories = new HashMapMap();
        private HashMapMap<ItemType, UnrealId, Item> reachableCategories = new HashMapMap();
        private HashMapMap<ItemType, UnrealId, Item> knownCategories = new HashMapMap();
        private TabooSet<Item> itemMissing;
        private Set<Item> justPickedUp = new HashSet<Item>();
        private HashMap<UnrealId, Boolean> itemSpawned = new HashMap();

        public ItemMaps(UT2004Bot bot) {
            this.itemMissing = new TabooSet(bot);
        }

        private void notify(NavPoint navPoint) {
            if (navPoint.getItem() == null) {
                return;
            }
            Item item = Items.this.getItem(navPoint.getItem());
            if (item == null) {
                return;
            }
            if (navPoint.isItemSpawned()) {
                this.itemMissing.remove(item);
            } else {
                if (this.itemMissing.isTaboo(item)) {
                    return;
                }
                this.itemMissing.add(item, Items.this.getItemRespawnUT2004Time(item));
            }
        }

        private void notify(Item item) {
            UnrealId uid = item.getId();
            if (!this.all.containsKey(uid)) {
                this.all.put(uid, item);
                this.allCategories.put(item.getType(), item.getId(), item);
            }
            boolean wasVisible = this.visible.containsKey(uid);
            boolean isVisible = item.isVisible();
            if (isVisible && !wasVisible) {
                this.visible.put(uid, item);
                this.visibleCategories.put(item.getType(), item.getId(), item);
            } else if (!isVisible && wasVisible) {
                this.visible.remove(uid);
                this.visibleCategories.remove(item.getType(), item.getId());
            }
            if (!isVisible && item.isDropped()) {
                this.all.remove(uid);
                this.allCategories.remove(item.getType(), item.getId());
            }
        }

        private void notify(Map<UnrealId, Item> items) {
            this.known.putAll(items);
            for (Item item : items.values()) {
                this.knownCategories.put(item.getType(), item.getId(), item);
                this.notify(item);
            }
        }

        private void notifyBatchEnd(List<NavPoint> navPoints) {
            this.justPickedUp.clear();
        }

        private void notify(ItemPickedUp event) {
            Item item = this.all.get(event.getId());
            if (item == null) {
                return;
            }
            this.justPickedUp.add(item);
            this.itemMissing.add(item, Items.this.getItemRespawnUT2004Time(item));
        }

        private void clear() {
            this.all.clear();
            this.allCategories.clear();
            this.itemMissing.clear();
            this.justPickedUp.clear();
            this.known.clear();
            this.knownCategories.clear();
            this.reachable.clear();
            this.reachableCategories.clear();
            this.visible.clear();
            this.visibleCategories.clear();
        }
    }
}

