/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner.impl;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentRunner;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MultithreadedAgentRunner<AGENT extends IAgent, PARAMS extends IAgentParameters>
implements IAgentRunner<AGENT, PARAMS> {
    private static long ID = 0L;
    private static Object idMutex = new Object();
    protected Object mutex = new Object();
    protected IAgentFactory<AGENT, PARAMS> factory;
    protected Logger log;
    private boolean pausing = false;
    protected Level defaultLogLevel = Level.WARNING;
    protected boolean consoleLogging = true;
    protected CountDownLatch latch;
    protected List<AGENT> agents = null;
    protected boolean killed = false;
    protected boolean main = false;
    protected boolean killingAgents = false;
    protected Object killingAgentsMutex = new Object();
    protected int cpuThreadCount = Runtime.getRuntime().availableProcessors();
    protected FlagListener<IAgentState> listener = new FlagListener<IAgentState>(){

        @Override
        public void flagChanged(IAgentState changedValue) {
            if (changedValue instanceof IAgentStateFailed) {
                MultithreadedAgentRunner.this.killAgents(MultithreadedAgentRunner.this.agents);
            } else if (changedValue instanceof IAgentStateDown) {
                MultithreadedAgentRunner.this.latch.countDown();
            }
        }
    };

    public MultithreadedAgentRunner(IAgentFactory<AGENT, PARAMS> factory) {
        this.factory = factory;
        NullCheck.check(this.factory, "factory");
    }

    public Logger getLog() {
        return this.log;
    }

    public MultithreadedAgentRunner<AGENT, PARAMS> setLog(Logger log) {
        this.log = log;
        return this;
    }

    @Override
    public synchronized AGENT startAgent() throws PogamutException {
        List agent = this.main ? this.startAgentWithParamsMain(false, new IAgentParameters[]{this.newDefaultAgentParameters()}) : this.startAgentWithParams(false, new IAgentParameters[]{this.newDefaultAgentParameters()});
        return (AGENT)((IAgent)agent.get(0));
    }

    @Override
    public synchronized List<AGENT> startAgents(int count) throws PogamutException {
        IAgentParameters[] params = new IAgentParameters[count];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.newDefaultAgentParameters();
        }
        if (this.main) {
            return this.startAgentWithParamsMain(false, params);
        }
        return this.startAgentWithParams(false, params);
    }

    @Override
    public synchronized List<AGENT> startAgents(PARAMS ... agentParameters) throws PogamutException {
        if (this.main) {
            return this.startAgentWithParamsMain(true, (IAgentParameters[])agentParameters);
        }
        return this.startAgentWithParams(true, (IAgentParameters[])agentParameters);
    }

    @Override
    public boolean isPausing() {
        return this.pausing;
    }

    @Override
    public synchronized MultithreadedAgentRunner<AGENT, PARAMS> setPausing(boolean state) {
        this.pausing = state;
        return this;
    }

    @Override
    public boolean isMain() {
        return this.main;
    }

    @Override
    public synchronized MultithreadedAgentRunner<AGENT, PARAMS> setMain(boolean state) {
        this.main = state;
        return this;
    }

    public MultithreadedAgentRunner<AGENT, PARAMS> setLogLevel(Level logLevel) {
        this.defaultLogLevel = logLevel;
        return this;
    }

    public MultithreadedAgentRunner<AGENT, PARAMS> setConsoleLogging(boolean enabled) {
        this.consoleLogging = enabled;
        return this;
    }

    protected List<AGENT> startAgentWithParams(boolean fillDefaults, PARAMS ... params) {
        if (params == null || params.length == 0) {
            return new ArrayList(0);
        }
        ArrayList result = new ArrayList(params.length);
        boolean pausingBehavior = this.isPausing();
        try {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling preInitHook()...");
            }
            this.preInitHook();
            this.startAndAddAgent(params[0], pausingBehavior, result);
            ExecutorService executor = Executors.newFixedThreadPool(this.cpuThreadCount);
            int i = 0;
            while (i < params.length) {
                if (fillDefaults) {
                    params[i].assignDefaults(this.newDefaultAgentParameters());
                }
                int iLoc = i++;
                executor.submit(new Runnable((IAgentParameters[])params, iLoc, pausingBehavior, result){
                    final /* synthetic */ IAgentParameters[] val$params;
                    final /* synthetic */ int val$iLoc;
                    final /* synthetic */ boolean val$pausingBehavior;
                    final /* synthetic */ List val$result;
                    {
                        this.val$params = iAgentParametersArray;
                        this.val$iLoc = n;
                        this.val$pausingBehavior = bl;
                        this.val$result = list;
                    }

                    @Override
                    public void run() {
                        MultithreadedAgentRunner.this.startAndAddAgent(this.val$params[this.val$iLoc], this.val$pausingBehavior, this.val$result);
                    }
                });
            }
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            if (pausingBehavior) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calling preResumeHook()...");
                }
                this.preResumeHook(result);
                for (IAgent agent : result) {
                    agent.resume();
                }
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling postStartedHookCalled()...");
            }
            this.postStartedHook(result);
        }
        catch (PogamutException e) {
            this.killAgents(result);
            throw e;
        }
        catch (Exception e) {
            this.killAgents(result);
            throw new PogamutException("Agent's can't be started: " + e.getMessage(), e, (Object)this);
        }
        return result;
    }

    protected List<AGENT> startAgentWithParamsMain(boolean fillDefaults, PARAMS ... params) {
        if (params == null || params.length == 0) {
            return new ArrayList(0);
        }
        this.latch = new CountDownLatch(params.length);
        this.agents = new ArrayList<AGENT>(params.length);
        this.killed = false;
        boolean pausingBehavior = this.isPausing();
        try {
            this.startAndAddAgentMain(params[0], pausingBehavior);
            ExecutorService executor = Executors.newFixedThreadPool(this.cpuThreadCount);
            int i = 1;
            while (i < params.length && !this.killed) {
                if (fillDefaults) {
                    params[i].assignDefaults(this.newDefaultAgentParameters());
                }
                int iLoc = i++;
                executor.submit(new Runnable((IAgentParameters[])params, iLoc, pausingBehavior){
                    final /* synthetic */ IAgentParameters[] val$params;
                    final /* synthetic */ int val$iLoc;
                    final /* synthetic */ boolean val$pausingBehavior;
                    {
                        this.val$params = iAgentParametersArray;
                        this.val$iLoc = n;
                        this.val$pausingBehavior = bl;
                    }

                    @Override
                    public void run() {
                        MultithreadedAgentRunner.this.startAndAddAgentMain(this.val$params[this.val$iLoc], this.val$pausingBehavior);
                    }
                });
            }
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            if (!this.killed) {
                if (pausingBehavior) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Calling preResumeHook()...");
                    }
                    this.preResumeHook(this.agents);
                    for (IAgent agent : this.agents) {
                        agent.resume();
                    }
                }
                if (!this.killed) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Calling postStartedHookCalled()...");
                    }
                    this.postStartedHook(this.agents);
                }
                if (!this.killed) {
                    try {
                        this.latch.await();
                    }
                    catch (InterruptedException e) {
                        throw new PogamutInterruptedException("Interrupted while waiting for the agents to finish their execution.", e, (Object)this);
                    }
                }
            }
            if (this.killed) {
                throw new PogamutException("Could not execute all agents due to an exception, check logs of respective agents.", (Object)this);
            }
            List<AGENT> list = this.agents;
            return list;
        }
        catch (PogamutException e) {
            this.killAgents(this.agents);
            throw e;
        }
        catch (Exception e) {
            this.killAgents(this.agents);
            throw new PogamutException("Agents can't be started: " + e.getMessage(), e, (Object)this);
        }
        finally {
            Pogamut.getPlatform().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAndAddAgentMain(PARAMS params, boolean pausingBehavior) {
        AGENT agent = this.createAgentWithParams(params);
        if (this.killed) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling preStartHook()...");
        }
        this.preStartHook(agent);
        if (this.killed) {
            return;
        }
        this.startAgent(agent);
        if (this.killed) {
            this.killAgent(agent);
            return;
        }
        if (pausingBehavior) {
            agent.pause();
        }
        if (this.killed) {
            this.killAgent(agent);
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling postStartHook()...");
        }
        this.postStartHook(agent);
        if (this.killed) {
            this.killAgent(agent);
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.killed) {
                this.killAgent(agent);
                return;
            }
            this.agents.add(agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAndAddAgent(PARAMS params, boolean pausingBehavior, List<AGENT> result) {
        AGENT agent = this.createAgentWithParams(params);
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling preStartHook()...");
        }
        this.preStartHook(agent);
        this.startAgent(agent);
        if (pausingBehavior) {
            agent.pause();
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling postStartHook()...");
        }
        this.postStartHook(agent);
        List<AGENT> list = result;
        synchronized (list) {
            result.add(agent);
        }
    }

    protected abstract IAgentParameters newDefaultAgentParameters();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAgentId newAgentId(String name) {
        if (name == null) {
            name = "Unnamed";
        }
        Object object = idMutex;
        synchronized (object) {
            return new AgentId(name + ++ID);
        }
    }

    protected void fillInDefaults(PARAMS params) {
        params.assignDefaults(this.newDefaultAgentParameters());
    }

    protected void fillInDefaults(PARAMS[] paramsArray) {
        for (PARAMS params : paramsArray) {
            params.assignDefaults(this.newDefaultAgentParameters());
        }
    }

    protected AGENT createAgentWithParams(PARAMS params) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Instantiating agent with id '" + params.getAgentId().getToken() + "'");
        }
        AGENT agent = this.factory.newAgent(params);
        if (this.consoleLogging) {
            agent.getLogger().addDefaultConsoleHandler();
        }
        if (this.defaultLogLevel != null) {
            agent.getLogger().setLevel(this.defaultLogLevel);
        }
        return agent;
    }

    protected void startAgent(AGENT agent) {
        if (this.main) {
            agent.getState().addListener(this.listener);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Starting agent with id '" + agent.getComponentId().getToken() + "'");
        }
        agent.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void killAgents(List<AGENT> agents) {
        block16: {
            block17: {
                Object object = this.killingAgentsMutex;
                // MONITORENTER : object
                if (this.killingAgents) {
                    // MONITOREXIT : object
                    return;
                }
                this.killingAgents = true;
                // MONITOREXIT : object
                object = this.mutex;
                // MONITORENTER : object
                if (!this.main) break block16;
                if (this.killed) {
                    // MONITOREXIT : object
                    this.killingAgents = false;
                    return;
                }
                if (agents != null) break block17;
                // MONITOREXIT : object
                this.killingAgents = false;
                return;
            }
            while (this.latch.getCount() > 0L) {
                this.latch.countDown();
            }
            this.killed = true;
        }
        if (agents == null) {
            // MONITOREXIT : object
            this.killingAgents = false;
            return;
        }
        try {
            for (IAgent agent : agents) {
                if (agent == null) continue;
                this.killAgent(agent);
            }
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.killingAgents = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killAgent(AGENT agent) {
        if (agent == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.main) {
                agent.getState().removeListener(this.listener);
            }
            if (!(agent.getState().getFlag() instanceof IAgentStateDown)) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Killing agent with id '" + agent.getComponentId().getToken() + "'");
                }
                try {
                    agent.kill();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void preInitHook() throws PogamutException {
    }

    protected void preStartHook(AGENT agent) throws PogamutException {
    }

    protected void postStartHook(AGENT agent) throws PogamutException {
    }

    protected void preResumeHook(List<AGENT> agents) {
    }

    protected void postStartedHook(List<AGENT> agents) {
    }
}

