package cz.cuni.amis.pogamut.ut2004.examples.hideandseekbot;

import java.util.logging.Level;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSGameConfig;
import cz.cuni.amis.pogamut.ut2004.hideandseek.server.UT2004HSServer;
import cz.cuni.amis.pogamut.ut2004.hideandseek.server.UT2004HSServerModule;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;

public class HideAndSeekGame {
	public static void main(String[] args) {
		// HIDE-AND-SEEK GAME CONFIG

    	// MEANT TO BE PLAYED ON DM-TrainingDay
    	HSGameConfig config = new HSGameConfig();
    	
    	{
    		config.setTargetMap("DM-TrainingDay");             // we're configuring the hide-and-seek game for 'targetMap', in our case "DM-TrainingDay"
    		                                                   // UT2004HSServer will check whether the correct map is running to avoid mistakes
	    	config.setSafeArea(new Location(2000, -915, -50)); // +/- DM-TrainingDay.InventorySpot52
	    	config.setSafeAreaRadius(100); 		               // safe area spawns 100 units from the safe-point ... this should be at least 50 less than restricted-area-radius
	    	
	    	config.setFixedSeeker(false);          // always assign new seeker randomly
	    	config.setFixedSeekerName(null);       // not using "fixed seeker"
	    	config.setHideTimeUT(8) ;              // runners will get 8 seconds to hide
	    	config.setRestrictedAreaRadius(150);   // restricted area is 150 UT-units from the safe-point
	    	config.setRestrictedAreaTimeUT(4);     // restricted area will be active for 10 seconds after the seeker is spawned
	    	config.setRoundCount(10);              // all bots will play 10 rounds of hide-and-seek
	    	config.setRoundTimeUT(60);			   // total length of single round (includes config.getHideTimeUT() and config.setRestrictedAreaTimeUT())
	    	config.setSpotTimeMillis(600);         // how-long must be the RUNNER visible to the SEEKER in order for SEEKER to spot-it 
	    	
	    	// SCORING-RUNNER
	    	
	    	config.setRunnerCaptured(-10);         // penalization-score for the runner to receive when it is captured by the seeker
	    	config.setRunnerFouled(-1000);         // penalization-score for the runner to receive when it steps into the activated restricted area
	    	config.setRunnerSafe(100);			   // score for the runner to receive when it gets to the safe-area
	    	config.setRunnerSpotted(0);		  	   // penalization-score for the runner to receive when it is spotted by the seeker
	    	config.setRunnerSurvived(50);		   // score for the runner to receive when it survives the round (not being captured by the seeker)    	
	    	
	    	// SCORING-SEEKER
	    	
	    	config.setSeekerCapturedRunner(100);   // score for the seeker to receive when it catches the runner
	    	config.setSeekerLetRunnerEscape(-20);  // penalization-score for the seeker to receive when it let the runner escape (runner makes it to the safe-area before seeker)
	    	config.setSeekerLetRunnerSurvive(-10); // penalization-score for the seeker when it let runner survive (runner does not make it to the safe-area neither the seeker manages to catch it
	    	config.setSeekerSpottedRunner(20);	   // score for the seeker to receive when it spots new runner
    	}
    	
    	// START 2 AGENTS FIRST
        new UT2004BotRunner(HideAndSeekBot.class, "HSBot").setMain(false).setLogLevel(Level.WARNING).startAgents(3);
        
        // START UT2004TagServer
        UT2004HSServerModule module = new UT2004HSServerModule();
        UT2004ServerFactory factory = new UT2004ServerFactory(module);
        UT2004ServerRunner serverRunner = new UT2004ServerRunner(factory);
        
        UT2004HSServer server = (UT2004HSServer) serverRunner.setMain(false).startAgent();
                
        // START THE TAG GAME
        server.startGame(config);
        
        // THIS JVM WON'T AUTO-TERMINATE ITSELF!
        // => advanced stuff, won't code here, sorry, terminate manually from IDE
	}
}
