/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.hideandseekbot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.hideandseek.bot.UT2004BotHSController;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSAssignSeeker;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSBotStateChanged;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSPlayerScoreChanged;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRoundEnd;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRoundStart;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRoundState;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerCaptured;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerFouled;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerSafe;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerSpotted;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerSurvived;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

@AgentScoped
public class HideAndSeekBot
extends UT2004BotHSController<UT2004Bot> {
    private static String[] names = new String[]{"Peter", "James", "Johnny", "Craig", "Jimmy", "Steve", "Ronnie", "Bobby"};
    private static int number;
    protected TabooSet<NavPoint> tabooNavPoints;
    protected UT2004PathAutoFixer autoFixer;
    NavPoint hideNavPoint;
    Boolean goingToFoul = null;
    private NavPoint targetNavPoint;

    public Initialize getInitializeCommand() {
        return new Initialize().setName(names[++number % names.length]);
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.tabooNavPoints = new TabooSet(this.bot);
        this.autoFixer = new UT2004PathAutoFixer(this.bot, this.pathExecutor, this.fwMap, this.aStar, this.navBuilder);
        this.pathExecutor.getState().addStrongListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                HideAndSeekBot.this.pathExecutorStateChange(changedValue.getState());
            }
        });
        this.navigation.getLog().setLevel(Level.INFO);
    }

    public void botFirstSpawn(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        this.pathExecutor.getLog().setLevel(Level.WARNING);
    }

    protected void hsRunnerSurvived(HSRunnerSurvived event, boolean me) {
    }

    protected void hsRunnerSpotted(HSRunnerSpotted event, boolean me) {
    }

    protected void hsRunnerSafe(HSRunnerSafe event, boolean me) {
    }

    protected void hsRunnerFouled(HSRunnerFouled event, boolean me) {
    }

    protected void hsRunnerCaptured(HSRunnerCaptured event, boolean me) {
    }

    protected void hsRoundState(HSRoundState event) {
    }

    protected void hsRoundStart(HSRoundStart event) {
        this.hideNavPoint = null;
        this.targetNavPoint = null;
        this.goingToFoul = this.random.nextInt(6) == 5;
        this.tabooNavPoints.clear();
        this.navigation.stopNavigation();
    }

    protected void hsRoundEnd(HSRoundEnd event) {
    }

    protected void hsPlayerScoreChanged(HSPlayerScoreChanged event, boolean me) {
    }

    protected void hsBotStateChanged(HSBotStateChanged event, boolean me) {
    }

    protected void hsAssignSeeker(HSAssignSeeker event, boolean me) {
    }

    public void beforeFirstLogic() {
    }

    public void logic() {
        this.log.info("====== LOGIC ITERATION ======");
        if (!this.hide.isRoundRunning()) {
            return;
        }
        if (!this.hide.isMeAlive()) {
            return;
        }
        switch (this.hide.getMyState()) {
            case RUNNER: {
                this.logicRunner();
                break;
            }
            case RUNNER_SPOTTED: {
                this.logicRunnerSpotted();
                break;
            }
            case SEEKER: {
                this.logicSeeker();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void logState() {
        this.log.info("------      STATE      ------");
        this.log.info("Game state:                  " + this.hide.getGameState());
        this.log.info("Game running:                " + this.hide.isGameRunning());
        if (!this.hide.isGameRunning()) {
            return;
        }
        this.log.info("Round running:               " + this.hide.isRoundRunning());
        if (!this.hide.isRoundRunning()) {
            return;
        }
        this.log.info("Me:                          " + this.hide.getMyState());
        this.log.info("Me spawned?                  " + this.hide.isMeAlive());
        this.log.info("Hiding time left:            " + this.hide.getRemainingHidingTime());
        this.log.info("Restricted area time left:   " + this.hide.getRemainingRestrictedAreaTime());
        this.log.info("Round time left:             " + this.hide.getRemainingRoundTime());
        this.log.info("Distance to safe-area:       " + this.hide.getMySafeAreaDistance());
        this.log.info("Distance to restricted-area: " + this.hide.getMyRestrictedAreaDistance());
    }

    private void logicRunner() {
        this.log.info("------ RUNNER ------");
        if (this.hide.isHidingTime()) {
            if (this.goingToFoul.booleanValue()) {
                this.log.info("GOING TO FOUL! Standing-stil...");
                return;
            }
            this.log.info("HIDING!");
            if (this.hideNavPoint == null) {
                this.hideNavPoint = this.chooseHideNavPoint();
                if (this.hideNavPoint == null) {
                    this.log.warning("THERE IS NO SUITABLE HIDE-POINT TO RUN TO!");
                    return;
                }
            }
            if (this.info.isAtLocation((ILocated)this.hideNavPoint)) {
                if (this.navigation.isNavigating()) {
                    this.navigation.stopNavigation();
                }
                this.log.info("HIDDEN!");
                this.move.turnHorizontal(30);
                return;
            }
            this.navigation.navigate((ILocated)this.hideNavPoint);
            return;
        }
        if (this.hide.isRestrictedAreaActivated()) {
            this.log.info("RESTRICTED AREA ACTIVE, standing still!");
            return;
        }
        this.runToSafePoint();
    }

    private NavPoint chooseHideNavPoint() {
        if (this.visibility.isInitialized()) {
            return (NavPoint)MyCollections.getRandomFiltered((Collection)this.visibility.getCoverNavPointsFrom((ILocated)this.hide.getSafeArea()), (IFilter)new IFilter<NavPoint>(){

                public boolean isAccepted(NavPoint object) {
                    return !HideAndSeekBot.this.hide.isInRestrictedArea((ILocated)object, 50.0);
                }
            });
        }
        return (NavPoint)MyCollections.getRandomFiltered(this.navPoints.getNavPoints().values(), (IFilter)new IFilter<NavPoint>(){

            public boolean isAccepted(NavPoint object) {
                return !HideAndSeekBot.this.hide.isInRestrictedArea((ILocated)object, 50.0);
            }
        });
    }

    private void logicRunnerSpotted() {
        this.runToSafePoint();
    }

    private void runToSafePoint() {
        this.log.info("RUNNING TO SAFE POINT");
        this.navigation.navigate((ILocated)this.hide.getSafeArea());
    }

    private void logicSeeker() {
        this.log.info("------ SEEKER ------");
        if (this.hide.canCaptureRunner()) {
            this.log.info("CAN CAPTURE RUNNER!");
            this.runToSafePoint();
        } else if (this.players.canSeePlayers()) {
            this.targetNavPoint = null;
            this.handlePlayerNavigation(this.players.getNearestVisiblePlayer());
        } else {
            this.handleNavPointNavigation();
        }
    }

    private void handleNavPointNavigation() {
        if (this.navigation.isNavigatingToNavPoint()) {
            while (this.navigation.getContinueTo() == null && this.navigation.getRemainingDistance() < 400.0) {
                this.navigation.setContinueTo((ILocated)this.getRandomNavPoint());
            }
            return;
        }
        this.targetNavPoint = this.getRandomNavPoint();
        if (this.targetNavPoint == null) {
            this.log.severe("COULD NOT CHOOSE ANY NAVIGATION POINT TO RUN TO!!!");
            if (this.world.getAll(NavPoint.class).size() == 0) {
                this.log.severe("world.getAll(NavPoint.class).size() == 0, there are no navigation ponits to choose from! Is exporting of nav points enabled in GameBots2004.ini inside UT2004?");
            }
            this.config.setName("NavigationBot [CRASHED]");
            return;
        }
        this.navigation.navigate((ILocated)this.targetNavPoint);
    }

    private void handlePlayerNavigation(Player player) {
        if (this.navigation.isNavigating() && this.navigation.getCurrentTargetPlayer() == player) {
            return;
        }
        this.navigation.navigate(player);
    }

    public void botKilled(BotKilled event) {
        this.navigation.stopNavigation();
    }

    protected void pathExecutorStateChange(PathExecutorState state) {
        switch (state) {
            case PATH_COMPUTATION_FAILED: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 10.0);
                break;
            }
            case TARGET_REACHED: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 10.0);
                break;
            }
            case STUCK: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 30.0);
                break;
            }
            case STOPPED: {
                this.targetNavPoint = null;
            }
        }
    }

    protected NavPoint getRandomNavPoint() {
        this.log.info("Picking new target navpoint.");
        NavPoint chosen = (NavPoint)MyCollections.getRandomFiltered(this.navPoints.getNavPoints().values(), this.tabooNavPoints);
        if (chosen != null) {
            return chosen;
        }
        this.log.warning("All navpoints are tabooized at this moment, choosing navpoint randomly!");
        return (NavPoint)MyCollections.getRandom(this.navPoints.getNavPoints().values());
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(HideAndSeekBot.class, "HSBot").setMain(true).setLogLevel(Level.WARNING).startAgents(1);
    }

    static {
        List n = MyCollections.toList((Object[])names);
        Collections.shuffle(n);
        names = n.toArray(new String[n.size()]);
        number = 0;
    }
}

