/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.botobserver;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ConfigurationObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.InitializeObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.examples.botobserver.BotObserverParams;
import cz.cuni.amis.pogamut.ut2004.examples.botobserver.ObserverConnectionModule;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ObserverFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ObserverModule;
import cz.cuni.amis.pogamut.ut2004.observer.impl.UT2004Observer;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public class BotObserver
extends UT2004Observer {
    private AnnotationListenerRegistrator listenerRegistrator;
    private boolean observing = false;

    @Inject
    public BotObserver(UT2004AgentParameters params, IComponentBus bus, IAgentLogger agentLogger, UT2004WorldView worldView, IAct act) {
        super(params, bus, agentLogger, worldView, act);
        if (!(params instanceof BotObserverParams)) {
            throw new RuntimeException("BotObserver must be instantiated with BotObserverParams not " + params.getClass().getSimpleName() + ".");
        }
        this.getLogger().addDefaultConsoleHandler();
        this.listenerRegistrator = new AnnotationListenerRegistrator((Object)this, (IWorldView)this.getWorldView(), (Logger)this.getLogger().getCategory("AnnotatedListeners"));
        this.listenerRegistrator.getLog().setLevel(Level.ALL);
        this.listenerRegistrator.addListeners();
        this.listenerRegistrator.getLog().setLevel(Level.WARNING);
    }

    public BotObserverParams getParams() {
        return (BotObserverParams)super.getParams();
    }

    @ObjectClassEventListener(eventClass=WorldObjectUpdatedEvent.class, objectClass=Player.class)
    public void playerEvent(WorldObjectUpdatedEvent<Player> event) {
        if (!this.observing) {
            if (((Player)event.getObject()).getId().getStringId().contains(this.getParams().getBotNameToObserve()) || ((Player)event.getObject()).getName().contains(this.getParams().getBotNameToObserve())) {
                this.getAct().act((CommandMessage)new InitializeObserver().setId(((Player)event.getObject()).getId().getStringId()));
                this.getAct().act((CommandMessage)new ConfigurationObserver().setAll(Boolean.valueOf(true)).setUpdate(Double.valueOf(0.25)).setSelf(Boolean.valueOf(true)).setAsync(Boolean.valueOf(true)).setGame(Boolean.valueOf(false)).setSee(Boolean.valueOf(false)).setSpecial(Boolean.valueOf(false)));
                this.observing = true;
                this.log.info("START OBSERVING: " + ((Player)event.getObject()).getName());
                this.log.info("START OBSERVING: " + event.getObject());
            } else {
                this.log.info("NOT OBSERVING, NAME MISMATCH: " + ((Player)event.getObject()).getName());
                this.log.info("NOT OBSERVING, NAME MISMATCH: " + event.getObject());
            }
        }
    }

    @ObjectClassEventListener(eventClass=WorldObjectUpdatedEvent.class, objectClass=Self.class)
    public void selfEvent(WorldObjectUpdatedEvent<Self> event) {
        Self self = (Self)event.getObject();
        this.log.info("Sensed: " + self);
    }

    public static void startObserver() {
        BotObserverParams params = new BotObserverParams();
        params.setAgentId((IAgentId)new AgentId("Observer"));
        params.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress("127.0.0.1", 3002));
        params.setBotNameToObserve("ObservedBot");
        ObserverConnectionModule module = new ObserverConnectionModule();
        UT2004ObserverFactory observerFactory = new UT2004ObserverFactory((UT2004ObserverModule)module);
        BotObserver observer = (BotObserver)observerFactory.newAgent((IAgentParameters)params);
        observer.start();
    }

    public static void main(String[] args) throws PogamutException {
        BotObserver.startObserver();
    }
}

