/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils;

import cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils.MyLog;
import cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils.Props;
import java.io.File;

public class UT2004Installation {
    public static File[] probe = new File[]{new File("./"), new File("C:/Program files/UT2004"), new File("C:/Program files (x86)/UT2004"), new File("D:/Program files/UT2004"), new File("D:/Program files (x86)/UT2004"), new File("E:/Program files/UT2004"), new File("E:/Program files (x86)/UT2004"), new File("F:/Program files/UT2004"), new File("F:/Program files (x86)/UT2004"), new File("C:/UT2004"), new File("D:/UT2004"), new File("E:/UT2004"), new File("F:/UT2004"), new File("C:/Games/UT2004"), new File("D:/Games/UT2004"), new File("D:/Games/UT2004-Devel"), new File("E:/Games/UT2004"), new File("F:/Games/UT2004"), new File("C:/Program files (x86)/Unreal Anthology"), new File("D:/Program files (x86)/Unreal Anthology"), new File("E:/Program files (x86)/Unreal Anthology"), new File("F:/Program files (x86)/Unreal Anthology")};
    public final File dir;
    public final File ut2004Exe;
    public final File mapsDir;
    public final File gameBots2004U;
    public final File uccExe;

    public UT2004Installation(File ut2004Dir) {
        this.dir = ut2004Dir;
        this.ut2004Exe = new File(this.dir, "System/UT2004.exe");
        this.uccExe = new File(this.dir, "System/ucc.exe");
        this.gameBots2004U = new File(this.dir, "System/GameBots2004.u");
        this.mapsDir = new File(this.dir, "Maps");
    }

    public boolean isGB2004Present() {
        return this.gameBots2004U.isFile() && this.gameBots2004U.exists();
    }

    public boolean isUT2004Dir() {
        return UT2004Installation.isUT2004Dir(this.dir, true);
    }

    private static boolean containsSystemDir(File file) {
        File system = new File(file, "System");
        return system.isDirectory() && system.exists();
    }

    private static boolean containsUT2004Exe(File file) {
        File system = new File(file, "System");
        File ut2004Exe = new File(system, "UT2004.exe");
        return system.isDirectory() && system.exists() && ut2004Exe.isFile() && ut2004Exe.exists();
    }

    private static boolean containsMaps(File file) {
        File maps = new File(file, "Maps");
        return maps.isDirectory() && maps.exists();
    }

    private static boolean containsUCCExe(File file) {
        File system = new File(file, "System");
        File uccExe = new File(system, "UCC.exe");
        return system.isDirectory() && system.exists() && uccExe.isFile() && uccExe.exists();
    }

    private static boolean containsGB2004(File file) {
        File system = new File(file, "System");
        File gb2004 = new File(system, "GameBots2004.u");
        return system.isDirectory() && system.exists() && gb2004.isFile() && gb2004.exists();
    }

    public static boolean isUT2004Dir(File ut2004Dir, boolean logError) {
        if (!ut2004Dir.isDirectory()) {
            if (logError) {
                MyLog.error("Please select UT2004 directory, not a file.");
            }
            return false;
        }
        if (!UT2004Installation.containsSystemDir(ut2004Dir)) {
            if (logError) {
                MyLog.error("Does not seem to be UT2004 directory, 'System' subdir not present.");
            }
            return false;
        }
        if (!UT2004Installation.containsUT2004Exe(ut2004Dir)) {
            if (logError) {
                MyLog.error("Does not seem to be UT2004 directory, 'System\\UT2004.exe' file not present.");
            }
            return false;
        }
        if (!UT2004Installation.containsMaps(ut2004Dir)) {
            if (logError) {
                MyLog.error("Does not seem to be UT2004 directory, 'Maps' subdir not present.");
            }
            return false;
        }
        if (!UT2004Installation.containsUCCExe(ut2004Dir)) {
            if (logError) {
                MyLog.error("Does not seem to be UT2004 directory, 'System\\ucc.exe' file not present.");
            }
            return false;
        }
        return true;
    }

    public static UT2004Installation probeUT2004Dir(File ut2004Dir, boolean logError) {
        if (!UT2004Installation.isUT2004Dir(ut2004Dir, logError)) {
            return null;
        }
        UT2004Installation result = new UT2004Installation(ut2004Dir);
        return result;
    }

    private static UT2004Installation probeDir(File dir) {
        UT2004Installation result = null;
        result = UT2004Installation.probeUT2004Dir(dir, false);
        if (result != null) {
            return result;
        }
        for (File subdir : dir.listFiles()) {
            if (!subdir.isDirectory() || (result = UT2004Installation.probeUT2004Dir(subdir, false)) == null) continue;
            return result;
        }
        return null;
    }

    public static UT2004Installation tryLocateUT2004Installation() {
        for (File dir : probe) {
            UT2004Installation result;
            if (!dir.exists() || !dir.isDirectory() || (result = UT2004Installation.probeDir(dir)) == null) continue;
            return result;
        }
        return null;
    }

    static {
        File[] probeNew = new File[probe.length + 1];
        probeNew[0] = new File(Props.getString("ut2004.home.dir", "./"));
        int i = 1;
        File[] arr$ = probe;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File file;
            probeNew[i] = file = arr$[i$];
            ++i;
        }
        probe = probeNew;
    }
}

