/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class Props {
    public static final String PROPERTY_FILE_NAME = "./files/gui.properties";
    public static final String UT2004_DIR_KEY = "ut2004.home.dir";
    public static final String CONTROL_GUI_TITLE = "control.gui.title";
    public static final String JAVA_DIR_KEY = "java.home.dir";
    public static final String GB2004_ZIP_FILE_KEY = "gb2004.file.zip";
    public static final String POGAMUT_BOTS_DIR = "pogamut.bots.dir";
    public static final String POGAMUT_BOT_SELECTED = "pogamut.bot.selected";
    public static final String POGAMUT_BOT_SKILL = "pogamut.bot.skill";
    public static final String POGAMUT_BOT_SKIN = "pogamut.bot.skin";
    public static final String NATIVE_BOT_SKILL = "native.bot.skill";
    private static Properties properties;

    public static String getProperty(String key, String defaultValue) {
        Object valueObj;
        if (properties == null) {
            Props.loadProperties();
        }
        if ((valueObj = properties.get(key)) == null) {
            if (defaultValue == null) {
                return null;
            }
            properties.put(key, defaultValue);
            return defaultValue;
        }
        return valueObj.toString();
    }

    public static void setProperty(String key, String value) {
        if (properties == null) {
            Props.loadProperties();
        }
        properties.setProperty(key, value);
    }

    private static void loadProperties() {
        File propertyFile = new File(PROPERTY_FILE_NAME);
        if (propertyFile.exists() && propertyFile.isFile()) {
            try {
                properties = new Properties();
                properties.load(new FileInputStream(propertyFile));
            }
            catch (Exception e) {
                properties = new Properties();
            }
        } else {
            properties = new Properties();
        }
    }

    public static void saveProperties() {
        File propertyFile = new File(PROPERTY_FILE_NAME);
        try {
            properties.store(new FileOutputStream(propertyFile), "ControlServerGUI.java properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getString(String key, String defaultValue) {
        return Props.getProperty(key, defaultValue);
    }

    public static int getInt(String key, int defaultValue) {
        String str = Props.getProperty(key, String.valueOf(defaultValue));
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static {
        Props.loadProperties();
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new SavePropertiesThread(), "SavePropertiesThread"));
    }

    private static class SavePropertiesThread
    implements Runnable {
        private SavePropertiesThread() {
        }

        @Override
        public void run() {
            Props.saveProperties();
        }
    }
}

