/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils;

import cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils.Props;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class PogamutBot {
    public String name;
    public File jar;

    public PogamutBot(File jar) {
        this.jar = jar;
        this.name = jar.getName().substring(0, jar.getName().lastIndexOf("."));
    }

    public PogamutBot(String name, File jar) {
        this.name = name;
        this.jar = jar;
        if (name == null || name.trim().equals("")) {
            this.name = jar.getName().substring(0, jar.getName().lastIndexOf("."));
        }
    }

    public String toString() {
        return this.name;
    }

    private static void findBots(File dir, List<PogamutBot> result) {
        if (!dir.isDirectory() || !dir.exists()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                PogamutBot.findBots(file, result);
                return;
            }
            if (!file.isFile() || !file.exists() || !file.getAbsolutePath().endsWith(".jar")) continue;
            File jar = file;
            File nameFile = new File(jar.getAbsolutePath() + ".name");
            String name = null;
            if (nameFile.exists()) {
                List lines;
                try {
                    lines = IOUtils.readLines((Reader)new FileReader(nameFile));
                }
                catch (Exception e) {
                    continue;
                }
                if (lines != null && lines.size() > 0) {
                    name = (String)lines.get(0);
                }
            }
            result.add(new PogamutBot(name, jar));
        }
    }

    public static List<PogamutBot> findBots(File dir) {
        ArrayList<PogamutBot> result = new ArrayList<PogamutBot>();
        PogamutBot.findBots(dir, result);
        Collections.sort(result, new Comparator<PogamutBot>(){

            @Override
            public int compare(PogamutBot o1, PogamutBot o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        });
        return result;
    }

    public static List<PogamutBot> findBots() {
        return PogamutBot.findBots(new File(Props.getString("pogamut.bots.dir", "./files/bots")));
    }
}

