/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.controlservergui;

import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogFormatter;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.execution.UT2004BotExecution;
import cz.cuni.amis.pogamut.ut2004.agent.execution.UT2004BotExecutionConfig;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Console;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Kick;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Record;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopRecord;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils.JavaInstallation;
import cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils.MyLog;
import cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils.PogamutBot;
import cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils.Props;
import cz.cuni.amis.pogamut.ut2004.examples.controlservergui.utils.UT2004Installation;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.SafeEquals;
import cz.cuni.amis.utils.process.ProcessExecution;
import cz.cuni.amis.utils.process.ProcessExecutionConfig;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;
import net.lingala.zip4j.core.ZipFile;

public class ControlServerGUI
extends JFrame {
    public static final String UT2004_SELECTED_MAP_KEY = "ut2004.selected.map";
    private JavaInstallation java;
    private UT2004Installation ut2004;
    private String mapSelected;
    private File[] maps;
    private UCCWrapperConf conf;
    private boolean wrapperKilling = false;
    private UCCWrapper wrapper;
    private final Logger uccLogger;
    private final Handler serverLoggerHandler;
    private final UT2004ServerModule module;
    private final UT2004ServerFactory factory;
    private UT2004Server server;
    private boolean profiling = false;
    private boolean replay = false;
    private boolean players = true;
    private ProcessExecution process;
    private Logger processLogger = Logger.getAnonymousLogger();
    private List<UT2004BotExecution> bots = new ArrayList<UT2004BotExecution>();
    private List<LogPublisher.FilePublisher> filePublishers = new ArrayList<LogPublisher.FilePublisher>();
    private List<String> nextSkillLevelPogamutBot = new ArrayList<String>();
    private List<String> nextSkillLevelNativeBot = new ArrayList<String>();
    private Map<UnrealId, String> skillLevelMap = new HashMap<UnrealId, String>();
    private int botId = 0;
    private JButton btnInstallGB2004;
    private JButton btnKickAll;
    private JButton btnKickBots;
    private JButton btnKickSelected;
    private JButton btnNativeBotAdd;
    private JButton btnPogamutBotAdd;
    private JButton btnRemoveAllDisconnected;
    private JButton btnRemoveSelected;
    private JButton btnSendGB2004Cmd;
    private JButton btnSendUT2004ConsoleCmd;
    private JButton btnSetJavaHome;
    private JButton btnSetUT2004Home;
    private JButton btnStartCTF;
    private JButton btnStartDM;
    private JButton btnStartUT2004GUI;
    private JCheckBox chbPogamutBotSkill;
    private JCheckBox chbPogamutBotSkin;
    private JComboBox cmbNativeBotSkill;
    private JComboBox cmbNativeBotTeam;
    private JComboBox cmbPogamutBotClass;
    private JComboBox cmbPogamutBotSkill;
    private JComboBox cmbPogamutBotSkin;
    private JComboBox cmbPogamutBotTeam;
    private JComboBox cmbSelectMap;
    private JTextField editGB2004Cmd;
    private JTextField editNativeBotName;
    private JTextField editPogamutBotName;
    private JTextField editUT2004ConsoleCommand;
    private JLabel jLabel13;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblBotPort;
    private JLabel lblGB2004ControlServerStatus;
    private JLabel lblGB2004Status;
    private JLabel lblJavaHome;
    private JLabel lblNativeBotName;
    private JLabel lblNativeBotSkill;
    private JLabel lblNativeBotTeam;
    private JLabel lblPogamutBotName;
    private JLabel lblPogamutBotSkill;
    private JLabel lblPogamutBotSkin;
    private JLabel lblPogamutBotTeam;
    private JLabel lblUT2004Home;
    private JTextArea taControlServer;
    private JTextArea taGB2004Console;
    private JTable tblPlayers;
    private JToggleButton tglPlayers;
    private JToggleButton tglProfiling;
    private JToggleButton tglReplay;
    List<PogamutBot> pogamutBots;
    PogamutBot selectedPogamutBot = null;
    private Set<UnrealId> newPlayer = new HashSet<UnrealId>();
    private Map<UnrealId, Object[]> playersAtServers = new HashMap<UnrealId, Object[]>();
    private Set<UnrealId> playersAtServersRemoved = new HashSet<UnrealId>();
    private IWorldObjectListener<Player> playerListener = new IWorldObjectListener<Player>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(IWorldObjectEvent<Player> event) {
            Player plr = (Player)event.getObject();
            if (ControlServerGUI.this.playersAtServers.containsKey(plr.getId())) {
                ControlServerGUI.this.updatePlayerAtServer(plr);
                return;
            }
            Map map = ControlServerGUI.this.playersAtServers;
            synchronized (map) {
                if (ControlServerGUI.this.playersAtServersRemoved.contains(plr.getId())) {
                    return;
                }
                ControlServerGUI.this.newPlayerAtServer(plr);
            }
        }
    };
    private IWorldEventListener<PlayerJoinsGame> playerJoinsGameListener = new IWorldEventListener<PlayerJoinsGame>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(PlayerJoinsGame event) {
            Map map = ControlServerGUI.this.playersAtServers;
            synchronized (map) {
                ControlServerGUI.this.newPlayerAtServer(event.getId(), event.getName());
            }
        }
    };
    private IWorldEventListener<PlayerLeft> playerLeftListener = new IWorldEventListener<PlayerLeft>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(PlayerLeft event) {
            Map map = ControlServerGUI.this.playersAtServers;
            synchronized (map) {
                ControlServerGUI.this.leftPlayerAtServer(event.getId());
            }
        }
    };

    public ControlServerGUI(JavaInstallation java, UT2004Installation ut2004) {
        this.java = java;
        this.ut2004 = ut2004;
        MyLog.app = this;
        this.module = new UT2004ServerModule();
        this.factory = new UT2004ServerFactory(this.module);
        this.uccLogger = Logger.getAnonymousLogger();
        this.uccLogger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                ControlServerGUI.this.logUCC(record.getMessage() + "\n");
            }

            @Override
            public void flush() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void close() throws SecurityException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.serverLoggerHandler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                ControlServerGUI.this.taControlServer.append(record.getMessage() + "\n");
                ControlServerGUI.this.taControlServer.setCaretPosition(ControlServerGUI.this.taControlServer.getText().length());
            }

            @Override
            public void flush() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void close() throws SecurityException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        this.initComponents();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        if (ut2004 != null) {
            this.changeUT2004Dir(ut2004.dir);
        }
        if (java != null) {
            this.lblJavaHome.setText(java.dir.getAbsolutePath());
            Props.setProperty("java.home.dir", java.dir.getPath());
        }
        this.updateButtonState();
        this.enablePlayersAtServer(false);
        this.enableAddBots(false);
        this.tglPlayers.setEnabled(false);
        this.cmbNativeBotSkill.setSelectedIndex(Props.getInt("native.bot.skill", 0));
        this.cmbPogamutBotSkill.setSelectedIndex(Props.getInt("pogamut.bot.skill", 0));
        this.cmbPogamutBotSkin.setSelectedItem(Props.getProperty("pogamut.bot.skin", "Bot.BotA"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.tglReplay = new JToggleButton();
        this.tglProfiling = new JToggleButton();
        this.tglPlayers = new JToggleButton();
        this.jScrollPane1 = new JScrollPane();
        this.taControlServer = new JTextArea();
        this.btnSendGB2004Cmd = new JButton();
        this.btnSendUT2004ConsoleCmd = new JButton();
        this.editGB2004Cmd = new JTextField();
        this.editUT2004ConsoleCommand = new JTextField();
        this.lblUT2004Home = new JLabel();
        this.btnSetUT2004Home = new JButton();
        this.btnStartDM = new JButton();
        this.cmbSelectMap = new JComboBox();
        this.btnStartCTF = new JButton();
        this.lblGB2004ControlServerStatus = new JLabel();
        this.lblBotPort = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.taGB2004Console = new JTextArea();
        this.btnStartUT2004GUI = new JButton();
        this.btnSetJavaHome = new JButton();
        this.lblJavaHome = new JLabel();
        this.btnInstallGB2004 = new JButton();
        this.lblGB2004Status = new JLabel();
        this.jLabel8 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnKickAll = new JButton();
        this.btnKickBots = new JButton();
        this.btnKickSelected = new JButton();
        this.btnRemoveAllDisconnected = new JButton();
        this.btnRemoveSelected = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tblPlayers = new JTable();
        this.jLabel9 = new JLabel();
        this.jPanel3 = new JPanel();
        this.editNativeBotName = new JTextField();
        this.lblNativeBotName = new JLabel();
        this.lblNativeBotSkill = new JLabel();
        this.cmbNativeBotSkill = new JComboBox();
        this.lblNativeBotTeam = new JLabel();
        this.cmbNativeBotTeam = new JComboBox();
        this.btnNativeBotAdd = new JButton();
        this.jLabel13 = new JLabel();
        this.jPanel4 = new JPanel();
        this.editPogamutBotName = new JTextField();
        this.lblPogamutBotName = new JLabel();
        this.lblPogamutBotSkill = new JLabel();
        this.cmbPogamutBotSkill = new JComboBox();
        this.lblPogamutBotTeam = new JLabel();
        this.cmbPogamutBotTeam = new JComboBox();
        this.cmbPogamutBotClass = new JComboBox();
        this.btnPogamutBotAdd = new JButton();
        this.lblPogamutBotSkin = new JLabel();
        this.cmbPogamutBotSkin = new JComboBox();
        this.chbPogamutBotSkin = new JCheckBox();
        this.chbPogamutBotSkill = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.tglReplay.setText("Toggle replay recording");
        this.tglReplay.setEnabled(false);
        this.tglReplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.tglReplayActionPerformed(evt);
            }
        });
        this.tglProfiling.setText("Toggle profiling");
        this.tglProfiling.setEnabled(false);
        this.tglProfiling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.tglProfilingActionPerformed(evt);
            }
        });
        this.tglPlayers.setText("Toggle players exporting");
        this.tglPlayers.setEnabled(false);
        this.tglPlayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.tglPlayersActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tglReplay, -1, -1, Short.MAX_VALUE).addComponent(this.tglProfiling, -1, -1, Short.MAX_VALUE).addComponent(this.tglPlayers, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.tglReplay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tglProfiling).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tglPlayers).addContainerGap(-1, Short.MAX_VALUE)));
        this.taControlServer.setEditable(false);
        this.taControlServer.setColumns(20);
        this.taControlServer.setRows(5);
        this.taControlServer.setEnabled(false);
        this.jScrollPane1.setViewportView(this.taControlServer);
        this.btnSendGB2004Cmd.setText("Send GB2004 Command");
        this.btnSendGB2004Cmd.setEnabled(false);
        this.btnSendGB2004Cmd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnSendGB2004CmdActionPerformed(evt);
            }
        });
        this.btnSendUT2004ConsoleCmd.setText("Send UT2004 Console Command");
        this.btnSendUT2004ConsoleCmd.setEnabled(false);
        this.btnSendUT2004ConsoleCmd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnSendUT2004ConsoleCmdActionPerformed(evt);
            }
        });
        this.editGB2004Cmd.setEnabled(false);
        this.editUT2004ConsoleCommand.setEnabled(false);
        this.editUT2004ConsoleCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.editUT2004ConsoleCommandActionPerformed(evt);
            }
        });
        this.lblUT2004Home.setText("not set ...");
        this.btnSetUT2004Home.setText("Set UT2004 Home");
        this.btnSetUT2004Home.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnSetUT2004HomeActionPerformed(evt);
            }
        });
        this.btnStartDM.setText("Start GB2004 DeathMatch");
        this.btnStartDM.setEnabled(false);
        this.btnStartDM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnStartDMActionPerformed(evt);
            }
        });
        this.cmbSelectMap.setModel(new DefaultComboBoxModel<String>(new String[]{"Select Map..."}));
        this.cmbSelectMap.setEnabled(false);
        this.cmbSelectMap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ControlServerGUI.this.cmbSelectMapItemStateChanged(evt);
            }
        });
        this.cmbSelectMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.cmbSelectMapActionPerformed(evt);
            }
        });
        this.btnStartCTF.setText("Start GB2004 CaptureTheFlag");
        this.btnStartCTF.setEnabled(false);
        this.btnStartCTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnStartCTFActionPerformed(evt);
            }
        });
        this.lblGB2004ControlServerStatus.setText("GB2004 Control Server: not running...");
        this.lblGB2004ControlServerStatus.setEnabled(false);
        this.lblBotPort.setText("Bot/Server/Observer port:");
        this.lblBotPort.setEnabled(false);
        this.taGB2004Console.setColumns(20);
        this.taGB2004Console.setRows(5);
        this.jScrollPane3.setViewportView(this.taGB2004Console);
        this.btnStartUT2004GUI.setText("Start UT2004 Client (Game)");
        this.btnStartUT2004GUI.setEnabled(false);
        this.btnStartUT2004GUI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnStartUT2004GUIActionPerformed(evt);
            }
        });
        this.btnSetJavaHome.setText("Set Java Home");
        this.btnSetJavaHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnSetJavaActionPerformed(evt);
            }
        });
        this.lblJavaHome.setText("not set ...");
        this.btnInstallGB2004.setText("Install GB2004");
        this.btnInstallGB2004.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnInstallGB2004ActionPerformed(evt);
            }
        });
        this.lblGB2004Status.setText("N/A");
        this.lblGB2004Status.setName("gb2004Status");
        this.jLabel8.setText("Players at server");
        this.jLabel8.setEnabled(false);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.btnKickAll.setText("Kick ALL");
        this.btnKickAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnKickAllActionPerformed(evt);
            }
        });
        this.btnKickBots.setText("Kick ALL Bots");
        this.btnKickBots.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnKickBotsActionPerformed(evt);
            }
        });
        this.btnKickSelected.setText("Kick Selected");
        this.btnKickSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnKickSelectedActionPerformed(evt);
            }
        });
        this.btnRemoveAllDisconnected.setText("Remove ALL Disconnected");
        this.btnRemoveAllDisconnected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnRemoveAllDisconnectedActionPerformed(evt);
            }
        });
        this.btnRemoveSelected.setText("Remove Selected");
        this.btnRemoveSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnRemoveSelectedActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnKickSelected, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnKickBots, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnKickAll, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnRemoveAllDisconnected, -1, -1, Short.MAX_VALUE).addComponent(this.btnRemoveSelected, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnKickAll).addComponent(this.btnRemoveAllDisconnected)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnKickBots).addComponent(this.btnRemoveSelected)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnKickSelected).addContainerGap(-1, Short.MAX_VALUE)));
        this.tblPlayers.setModel(new DefaultTableModel(new Object[0][], new String[]{"Connected", "ID", "Name", "Type", "Spectator", "Skill"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, String.class, String.class, String.class, Boolean.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.tblPlayers);
        this.jLabel9.setText("Native bots");
        this.jLabel9.setEnabled(false);
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.editNativeBotName.setName("editNativeBotName");
        this.lblNativeBotName.setText("Name (optional)");
        this.lblNativeBotName.setEnabled(false);
        this.lblNativeBotSkill.setText("Skill (required)");
        this.lblNativeBotSkill.setEnabled(false);
        this.cmbNativeBotSkill.setModel(new DefaultComboBoxModel<String>(new String[]{"0 - Novice", "1 - Average", "2 - Experienced", "3 - Skilled", "4 - Adept", "5 - Materful", "6 - Inhuman", "7 - Godlike"}));
        this.cmbNativeBotSkill.setName("cmbNativeBotSkill");
        this.cmbNativeBotSkill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.cmbNativeBotSkillActionPerformed(evt);
            }
        });
        this.lblNativeBotTeam.setText("Team");
        this.lblNativeBotTeam.setEnabled(false);
        this.cmbNativeBotTeam.setModel(new DefaultComboBoxModel<String>(new String[]{"0 - RED", "1 - BLUE"}));
        this.cmbNativeBotTeam.setName("cmbNativeBotTeam");
        this.cmbNativeBotTeam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.cmbNativeBotTeamActionPerformed(evt);
            }
        });
        this.btnNativeBotAdd.setText("Add Native bot");
        this.btnNativeBotAdd.setAutoscrolls(true);
        this.btnNativeBotAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnNativeBotAddActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblNativeBotTeam, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbNativeBotTeam, 0, -1, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblNativeBotSkill, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbNativeBotSkill, 0, -1, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblNativeBotName, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editNativeBotName, -2, 106, -2)).addComponent(this.btnNativeBotAdd, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.editNativeBotName, -2, -1, -2).addComponent(this.lblNativeBotName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblNativeBotSkill).addComponent(this.cmbNativeBotSkill, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblNativeBotTeam).addComponent(this.cmbNativeBotTeam, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNativeBotAdd).addContainerGap(12, Short.MAX_VALUE)));
        this.jLabel13.setText("Pogamut bots");
        this.jLabel13.setEnabled(false);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.lblPogamutBotName.setText("Name (optional)");
        this.lblPogamutBotName.setEnabled(false);
        this.lblPogamutBotSkill.setText("Skill (required)");
        this.lblPogamutBotSkill.setEnabled(false);
        this.cmbPogamutBotSkill.setModel(new DefaultComboBoxModel<String>(new String[]{"0 - Novice", "1 - Average", "2 - Experienced", "3 - Skilled", "4 - Adept", "5 - Materful", "6 - Inhuman", "7 - Godlike"}));
        this.cmbPogamutBotSkill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.cmbPogamutBotSkillActionPerformed(evt);
            }
        });
        this.lblPogamutBotTeam.setText("Team");
        this.lblPogamutBotTeam.setEnabled(false);
        this.cmbPogamutBotTeam.setModel(new DefaultComboBoxModel<String>(new String[]{"0 - RED", "1 - BLUE"}));
        this.cmbPogamutBotTeam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.cmbPogamutBotTeamActionPerformed(evt);
            }
        });
        this.cmbPogamutBotClass.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbPogamutBotClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.cmbPogamutBotClassActionPerformed(evt);
            }
        });
        this.btnPogamutBotAdd.setText("Add Pogamut bot");
        this.btnPogamutBotAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.btnPogamutBotAddActionPerformed(evt);
            }
        });
        this.lblPogamutBotSkin.setText("Skin");
        this.cmbPogamutBotSkin.setModel(new DefaultComboBoxModel<String>(new String[]{"Aliens.AlienFemaleA", "Aliens.AlienFemaleB", "Aliens.AlienMaleA", "Aliens.AlienMaleB", "Axon", "Barktooth", "Bot.BotA", "Bot.BotB", "Bot.BotC", "Bot.BotD", "Dominator", "HumanFemaleA.EgyptFemaleA", "HumanFemaleA.EgyptFemaleB", "HumanFemaleA.MercFemaleA", "HumanFemaleA.MercFemaleB", "HumanFemaleA.MercFemaleC", "HumanFemaleA.NightFemaleA", "HumanFemaleA.NightFemaleB", "HumanMaleA.MercMaleA", "HumanMaleA.MercMaleB", "HumanMaleA.MercMaleC", "HumanMaleA.NightMaleA", "HumanMaleA.NightMaleB", "Jugg.JuggFemaleA", "Jugg.JuggFemaleB", "Jugg.JuggMaleA", "Jugg.JuggMaleB", "Karag", "Kragoth", "Mekkor", "Ophelia", "PogamutCup", "Roc", "Scarab", "Skrilax", "ThunderCrash.JakobM", " ", " "}));
        this.cmbPogamutBotSkin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.cmbPogamutBotSkinActionPerformed(evt);
            }
        });
        this.chbPogamutBotSkin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.chbPogamutBotSkinActionPerformed(evt);
            }
        });
        this.chbPogamutBotSkill.setToolTipText("");
        this.chbPogamutBotSkill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.chbPogamutBotSkillActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbPogamutBotClass, 0, 441, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnPogamutBotAdd, -1, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPogamutBotName, -2, 98, -2).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.chbPogamutBotSkill).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPogamutBotSkill, -2, 98, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editPogamutBotName).addComponent(this.cmbPogamutBotSkill, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.chbPogamutBotSkin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPogamutBotSkin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbPogamutBotSkin, 0, 1, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.lblPogamutBotTeam, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbPogamutBotTeam, 0, 158, Short.MAX_VALUE)))))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.cmbPogamutBotClass, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.editPogamutBotName, -2, -1, -2).addComponent(this.lblPogamutBotName).addComponent(this.lblPogamutBotTeam).addComponent(this.cmbPogamutBotTeam, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbPogamutBotSkin, -2, -1, -2).addComponent(this.lblPogamutBotSkin)).addComponent(this.chbPogamutBotSkill, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chbPogamutBotSkin).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbPogamutBotSkill, -2, -1, -2).addComponent(this.lblPogamutBotSkill)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPogamutBotAdd).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblGB2004ControlServerStatus, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel9).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -2, -1, -2).addComponent(this.jScrollPane2, -2, 464, -2)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnInstallGB2004, -2, 157, -2).addGroup(layout.createSequentialGroup().addComponent(this.btnSetJavaHome, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblJavaHome, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 575, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnSendGB2004Cmd, -1, -1, Short.MAX_VALUE).addComponent(this.btnSendUT2004ConsoleCmd, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editUT2004ConsoleCommand, -2, 382, -2).addComponent(this.editGB2004Cmd, GroupLayout.Alignment.TRAILING, -2, 382, -2)))))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbSelectMap, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnStartDM, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnStartCTF)).addComponent(this.btnStartUT2004GUI, -1, -1, Short.MAX_VALUE).addComponent(this.lblBotPort, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 390, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.btnSetUT2004Home, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblGB2004Status, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.lblUT2004Home, -1, -1, Short.MAX_VALUE)))).addGap(512, 512, 512))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSetJavaHome).addComponent(this.lblJavaHome)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSetUT2004Home).addComponent(this.lblUT2004Home)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnInstallGB2004).addComponent(this.lblGB2004Status)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.cmbSelectMap, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnStartCTF).addComponent(this.btnStartDM)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblBotPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnStartUT2004GUI, -2, 23, -2)).addComponent(this.jScrollPane3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblGB2004ControlServerStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSendGB2004Cmd).addComponent(this.editGB2004Cmd, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSendUT2004ConsoleCmd).addComponent(this.editUT2004ConsoleCommand, -2, 21, -2))).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -2, 107, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel9, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void editUT2004ConsoleCommandActionPerformed(ActionEvent evt) {
    }

    private void btnStartDMActionPerformed(ActionEvent evt) {
        if (this.wrapper == null) {
            this.taControlServer.setText("");
            this.taGB2004Console.setText("");
            this.enablePathSet(false);
            this.btnSetJavaHome.setEnabled(true);
            this.startGB2004_DM();
        } else {
            this.btnStartDM.setText("Stopping...");
            this.btnStartDM.setEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ControlServerGUI.this.stopUcc();
                    ControlServerGUI.this.btnStartDM.setText("Start GB2004 DeathMatch");
                    ControlServerGUI.this.btnStartDM.setEnabled(true);
                }
            }).start();
        }
    }

    private void cmbSelectMapActionPerformed(ActionEvent evt) {
    }

    private void btnStartCTFActionPerformed(ActionEvent evt) {
        if (this.wrapper == null) {
            this.taControlServer.setText("");
            this.taGB2004Console.setText("");
            this.enablePathSet(false);
            this.btnSetJavaHome.setEnabled(true);
            this.startGB2004_CTF();
        } else {
            this.btnStartCTF.setText("Stopping...");
            this.btnStartCTF.setEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ControlServerGUI.this.stopUcc();
                    ControlServerGUI.this.btnStartCTF.setText("Start GB2004 CaptureTheFlag");
                    ControlServerGUI.this.btnStartCTF.setEnabled(true);
                }
            }).start();
        }
    }

    private void btnSetUT2004HomeActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setFileSelectionMode(1);
        int returnVal = jFileChooser1.showOpenDialog(this);
        if (returnVal == 0) {
            File file = jFileChooser1.getSelectedFile();
            if (!this.checkUT2004Dir(file, true)) {
                return;
            }
            this.changeUT2004Dir(file);
        }
    }

    private void cmbSelectMapItemStateChanged(ItemEvent evt) {
        this.mapChanged();
    }

    private void tglProfilingActionPerformed(ActionEvent evt) {
        this.toggleProfiling();
    }

    private void btnSendGB2004CmdActionPerformed(ActionEvent evt) {
        this.sendServerMessage(this.editGB2004Cmd.getText());
    }

    private void btnSendUT2004ConsoleCmdActionPerformed(ActionEvent evt) {
        this.sendConsoleCommand(this.editUT2004ConsoleCommand.getText());
    }

    private void tglReplayActionPerformed(ActionEvent evt) {
        this.toggleReplay();
    }

    private void tglPlayersActionPerformed(ActionEvent evt) {
        this.togglePlayers();
    }

    private void btnStartUT2004GUIActionPerformed(ActionEvent evt) {
        if (this.process == null) {
            this.openUT2004GUI();
        } else {
            this.closeUT2004GUI();
        }
    }

    private void btnSetJavaActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setFileSelectionMode(1);
        int returnVal = jFileChooser1.showOpenDialog(this);
        if (returnVal == 0) {
            File file = jFileChooser1.getSelectedFile();
            if (!JavaInstallation.isJavaDir(file, true)) {
                return;
            }
            this.changeJava(file);
        }
    }

    private void btnInstallGB2004ActionPerformed(ActionEvent evt) {
        if (this.ut2004 == null) {
            MyLog.error("Could not install GB2004 as there is no UT2004 directory selected. Press 'Set UT2004 Home' button first.");
            return;
        }
        File zipFile = new File(Props.getString("gb2004.file.zip", "./files/GB2004.zip"));
        if (!zipFile.isFile() || !zipFile.exists()) {
            MyLog.error("Could not locate GB2004.zip file at '" + zipFile.getAbsolutePath() + "'. Could not install GB2004. Check settings within " + "./files/gui.properties" + ".");
        }
        try {
            ZipFile zip = new ZipFile(zipFile);
            zip.extractAll(this.ut2004.dir.getAbsolutePath());
        }
        catch (Exception e) {
            MyLog.error(ExceptionToString.process((String)"Failed to install GB2004!", (Throwable)e));
            return;
        }
        if (!this.ut2004.isGB2004Present()) {
            MyLog.error("Even though GB2004 was unpacked into UT2004, they are still not present there. Check contents of the file '" + zipFile.getAbsolutePath() + "' whether the zip truly contains GB2004. If so, try to unzip it into UT2004 manually. Note that GameBots2004.u should be placed into UT2004/System directory.");
            return;
        }
        MyLog.info("GB2004 installed!");
        this.lblGB2004Status.setText(this.ut2004.gameBots2004U.getAbsolutePath());
        this.updateButtonState();
    }

    private void cmbNativeBotSkillActionPerformed(ActionEvent evt) {
        int skill = this.cmbNativeBotSkill.getSelectedIndex();
        Props.setProperty("native.bot.skill", String.valueOf(skill));
    }

    private void cmbNativeBotTeamActionPerformed(ActionEvent evt) {
    }

    private void cmbPogamutBotSkillActionPerformed(ActionEvent evt) {
        int skill = this.cmbPogamutBotSkill.getSelectedIndex();
        Props.setProperty("pogamut.bot.skill", String.valueOf(skill));
    }

    private void cmbPogamutBotTeamActionPerformed(ActionEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnKickAllActionPerformed(ActionEvent evt) {
        Map<UnrealId, Object[]> map = this.playersAtServers;
        synchronized (map) {
            for (UnrealId id : this.playersAtServers.keySet()) {
                this.server.getAct().act((CommandMessage)new Kick(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnKickBotsActionPerformed(ActionEvent evt) {
        Map<UnrealId, Object[]> map = this.playersAtServers;
        synchronized (map) {
            for (UnrealId id : this.playersAtServers.keySet()) {
                if (id.getStringId().indexOf("Bot") < 0) continue;
                this.server.getAct().act((CommandMessage)new Kick(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnKickSelectedActionPerformed(ActionEvent evt) {
        Map<UnrealId, Object[]> map = this.playersAtServers;
        synchronized (map) {
            int r = this.tblPlayers.getSelectedRow();
            if (r < 0 || r >= this.tblPlayers.getModel().getRowCount()) {
                return;
            }
            String id = this.tblPlayers.getModel().getValueAt(r, 1).toString();
            UnrealId uId = UnrealId.get((String)id);
            this.server.getAct().act((CommandMessage)new Kick(uId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnRemoveAllDisconnectedActionPerformed(ActionEvent evt) {
        Map<UnrealId, Object[]> map = this.playersAtServers;
        synchronized (map) {
            DefaultTableModel model = (DefaultTableModel)this.tblPlayers.getModel();
            int i = 0;
            while (i < model.getRowCount()) {
                boolean connected = (Boolean)model.getValueAt(i, 0);
                if (!connected) {
                    model.removeRow(i);
                    continue;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnRemoveSelectedActionPerformed(ActionEvent evt) {
        Map<UnrealId, Object[]> map = this.playersAtServers;
        synchronized (map) {
            int r = this.tblPlayers.getSelectedRow();
            if (r < 0 || r >= this.tblPlayers.getModel().getRowCount()) {
                return;
            }
            String id = this.tblPlayers.getModel().getValueAt(r, 1).toString();
            UnrealId uId = UnrealId.get((String)id);
            boolean connected = (Boolean)this.tblPlayers.getModel().getValueAt(r, 0);
            if (connected) {
                this.server.getAct().act((CommandMessage)new Kick(uId));
                this.leftPlayerAtServer(uId);
            }
            ((DefaultTableModel)this.tblPlayers.getModel()).removeRow(r);
        }
    }

    private void btnNativeBotAddActionPerformed(ActionEvent evt) {
        String name = this.editNativeBotName.getText();
        int skillLevel = this.cmbNativeBotSkill.getSelectedIndex();
        int team = this.cmbNativeBotTeam.getSelectedIndex();
        this.nextSkillLevelNativeBot.add(String.valueOf(skillLevel));
        AddBot cmd = new AddBot().setName(name.trim().equals("") ? null : name.trim()).setSkill(Integer.valueOf(skillLevel)).setTeam(Integer.valueOf(team));
        this.server.getAct().act((CommandMessage)cmd);
    }

    private Logger getBotLogger(String name, String outputPath) {
        LogCategory log = new LogCategory("BOT-" + name);
        LogPublisher.FilePublisher filePublisher = new LogPublisher.FilePublisher(new File(outputPath), (Formatter)new LogFormatter());
        filePublisher.setImmediateFlush(true);
        this.filePublishers.add(filePublisher);
        log.addHandler((ILogPublisher)filePublisher);
        log.setLevel(Level.ALL);
        return log;
    }

    private void btnPogamutBotAddActionPerformed(ActionEvent evt) {
        PogamutBot bot = this.selectedPogamutBot;
        if (bot == null) {
            return;
        }
        String name = this.editPogamutBotName.getText();
        if (name != null && name.trim().length() == 0) {
            name = null;
        }
        boolean skillLevelSet = this.chbPogamutBotSkill.isSelected();
        int skillLevel = this.cmbPogamutBotSkill.getSelectedIndex();
        int team = this.cmbPogamutBotTeam.getSelectedIndex();
        boolean skinSet = this.chbPogamutBotSkin.isSelected();
        String skin = this.cmbPogamutBotSkin.getSelectedItem().toString();
        UT2004BotExecutionConfig config = new UT2004BotExecutionConfig();
        config.setBotId((IToken)Tokens.get((long)(++this.botId)));
        config.setPathToBotJar(bot.jar.getAbsolutePath());
        config.setRedirectStdErr(true);
        config.setRedirectStdOut(true);
        config.setBotName(name);
        if (skillLevelSet) {
            config.setBotSkill(Integer.valueOf(skillLevel));
            this.nextSkillLevelPogamutBot.add(String.valueOf(skillLevel));
        } else {
            this.nextSkillLevelPogamutBot.add("?");
        }
        if (this.isTeamGame()) {
            config.setBotTeam(Integer.valueOf(team));
        }
        if (skinSet) {
            config.setBotSkin(skin);
        }
        String logPath = bot.jar.getAbsolutePath() + "-" + config.getBotId().getToken() + ".log";
        File logFile = new File(logPath);
        int variant = 0;
        while (logFile.exists() && !logFile.delete()) {
            logPath = bot.jar.getAbsolutePath() + "-" + config.getBotId().getToken() + "." + variant++ + ".log";
            logFile = new File(logPath);
        }
        MyLog.info("Executing the bot!\nJAVA: " + this.java.dir.getAbsolutePath() + "\nBOT: " + bot.jar.getAbsolutePath());
        UT2004BotExecution exec = new UT2004BotExecution(config, this.getBotLogger(config.getBotId().getToken(), logFile.getAbsolutePath()));
        try {
            exec.start(this.wrapper.getHost(), this.wrapper.getBotPort(), this.java.dir.getAbsolutePath());
        }
        catch (Exception e) {
            MyLog.error(ExceptionToString.process((String)"Failed to start the bot. Check whether JAVA installation is present at the path.", (Throwable)e));
            return;
        }
        MyLog.info("Bot started, it will take about 10-30 seconds for it to appear in the list of players.\nPlease be patient. If it does not... you may consult the log file in the directory of bot's jar file.");
        this.bots.add(exec);
    }

    private void cmbPogamutBotSkinActionPerformed(ActionEvent evt) {
        String skin = this.cmbPogamutBotSkin.getSelectedItem().toString();
        Props.setProperty("pogamut.bot.skin", skin);
    }

    private void chbPogamutBotSkillActionPerformed(ActionEvent evt) {
        this.cmbPogamutBotSkill.setEnabled(this.chbPogamutBotSkill.isSelected());
    }

    private void chbPogamutBotSkinActionPerformed(ActionEvent evt) {
        this.cmbPogamutBotSkin.setEnabled(this.chbPogamutBotSkin.isSelected());
    }

    private void cmbPogamutBotClassActionPerformed(ActionEvent evt) {
        Props.setProperty("pogamut.bot.selected", this.cmbPogamutBotClass.getSelectedItem().toString());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        new ControlServerGUI(JavaInstallation.tryLocateJavaInstallation(), UT2004Installation.tryLocateUT2004Installation()).setVisible(true);
    }

    private void changeJava(File file) {
        if (file == null) {
            return;
        }
        Props.setProperty("java.home.dir", file.getAbsolutePath());
        Props.saveProperties();
        this.java = new JavaInstallation(file);
        this.lblJavaHome.setText(this.java.dir.getAbsolutePath());
        this.updateButtonState();
    }

    private void changeUT2004Dir(File file) {
        if (file == null) {
            return;
        }
        Props.setProperty("ut2004.home.dir", file.getAbsolutePath());
        Props.saveProperties();
        this.ut2004 = new UT2004Installation(file);
        this.lblUT2004Home.setText(this.ut2004.dir.getAbsolutePath());
        if (this.ut2004.isGB2004Present()) {
            this.lblGB2004Status.setText(this.ut2004.gameBots2004U.getAbsolutePath());
            this.btnInstallGB2004.setText("Reinstall GB2004");
        } else {
            this.lblGB2004Status.setText("N/A");
            this.btnInstallGB2004.setText("Install GB2004");
        }
        this.updateButtonState();
    }

    private void updateButtonState() {
        if (this.ut2004 != null && this.ut2004.isGB2004Present() && this.java != null) {
            this.enableStartMatchAndControlServer(false);
            this.enableUT2004Start();
        } else {
            this.enableStartMatchAndControlServer(false);
        }
    }

    private void enablePathSet(boolean state) {
        this.btnSetJavaHome.setEnabled(state);
        this.btnSetUT2004Home.setEnabled(state);
        this.btnInstallGB2004.setEnabled(state);
    }

    private void enableStartMatchAndControlServer(boolean state) {
        this.tglReplay.setEnabled(state);
        this.tglProfiling.setEnabled(state);
        this.taControlServer.setEnabled(state);
        this.btnSendGB2004Cmd.setEnabled(state);
        this.btnSendUT2004ConsoleCmd.setEnabled(state);
        this.editGB2004Cmd.setEnabled(state);
        this.editGB2004Cmd.setEditable(state);
        this.editUT2004ConsoleCommand.setEnabled(state);
        this.editUT2004ConsoleCommand.setEditable(state);
        this.btnStartDM.setEnabled(state);
        this.cmbSelectMap.setEnabled(state);
        this.btnStartCTF.setEnabled(state);
        this.btnStartUT2004GUI.setEnabled(state);
        this.taGB2004Console.setEnabled(state);
        this.lblGB2004ControlServerStatus.setEnabled(state);
        this.lblBotPort.setEnabled(state);
    }

    private void enableUT2004Start() {
        this.cmbSelectMap.setEnabled(true);
        this.maps = this.loadMaps();
        this.cmbSelectMap.setModel(new ComboBoxModel(){

            @Override
            public void setSelectedItem(Object anItem) {
                ControlServerGUI.this.mapSelected = (String)anItem;
            }

            @Override
            public Object getSelectedItem() {
                return ControlServerGUI.this.mapSelected;
            }

            @Override
            public int getSize() {
                return ControlServerGUI.this.maps.length;
            }

            @Override
            public Object getElementAt(int index) {
                return ControlServerGUI.this.maps[index].getName();
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.cmbSelectMap.setSelectedIndex(this.getMapSelectedIndex());
        this.mapChanged();
    }

    private void enablePlayersAtServer(boolean state) {
        this.jLabel8.setEnabled(state);
        this.jPanel2.setEnabled(state);
        this.tblPlayers.setEnabled(state);
        this.btnKickAll.setEnabled(state);
        this.btnKickBots.setEnabled(state);
        this.btnKickSelected.setEnabled(state);
        this.btnRemoveAllDisconnected.setEnabled(state);
        this.btnRemoveSelected.setEnabled(state);
    }

    private boolean isTeamGame() {
        if (this.server == null) {
            return false;
        }
        if (!(this.server.getState().getFlag() instanceof IAgentStateUp)) {
            return false;
        }
        GameInfo gi = (GameInfo)((UT2004WorldView)this.server.getWorldView()).getSingle(GameInfo.class);
        return !gi.getGametype().toLowerCase().contains("botdeathmatch");
    }

    private void enableAddBots(boolean state) {
        this.jLabel9.setEnabled(state);
        this.jPanel3.setEnabled(state);
        this.lblNativeBotName.setEnabled(state);
        this.lblNativeBotSkill.setEnabled(state);
        this.lblNativeBotTeam.setEnabled(state && this.isTeamGame());
        this.editNativeBotName.setEnabled(state);
        this.cmbNativeBotSkill.setEnabled(state);
        this.cmbNativeBotTeam.setEnabled(state && this.isTeamGame());
        this.btnNativeBotAdd.setEnabled(state);
        this.populatePogamutBots();
        this.jLabel13.setEnabled(state);
        this.jPanel4.setEnabled(state);
        this.lblPogamutBotName.setEnabled(state && this.pogamutBots.size() > 0);
        this.cmbPogamutBotClass.setEnabled(state);
        this.editPogamutBotName.setEnabled(state && this.pogamutBots.size() > 0);
        this.chbPogamutBotSkill.setEnabled(state && this.pogamutBots.size() > 0);
        this.lblPogamutBotSkill.setEnabled(state && this.pogamutBots.size() > 0);
        this.cmbPogamutBotSkill.setEnabled(state && this.chbPogamutBotSkill.isSelected() && this.pogamutBots.size() > 0);
        this.lblPogamutBotTeam.setEnabled(state && this.isTeamGame() && this.pogamutBots.size() > 0);
        this.cmbPogamutBotTeam.setEnabled(state && this.isTeamGame() && this.pogamutBots.size() > 0);
        this.chbPogamutBotSkin.setEnabled(state && this.pogamutBots.size() > 0);
        this.lblPogamutBotSkin.setEnabled(state && this.pogamutBots.size() > 0);
        this.cmbPogamutBotSkin.setEnabled(state && this.chbPogamutBotSkin.isSelected() && this.pogamutBots.size() > 0);
        this.btnPogamutBotAdd.setEnabled(state && this.pogamutBots.size() > 0);
    }

    private void populatePogamutBots() {
        this.pogamutBots = PogamutBot.findBots();
        if (this.selectedPogamutBot == null) {
            String lastSelected = Props.getString("pogamut.bot.selected", "N/A");
            if (lastSelected != null && !lastSelected.equals("N/A")) {
                for (PogamutBot bot : this.pogamutBots) {
                    if (!SafeEquals.equals((Object)bot.toString(), (Object)lastSelected)) continue;
                    this.selectedPogamutBot = bot;
                    break;
                }
            } else if (this.pogamutBots.size() > 0) {
                this.selectedPogamutBot = this.pogamutBots.get(0);
            }
        }
        this.cmbPogamutBotClass.setModel(new ComboBoxModel(){

            @Override
            public void setSelectedItem(Object anItem) {
                ControlServerGUI.this.selectedPogamutBot = (PogamutBot)anItem;
            }

            @Override
            public Object getSelectedItem() {
                return ControlServerGUI.this.selectedPogamutBot;
            }

            @Override
            public int getSize() {
                return ControlServerGUI.this.pogamutBots.size();
            }

            @Override
            public Object getElementAt(int index) {
                return ControlServerGUI.this.pogamutBots.get(index);
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.cmbSelectMap.setSelectedIndex(this.getMapSelectedIndex());
    }

    private File[] loadMaps() {
        if (this.ut2004 == null) {
            return new File[0];
        }
        File[] files = this.ut2004.mapsDir.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".ut2")) continue;
            result.add(file);
        }
        return result.toArray(new File[0]);
    }

    private int getMapSelectedIndex() {
        if (this.maps == null) {
            return 0;
        }
        String mapName = Props.getProperty(UT2004_SELECTED_MAP_KEY, "DM-1on1-Albatross.ut2");
        int index = -1;
        for (File map : this.maps) {
            ++index;
            if (!map.getName().contains(mapName)) continue;
            return index;
        }
        for (File map : this.maps) {
            ++index;
            if (!map.getName().contains("DM-1on1-Albatross")) continue;
            Props.setProperty(UT2004_SELECTED_MAP_KEY, map.getName());
            return index;
        }
        return 0;
    }

    private void mapChanged() {
        File map = this.getSelectedMap();
        if (map == null) {
            this.btnStartDM.setEnabled(false);
            this.btnStartCTF.setEnabled(false);
        } else {
            Props.setProperty(UT2004_SELECTED_MAP_KEY, this.getSelectedMapName());
            if (map.getName().startsWith("DM")) {
                this.btnStartDM.setEnabled(true);
                this.btnStartCTF.setEnabled(false);
            } else if (map.getName().startsWith("CTF")) {
                this.btnStartDM.setEnabled(false);
                this.btnStartCTF.setEnabled(true);
            } else {
                this.btnStartDM.setEnabled(true);
                this.btnStartCTF.setEnabled(true);
            }
        }
    }

    private File getSelectedMap() {
        if (this.cmbSelectMap.getSelectedIndex() < 0) {
            return null;
        }
        return this.maps[this.cmbSelectMap.getSelectedIndex()];
    }

    private void startGB2004_DM() {
        if (this.ut2004 == null) {
            MyLog.error("Cannot start DM match as the path to UT2004 is not specified!");
            return;
        }
        this.cmbSelectMap.setEnabled(false);
        this.taGB2004Console.setEnabled(true);
        this.conf = new UCCWrapperConf();
        this.conf.setUnrealHome(this.ut2004.dir.getAbsolutePath());
        this.conf.setMapName(this.getSelectedMapName());
        this.conf.setGameType("GameBots2004.BotDeathMatch");
        this.conf.setLogger(this.uccLogger);
        this.conf.setStartOnUnusedPort(false);
        this.btnStartDM.setEnabled(false);
        this.btnStartDM.setText("Starting...");
        this.btnStartCTF.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlServerGUI.this.startUcc();
            }
        }).start();
    }

    private void startGB2004_CTF() {
        if (this.ut2004 == null) {
            MyLog.error("Cannot start CTF match as the path to UT2004 is not specified!");
            return;
        }
        this.cmbSelectMap.setEnabled(false);
        this.taGB2004Console.setEnabled(true);
        this.conf = new UCCWrapperConf();
        this.conf.setUnrealHome(this.ut2004.dir.getAbsolutePath());
        this.conf.setMapName(this.getSelectedMapName());
        this.conf.setGameType("GameBots2004.BotDeathMatch");
        this.conf.setLogger(this.uccLogger);
        this.conf.setStartOnUnusedPort(false);
        this.btnStartCTF.setEnabled(false);
        this.btnStartCTF.setText("Starting...");
        this.btnStartDM.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlServerGUI.this.startUcc();
            }
        }).start();
    }

    private void startUcc() {
        this.wrapper = new UCCWrapper(this.conf);
        this.lblBotPort.setText("Bot/Server/Observer port: " + this.wrapper.getBotPort() + "/" + this.wrapper.getControlPort() + "/" + this.wrapper.getObserverPort());
        this.lblBotPort.setEnabled(true);
        this.btnStartDM.setEnabled(true);
        this.btnStartDM.setText("Running (click to stop)");
        this.btnStartUT2004GUI.setEnabled(true);
        this.startControlServer();
    }

    private String getSelectedMapName() {
        File map = this.getSelectedMap();
        if (map == null) {
            return null;
        }
        return map.getName().substring(0, map.getName().lastIndexOf("."));
    }

    private void startControlServer() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                UT2004ServerRunner runner = new UT2004ServerRunner((IAgentFactory)ControlServerGUI.this.factory, "ControlServer", "localhost", ControlServerGUI.this.wrapper.getControlPort());
                try {
                    ControlServerGUI.this.server = (UT2004Server)runner.setLogLevel(Level.FINE).startAgent();
                }
                catch (Exception e) {
                    ControlServerGUI.this.displayError(e.getClass() + ": " + e.getMessage());
                    ControlServerGUI.this.server = null;
                    return;
                }
                ControlServerGUI.this.server.getLogger().setLevel(Level.FINE);
                ControlServerGUI.this.server.getLogger().addDefaultHandler(ControlServerGUI.this.serverLoggerHandler);
                ControlServerGUI.this.serverStarted();
                if (ControlServerGUI.this.profiling) {
                    ControlServerGUI.this.startProfiling();
                }
                if (ControlServerGUI.this.replay) {
                    ControlServerGUI.this.startReplay();
                }
                if (!ControlServerGUI.this.players) {
                    ControlServerGUI.this.endPlayers();
                }
                while (ControlServerGUI.this.playersAtServers.size() > 0) {
                    ControlServerGUI.this.leftPlayerAtServer((UnrealId)ControlServerGUI.this.playersAtServers.keySet().iterator().next());
                }
            }
        }).start();
    }

    protected void newPlayerAtServer(Player player) {
        this.newPlayerAtServer(player.getId(), player.getName());
        this.updatePlayerAtServer(player);
    }

    protected void newPlayerAtServer(UnrealId id, String name) {
        this.newPlayer.add(id);
        this.playersAtServersRemoved.remove(id);
        Object[] row = new Object[]{true, id.getStringId(), "", "", false, ""};
        ((DefaultTableModel)this.tblPlayers.getModel()).insertRow(0, row);
        this.playersAtServers.put(id, row);
    }

    private int getPlayersTableRow(UnrealId id) {
        DefaultTableModel model = (DefaultTableModel)this.tblPlayers.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (!model.getValueAt(i, 1).toString().equals(id.getStringId())) continue;
            return i;
        }
        return -1;
    }

    private void leftPlayerAtServer(UnrealId id) {
        this.playersAtServersRemoved.add(id);
        int rowIndex = this.getPlayersTableRow(id);
        if (rowIndex < 0 || rowIndex >= this.tblPlayers.getModel().getRowCount()) {
            return;
        }
        Object[] row = this.playersAtServers.get(id);
        row[0] = false;
        this.updatePlayersTableRow(rowIndex);
        ((DefaultTableModel)this.tblPlayers.getModel()).setValueAt(false, rowIndex, 0);
        this.playersAtServers.remove(id);
    }

    private void updatePlayerAtServer(Player plr) {
        boolean human;
        int rowIndex = this.getPlayersTableRow(plr.getId());
        if (rowIndex < 0 || rowIndex >= this.tblPlayers.getModel().getRowCount()) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.tblPlayers.getModel();
        boolean pogamutBot = plr.getId().getStringId().indexOf("Bot") >= 0 && plr.getJmx() != null;
        boolean nativeBot = plr.getId().getStringId().indexOf("Bot") >= 0 && !pogamutBot;
        boolean bl = human = !pogamutBot && !nativeBot;
        if (this.newPlayer.contains(plr.getId())) {
            this.newPlayer.remove(plr.getId());
            if (human) {
                this.skillLevelMap.put(plr.getId(), "?");
            }
            if (nativeBot && this.nextSkillLevelNativeBot.size() > 0) {
                this.skillLevelMap.put(plr.getId(), this.nextSkillLevelNativeBot.get(0));
                this.nextSkillLevelNativeBot.remove(0);
            }
            if (pogamutBot && this.nextSkillLevelPogamutBot.size() > 0) {
                this.skillLevelMap.put(plr.getId(), this.nextSkillLevelPogamutBot.get(0));
                this.nextSkillLevelPogamutBot.remove(0);
            }
        }
        model.setValueAt(true, rowIndex, 0);
        model.setValueAt(plr.getName(), rowIndex, 2);
        model.setValueAt(human ? "Human" : (pogamutBot ? "PogamutBot" : "NativeBot"), rowIndex, 3);
        model.setValueAt(plr.isSpectator(), rowIndex, 4);
        model.setValueAt(this.skillLevelMap.get(plr.getId()), rowIndex, 5);
        this.updatePlayersTableRow(rowIndex);
    }

    private void updatePlayersTableRow(int rowIndex) {
        DefaultTableModel model = (DefaultTableModel)this.tblPlayers.getModel();
        for (int col = 0; col < model.getColumnCount(); ++col) {
            model.fireTableCellUpdated(rowIndex, col);
        }
    }

    private void serverStarted() {
        this.nextSkillLevelPogamutBot.clear();
        this.nextSkillLevelNativeBot.clear();
        this.skillLevelMap.clear();
        this.playersAtServers.clear();
        this.playersAtServersRemoved.clear();
        this.newPlayer.clear();
        ((UT2004WorldView)this.server.getWorldView()).addEventListener(PlayerJoinsGame.class, this.playerJoinsGameListener);
        ((UT2004WorldView)this.server.getWorldView()).addEventListener(PlayerLeft.class, this.playerLeftListener);
        ((UT2004WorldView)this.server.getWorldView()).addObjectListener(Player.class, this.playerListener);
        this.lblGB2004ControlServerStatus.setEnabled(true);
        this.lblGB2004ControlServerStatus.setText("GB2004 Control Server: running");
        this.tglReplay.setEnabled(true);
        this.tglProfiling.setEnabled(true);
        this.tglPlayers.setEnabled(false);
        this.taControlServer.setEnabled(true);
        this.btnSendGB2004Cmd.setEnabled(true);
        this.btnSendUT2004ConsoleCmd.setEnabled(true);
        this.editGB2004Cmd.setEditable(true);
        this.editUT2004ConsoleCommand.setEditable(true);
        this.enablePlayersAtServer(true);
        this.enableAddBots(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopUcc() {
        if (this.wrapperKilling) {
            return;
        }
        this.wrapperKilling = true;
        try {
            block42: {
                try {
                    this.btnStartUT2004GUI.setEnabled(false);
                    this.lblGB2004ControlServerStatus.setEnabled(false);
                    this.tglReplay.setEnabled(false);
                    this.tglProfiling.setEnabled(false);
                    this.tglPlayers.setEnabled(false);
                    this.taControlServer.setEditable(false);
                    this.btnSendGB2004Cmd.setEnabled(false);
                    this.btnSendUT2004ConsoleCmd.setEnabled(false);
                    this.editGB2004Cmd.setEditable(false);
                    this.editUT2004ConsoleCommand.setEditable(false);
                    this.lblBotPort.setEnabled(false);
                    this.enablePlayersAtServer(false);
                    this.enableAddBots(false);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.process != null) {
                        this.closeUT2004GUISync();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.server == null) break block42;
                    try {
                        this.server.stop();
                    }
                    catch (Exception e) {
                    }
                    finally {
                        try {
                            this.server.getLogger().removeDefaultHandler(this.serverLoggerHandler);
                        }
                        catch (Exception e) {}
                    }
                    this.server = null;
                    this.logControlServer("STOPPED\n");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.lblGB2004ControlServerStatus.setText("GB2004 Control Server: not running...");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.wrapper != null) {
                    try {
                        this.wrapper.stop();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.wrapper = null;
            try {
                this.logUCC("STOPPED\n");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                for (UT2004BotExecution bot : this.bots) {
                    try {
                        bot.stop();
                    }
                    catch (Exception e) {}
                }
                this.bots.clear();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                for (LogPublisher.FilePublisher file : this.filePublishers) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
                this.filePublishers.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lblBotPort.setText("Bot/Server/Observer port:");
            while (this.tblPlayers.getModel().getRowCount() > 0) {
                ((DefaultTableModel)this.tblPlayers.getModel()).removeRow(0);
            }
            this.cmbSelectMap.setEnabled(true);
            this.enablePathSet(true);
        }
        finally {
            this.wrapperKilling = false;
        }
    }

    private void toggleProfiling() {
        if (this.profiling) {
            this.endProfiling();
        } else {
            this.startProfiling();
        }
    }

    private void startProfiling() {
        this.logControlServer("START PROFILING\n");
        this.sendConsoleCommand("PROFILESCRIPT START");
        this.profiling = true;
    }

    private void endProfiling() {
        this.logControlServer("STOP PROFILING\n");
        this.sendConsoleCommand("PROFILESCRIPT STOP");
        this.profiling = false;
    }

    private void logControlServer(String string) {
        this.taControlServer.append(string);
        this.taControlServer.setCaretPosition(this.taControlServer.getText().length());
    }

    private void logUCC(String string) {
        this.taGB2004Console.append(string);
        this.taGB2004Console.setCaretPosition(this.taGB2004Console.getText().length());
    }

    private void sendConsoleCommand(String command) {
        this.server.getAct().act((CommandMessage)new Console().setCommand(command));
    }

    private void sendServerMessage(final String message) {
        this.server.getAct().act(new CommandMessage(){

            public String toString() {
                return message;
            }
        });
    }

    private void toggleReplay() {
        if (this.replay) {
            this.endReplay();
        } else {
            this.startReplay();
        }
    }

    private void startReplay() {
        if (this.server != null) {
            this.logControlServer("START REPLAY RECORDING\n");
            this.server.getAct().act((CommandMessage)new Record());
        }
        this.replay = true;
    }

    private void endReplay() {
        if (this.server != null) {
            this.logControlServer("STOP REPLAY RECORDING\n");
            this.server.getAct().act((CommandMessage)new StopRecord());
        }
        this.replay = false;
    }

    private void togglePlayers() {
        if (this.players) {
            this.endPlayers();
        } else {
            this.startPlayers();
        }
    }

    private void startPlayers() {
        if (this.server != null) {
            this.logControlServer("START EXPORTING PLAYERS LOCATIONS\n");
            this.server.getAct().act((CommandMessage)new StartPlayers().setGBBots(Boolean.valueOf(true)).setHumans(Boolean.valueOf(true)).setUnrealBots(Boolean.valueOf(true)));
        }
        this.players = true;
    }

    private void endPlayers() {
        if (this.server != null) {
            this.logControlServer("STOP EXPORTING PLAYERS LOCATIONS\n");
            this.server.getAct().act((CommandMessage)new StartPlayers().setGBBots(Boolean.valueOf(false)).setHumans(Boolean.valueOf(false)).setUnrealBots(Boolean.valueOf(false)));
        }
        this.players = false;
    }

    private void openUT2004GUI() {
        final ProcessExecutionConfig config = new ProcessExecutionConfig();
        config.setExecutionDir(this.getUT2004SystemDir());
        config.setPathToProgram(this.getUT2004ExeFile());
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("127.0.0.1");
        config.setArgs(args);
        config.setRedirectStdErr(false);
        config.setRedirectStdOut(false);
        this.btnStartUT2004GUI.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlServerGUI.this.process = new ProcessExecution(config, ControlServerGUI.this.processLogger);
                ControlServerGUI.this.process.start();
                ControlServerGUI.this.btnStartUT2004GUI.setEnabled(true);
                ControlServerGUI.this.changeText(ControlServerGUI.this.btnStartUT2004GUI, "UT2004 GUI running (click to close)");
            }
        }).start();
    }

    private String getUT2004SystemDir() {
        if (this.ut2004 == null) {
            return "N/A";
        }
        return new File(this.ut2004.dir, "System").getAbsolutePath();
    }

    private String getUT2004ExeFile() {
        if (this.ut2004 == null) {
            return "N/A";
        }
        return this.ut2004.ut2004Exe.getAbsolutePath();
    }

    private void closeUT2004GUI() {
        if (this.process == null) {
            return;
        }
        this.btnStartUT2004GUI.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlServerGUI.this.closeUT2004GUISync();
            }
        }).start();
    }

    private void closeUT2004GUISync() {
        if (this.process == null) {
            return;
        }
        this.btnStartUT2004GUI.setEnabled(false);
        try {
            this.process.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.changeText(this.btnStartUT2004GUI, "Start UT2004 GUI");
        this.process = null;
        if (!this.wrapperKilling) {
            this.btnStartUT2004GUI.setEnabled(true);
        }
    }

    private boolean checkUT2004Dir(File file, boolean warning) {
        return UT2004Installation.isUT2004Dir(file, warning);
    }

    private void displayError(String error) {
        JOptionPane.showMessageDialog(this, error, "Error", 0);
    }

    private void changeText(JButton button, String newText) {
        Dimension old = button.getSize();
        Dimension preffered = button.getPreferredSize();
        Point point = button.getLocation();
        button.setText(newText);
        button.setLocation(point);
        button.setSize(old);
        button.setPreferredSize(preffered);
    }
}

