/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.controlservergui;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Console;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Record;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopRecord;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.process.ProcessExecution;
import cz.cuni.amis.utils.process.ProcessExecutionConfig;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListDataListener;

public class ControlServerGUI
extends JFrame {
    public static final String PROPERTY_FILE_NAME = "UT2004ControlServerGUI.properties";
    public static final String UT2004_DIR_KEY = "ut2004.home.dir";
    public static final String UT2004_SELECTED_MAP_KEY = "ut2004.selected.map";
    private Properties properties = new Properties();
    private String mapSelected;
    private File ut2004Dir;
    private File[] maps;
    private UCCWrapperConf conf;
    private boolean wrapperKilling = false;
    private UCCWrapper wrapper;
    private final Logger uccLogger;
    private final Handler serverLoggerHandler;
    private final UT2004ServerModule module;
    private final UT2004ServerFactory factory;
    private UT2004Server server;
    private boolean profiling = false;
    private boolean replay = false;
    private boolean players = false;
    private ProcessExecution process;
    private Logger processLogger = Logger.getAnonymousLogger();
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JToggleButton jToggleButton1;
    private JToggleButton jToggleButton3;
    private JToggleButton jToggleButton4;

    public ControlServerGUI() {
        File file;
        File propertyFile = new File(PROPERTY_FILE_NAME);
        if (propertyFile.exists() && propertyFile.isFile()) {
            try {
                this.properties.load(new FileInputStream(propertyFile));
            }
            catch (Exception e) {
                this.properties = new Properties();
            }
        }
        this.module = new UT2004ServerModule();
        this.factory = new UT2004ServerFactory(this.module);
        this.uccLogger = Logger.getAnonymousLogger();
        this.uccLogger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                ControlServerGUI.this.logUCC(record.getMessage() + "\n");
            }

            @Override
            public void flush() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void close() throws SecurityException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.serverLoggerHandler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                ControlServerGUI.this.jTextArea1.append(record.getMessage() + "\n");
                ControlServerGUI.this.jTextArea1.setCaretPosition(ControlServerGUI.this.jTextArea1.getText().length());
            }

            @Override
            public void flush() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void close() throws SecurityException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        this.initComponents();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                File propertyFile = new File(ControlServerGUI.PROPERTY_FILE_NAME);
                try {
                    ControlServerGUI.this.properties.store(new FileOutputStream(propertyFile), "ControlServerGUI.java properties");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        String utHome = this.getProperty(UT2004_DIR_KEY, null);
        if (utHome != null && this.checkUT2004Dir(file = new File(utHome), false)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControlServerGUI.this.changeUT2004Dir(file);
                }
            });
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jToggleButton1 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.jToggleButton4 = new JToggleButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jComboBox1 = new JComboBox();
        this.jButton5 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jButton6 = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jToggleButton1.setText("Toggle replay recording");
        this.jToggleButton1.setEnabled(false);
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jToggleButton3.setText("Toggle profiling");
        this.jToggleButton3.setEnabled(false);
        this.jToggleButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jToggleButton3ActionPerformed(evt);
            }
        });
        this.jToggleButton4.setText("Toggle players exporting");
        this.jToggleButton4.setEnabled(false);
        this.jToggleButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jToggleButton4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jToggleButton3, -1, 212, Short.MAX_VALUE).addComponent(this.jToggleButton4, -1, 212, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jToggleButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButton4).addContainerGap(151, Short.MAX_VALUE)));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setEnabled(false);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jButton1.setText("Send GB2004 Command");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Send UT2004 Console Command");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jButton2ActionPerformed(evt);
            }
        });
        this.jTextField1.setEnabled(false);
        this.jTextField2.setEnabled(false);
        this.jTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jTextField2ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("not set ...");
        this.jButton3.setText("Set UT2004 Home");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setText("Start GB2004 DeathMatch");
        this.jButton4.setEnabled(false);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jButton4ActionPerformed(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Select Map..."}));
        this.jComboBox1.setEnabled(false);
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ControlServerGUI.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jButton5.setText("Start GB2004 CaptureTheFlag");
        this.jButton5.setEnabled(false);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jButton5ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("GB2004 Control Server: not running...");
        this.jLabel2.setEnabled(false);
        this.jLabel3.setText("Bot port:");
        this.jLabel3.setEnabled(false);
        this.jLabel4.setText("Server port:");
        this.jLabel4.setEnabled(false);
        this.jLabel5.setText("Observer port:");
        this.jLabel5.setEnabled(false);
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextArea2);
        this.jButton6.setText("Start UT2004 GUI");
        this.jButton6.setEnabled(false);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jButton6ActionPerformed(evt);
            }
        });
        this.jMenu1.setText("File");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlServerGUI.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jButton3, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5))).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jButton6, GroupLayout.Alignment.TRAILING, -2, 340, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -2, 187, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField2, -1, 625, Short.MAX_VALUE).addComponent(this.jTextField1))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1)).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4).addComponent(this.jButton5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6, -1, -1, Short.MAX_VALUE)).addComponent(this.jScrollPane3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField1, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton2).addComponent(this.jTextField2, -2, 21, -2)).addContainerGap()));
        this.pack();
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        if (this.wrapper == null) {
            this.jTextArea1.setText("");
            this.jTextArea2.setText("");
            this.startGB2004_DM();
        } else {
            this.jButton4.setText("Stopping...");
            this.jButton4.setEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ControlServerGUI.this.jButton4.setText("Start GB2004 DeathMatch");
                    ControlServerGUI.this.jButton4.setEnabled(true);
                    ControlServerGUI.this.jComboBox1.setEnabled(true);
                    ControlServerGUI.this.stopUcc();
                }
            }).start();
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        if (this.wrapper == null) {
            this.jTextArea1.setText("");
            this.jTextArea2.setText("");
            this.startGB2004_CTF();
        } else {
            this.jButton4.setText("Stopping...");
            this.jButton4.setEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ControlServerGUI.this.jButton4.setText("Start GB2004 DeathMatch");
                    ControlServerGUI.this.jButton4.setEnabled(true);
                    ControlServerGUI.this.jComboBox1.setEnabled(true);
                    ControlServerGUI.this.stopUcc();
                }
            }).start();
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setFileSelectionMode(1);
        int returnVal = jFileChooser1.showOpenDialog(this);
        if (returnVal == 0) {
            File file = jFileChooser1.getSelectedFile();
            if (!this.checkUT2004Dir(file, true)) {
                return;
            }
            this.changeUT2004Dir(file);
        }
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        this.mapChanged();
    }

    private void jToggleButton3ActionPerformed(ActionEvent evt) {
        this.toggleProfiling();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.sendServerMessage(this.jTextField1.getText());
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.sendConsoleCommand(this.jTextField2.getText());
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.toggleReplay();
    }

    private void jToggleButton4ActionPerformed(ActionEvent evt) {
        this.togglePlayers();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        if (this.process == null) {
            this.openUT2004GUI();
        } else {
            this.closeUT2004GUI();
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.setDefaultCloseOperation(3);
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ControlServerGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ControlServerGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ControlServerGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ControlServerGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ControlServerGUI().setVisible(true);
            }
        });
    }

    private boolean containsSystemDir(File file) {
        File system = new File(file, "System");
        return system.isDirectory() && system.exists();
    }

    private boolean containsUT2004Exe(File file) {
        File system = new File(file, "System");
        File ut2004Exe = new File(system, "UT2004.exe");
        return system.isDirectory() && system.exists() && ut2004Exe.isFile() && ut2004Exe.exists();
    }

    private boolean containsMaps(File file) {
        File maps = new File(file, "Maps");
        return maps.isDirectory() && maps.exists();
    }

    private boolean containsUCCExe(File file) {
        File system = new File(file, "System");
        File uccExe = new File(system, "UCC.exe");
        return system.isDirectory() && system.exists() && uccExe.isFile() && uccExe.exists();
    }

    private boolean containsGB2004(File file) {
        File system = new File(file, "System");
        File gb2004 = new File(system, "GameBots2004.u");
        return system.isDirectory() && system.exists() && gb2004.isFile() && gb2004.exists();
    }

    private void changeUT2004Dir(File file) {
        if (file == null) {
            return;
        }
        this.jLabel1.setText(file.getAbsolutePath());
        this.ut2004Dir = file;
        this.setProperty(UT2004_DIR_KEY, file.getAbsolutePath());
        if (file == null) {
            this.enableAll(false);
        } else {
            this.enableAll(false);
            this.enableUT2004Start();
        }
    }

    private void enableAll(boolean state) {
        this.jToggleButton1.setEnabled(state);
        this.jToggleButton3.setEnabled(state);
        this.jToggleButton4.setEnabled(state);
        this.jTextArea1.setEnabled(state);
        this.jButton1.setEnabled(state);
        this.jButton2.setEnabled(state);
        this.jTextField1.setEnabled(state);
        this.jTextField2.setEnabled(state);
        this.jButton4.setEnabled(state);
        this.jComboBox1.setEnabled(state);
        this.jButton5.setEnabled(state);
        this.jButton6.setEnabled(state);
        this.jTextArea2.setEnabled(state);
        this.jLabel2.setEnabled(state);
        this.jLabel3.setEnabled(state);
        this.jLabel4.setEnabled(state);
        this.jLabel5.setEnabled(state);
    }

    private void enableUT2004Start() {
        this.jComboBox1.setEnabled(true);
        this.maps = this.loadMaps();
        this.jComboBox1.setModel(new ComboBoxModel(){

            @Override
            public void setSelectedItem(Object anItem) {
                ControlServerGUI.this.mapSelected = (String)anItem;
            }

            @Override
            public Object getSelectedItem() {
                return ControlServerGUI.this.mapSelected;
            }

            @Override
            public int getSize() {
                return ControlServerGUI.this.maps.length;
            }

            @Override
            public Object getElementAt(int index) {
                return ControlServerGUI.this.maps[index].getName();
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.jComboBox1.setSelectedIndex(this.getMapSelectedIndex());
    }

    private File[] loadMaps() {
        File mapsDir = new File(this.ut2004Dir, "Maps");
        File[] files = mapsDir.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".ut2")) continue;
            result.add(file);
        }
        return result.toArray(new File[0]);
    }

    private int getMapSelectedIndex() {
        String mapName = this.getProperty(UT2004_SELECTED_MAP_KEY, "DM-1on1-Albatross.ut2");
        int index = -1;
        for (File map : this.maps) {
            ++index;
            if (!map.getName().contains(mapName)) continue;
            return index;
        }
        for (File map : this.maps) {
            ++index;
            if (!map.getName().contains("DM-1on1-Albatross")) continue;
            this.setProperty(UT2004_SELECTED_MAP_KEY, map.getName());
            return index;
        }
        return 0;
    }

    private void mapChanged() {
        File map = this.getSelectedMap();
        if (map == null) {
            this.jButton4.setEnabled(false);
            this.jButton5.setEnabled(false);
        } else {
            this.setProperty(UT2004_SELECTED_MAP_KEY, this.getSelectedMapName());
            if (map.getName().startsWith("DM")) {
                this.jButton4.setEnabled(true);
                this.jButton5.setEnabled(false);
            } else if (map.getName().startsWith("CTF")) {
                this.jButton4.setEnabled(false);
                this.jButton5.setEnabled(true);
            } else {
                this.jButton4.setEnabled(true);
                this.jButton5.setEnabled(true);
            }
        }
    }

    private File getSelectedMap() {
        if (this.jComboBox1.getSelectedIndex() < 0) {
            return null;
        }
        return this.maps[this.jComboBox1.getSelectedIndex()];
    }

    private void startGB2004_DM() {
        this.jComboBox1.setEnabled(false);
        this.jTextArea2.setEnabled(true);
        this.conf = new UCCWrapperConf();
        this.conf.setUnrealHome(this.ut2004Dir.getAbsolutePath());
        this.conf.setMapName(this.getSelectedMapName());
        this.conf.setGameType("GameBots2004.BotDeathMatch");
        this.conf.setLogger(this.uccLogger);
        this.conf.setStartOnUnusedPort(false);
        this.jButton4.setEnabled(false);
        this.jButton4.setText("Starting...");
        this.jButton5.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlServerGUI.this.startUcc();
            }
        }).start();
    }

    private void startGB2004_CTF() {
        this.jComboBox1.setEnabled(false);
        this.jTextArea2.setEnabled(true);
        this.conf = new UCCWrapperConf();
        this.conf.setUnrealHome(this.ut2004Dir.getAbsolutePath());
        this.conf.setMapName(this.getSelectedMapName());
        this.conf.setGameType("GameBots2004.BotDeathMatch");
        this.conf.setLogger(this.uccLogger);
        this.conf.setStartOnUnusedPort(false);
        this.jButton5.setEnabled(false);
        this.jButton5.setText("Starting...");
        this.jButton4.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlServerGUI.this.startUcc();
            }
        }).start();
    }

    private void startUcc() {
        this.wrapper = new UCCWrapper(this.conf);
        this.jLabel3.setText("Bot port: " + this.wrapper.getBotPort());
        this.jLabel4.setText("Server port: " + this.wrapper.getControlPort());
        this.jLabel5.setText("Observer port: " + this.wrapper.getObserverPort());
        this.jLabel3.setEnabled(true);
        this.jLabel4.setEnabled(true);
        this.jLabel5.setEnabled(true);
        this.jButton4.setEnabled(true);
        this.jButton4.setText("Running (click to stop)");
        this.jButton6.setEnabled(true);
        this.startControlServer();
    }

    private String getSelectedMapName() {
        File map = this.getSelectedMap();
        if (map == null) {
            return null;
        }
        return map.getName().substring(0, map.getName().lastIndexOf("."));
    }

    private void startControlServer() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                UT2004ServerRunner runner = new UT2004ServerRunner((IAgentFactory)ControlServerGUI.this.factory, "ControlServer", "localhost", ControlServerGUI.this.wrapper.getControlPort());
                try {
                    ControlServerGUI.this.server = (UT2004Server)runner.setLogLevel(Level.FINE).startAgent();
                }
                catch (Exception e) {
                    ControlServerGUI.this.displayError(e.getClass() + ": " + e.getMessage());
                    ControlServerGUI.this.server = null;
                    return;
                }
                ControlServerGUI.this.server.getLogger().setLevel(Level.FINE);
                ControlServerGUI.this.server.getLogger().addDefaultHandler(ControlServerGUI.this.serverLoggerHandler);
                ControlServerGUI.this.serverStarted();
                if (ControlServerGUI.this.profiling) {
                    ControlServerGUI.this.startProfiling();
                }
                if (ControlServerGUI.this.replay) {
                    ControlServerGUI.this.startReplay();
                }
                if (!ControlServerGUI.this.players) {
                    ControlServerGUI.this.endPlayers();
                }
            }
        }).start();
    }

    private void serverStarted() {
        this.jLabel2.setEnabled(true);
        this.jLabel2.setText("GB2004 Control Server: running");
        this.jToggleButton1.setEnabled(true);
        this.jToggleButton3.setEnabled(true);
        this.jToggleButton4.setEnabled(true);
        this.jTextArea1.setEnabled(true);
        this.jButton1.setEnabled(true);
        this.jButton2.setEnabled(true);
        this.jTextField1.setEditable(true);
        this.jTextField2.setEditable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopUcc() {
        this.wrapperKilling = true;
        try {
            this.jButton6.setEnabled(false);
            this.jLabel2.setEnabled(false);
            this.jToggleButton1.setEnabled(false);
            this.jToggleButton3.setEnabled(false);
            this.jToggleButton4.setEnabled(false);
            this.jTextArea1.setEditable(false);
            this.jButton1.setEnabled(false);
            this.jButton2.setEnabled(false);
            this.jTextField1.setEditable(false);
            this.jTextField2.setEditable(false);
            this.jLabel3.setEnabled(false);
            this.jLabel4.setEnabled(false);
            this.jLabel5.setEnabled(false);
            if (this.process != null) {
                this.closeUT2004GUISync();
            }
            if (this.server != null) {
                try {
                    this.server.stop();
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        this.server.getLogger().removeDefaultHandler(this.serverLoggerHandler);
                    }
                    catch (Exception e) {}
                }
                this.server = null;
                this.logControlServer("STOPPED\n");
            }
            this.jLabel2.setText("GB2004 Control Server: not running...");
            if (this.wrapper != null) {
                try {
                    this.wrapper.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.wrapper = null;
                this.logUCC("STOPPED\n");
            }
            this.jLabel3.setText("Bot port:");
            this.jLabel4.setText("Server port:");
            this.jLabel5.setText("Observer port:");
        }
        finally {
            this.wrapperKilling = false;
        }
    }

    private void toggleProfiling() {
        if (this.profiling) {
            this.endProfiling();
        } else {
            this.startProfiling();
        }
    }

    private void startProfiling() {
        this.logControlServer("START PROFILING\n");
        this.sendConsoleCommand("PROFILESCRIPT START");
        this.profiling = true;
    }

    private void endProfiling() {
        this.logControlServer("STOP PROFILING\n");
        this.sendConsoleCommand("PROFILESCRIPT STOP");
        this.profiling = false;
    }

    private void logControlServer(String string) {
        this.jTextArea1.append(string);
        this.jTextArea1.setCaretPosition(this.jTextArea1.getText().length());
    }

    private void logUCC(String string) {
        this.jTextArea2.append(string);
        this.jTextArea2.setCaretPosition(this.jTextArea2.getText().length());
    }

    private void sendConsoleCommand(String command) {
        this.server.getAct().act((CommandMessage)new Console().setCommand(command));
    }

    private void sendServerMessage(final String message) {
        this.server.getAct().act(new CommandMessage(){

            public String toString() {
                return message;
            }
        });
    }

    private void toggleReplay() {
        if (this.replay) {
            this.endReplay();
        } else {
            this.startReplay();
        }
    }

    private void startReplay() {
        if (this.server != null) {
            this.logControlServer("START REPLAY RECORDING\n");
            this.server.getAct().act((CommandMessage)new Record());
        }
        this.replay = true;
    }

    private void endReplay() {
        if (this.server != null) {
            this.logControlServer("STOP REPLAY RECORDING\n");
            this.server.getAct().act((CommandMessage)new StopRecord());
        }
        this.replay = false;
    }

    private void togglePlayers() {
        if (this.players) {
            this.endPlayers();
        } else {
            this.startPlayers();
        }
    }

    private void startPlayers() {
        if (this.server != null) {
            this.logControlServer("START EXPORTING PLAYERS LOCATIONS\n");
            this.server.getAct().act((CommandMessage)new StartPlayers().setGBBots(Boolean.valueOf(true)).setHumans(Boolean.valueOf(true)).setUnrealBots(Boolean.valueOf(true)));
        }
        this.players = true;
    }

    private void endPlayers() {
        if (this.server != null) {
            this.logControlServer("STOP EXPORTING PLAYERS LOCATIONS\n");
            this.server.getAct().act((CommandMessage)new StartPlayers().setGBBots(Boolean.valueOf(false)).setHumans(Boolean.valueOf(false)).setUnrealBots(Boolean.valueOf(false)));
        }
        this.players = false;
    }

    private void openUT2004GUI() {
        final ProcessExecutionConfig config = new ProcessExecutionConfig();
        config.setExecutionDir(this.getUT2004SystemDir());
        config.setPathToProgram(this.getUT2004ExeFile());
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("127.0.0.1");
        config.setArgs(args);
        config.setRedirectStdErr(false);
        config.setRedirectStdOut(false);
        this.jButton6.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlServerGUI.this.process = new ProcessExecution(config, ControlServerGUI.this.processLogger);
                ControlServerGUI.this.process.start();
                ControlServerGUI.this.jButton6.setEnabled(true);
                ControlServerGUI.this.changeText(ControlServerGUI.this.jButton6, "UT2004 GUI running (click to close)");
            }
        }).start();
    }

    private String getUT2004SystemDir() {
        return new File(this.ut2004Dir, "System").getAbsolutePath();
    }

    private String getUT2004ExeFile() {
        return new File(new File(this.ut2004Dir, "System"), "UT2004.exe").getAbsolutePath();
    }

    private void closeUT2004GUI() {
        if (this.process == null) {
            return;
        }
        this.jButton6.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlServerGUI.this.closeUT2004GUISync();
            }
        }).start();
    }

    private void closeUT2004GUISync() {
        if (this.process == null) {
            return;
        }
        this.jButton6.setEnabled(false);
        try {
            this.process.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.changeText(this.jButton6, "Start UT2004 GUI");
        this.process = null;
        if (!this.wrapperKilling) {
            this.jButton6.setEnabled(true);
        }
    }

    private String getProperty(String key, String defaultValue) {
        Object valueObj = this.properties.get(key);
        if (valueObj == null) {
            if (defaultValue == null) {
                return null;
            }
            this.properties.put(key, defaultValue);
            return defaultValue;
        }
        return valueObj.toString();
    }

    private void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    private boolean checkUT2004Dir(File file, boolean warning) {
        if (!file.isDirectory()) {
            if (warning) {
                JOptionPane.showMessageDialog(this, "Please select UT2004 directory, not a file.", "Error", 0);
            }
            return false;
        }
        if (!this.containsSystemDir(file)) {
            if (warning) {
                JOptionPane.showMessageDialog(this, "Does not seem to be UT2004 directory, 'System' subdir not present.", "Error", 0);
            }
            return false;
        }
        if (!this.containsUT2004Exe(file)) {
            if (warning) {
                JOptionPane.showMessageDialog(this, "Does not seem to be UT2004 directory, 'System\\UT2004.exe' file not present.", "Error", 0);
            }
            return false;
        }
        if (!this.containsMaps(file)) {
            if (warning) {
                JOptionPane.showMessageDialog(this, "Does not seem to be UT2004 directory, 'Maps' subdir not present.", "Error", 0);
            }
            return false;
        }
        if (!this.containsUCCExe(file)) {
            if (warning) {
                JOptionPane.showMessageDialog(this, "Does not seem to be UT2004 directory, 'System\\ucc.exe' file not present.", "Error", 0);
            }
            return false;
        }
        if (!this.containsGB2004(file)) {
            if (warning) {
                JOptionPane.showMessageDialog(this, "GameBots2004 not installed, 'System\\GameBots2004.u' file not present.", "Error", 0);
            }
            return false;
        }
        return true;
    }

    private void displayError(String error) {
        JOptionPane.showMessageDialog(this, error, "Error", 0);
    }

    private void changeText(JButton button, String newText) {
        Dimension old = button.getSize();
        Dimension preffered = button.getPreferredSize();
        Point point = button.getLocation();
        button.setText(newText);
        button.setLocation(point);
        button.setSize(old);
        button.setPreferredSize(preffered);
    }
}

