/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.ut2004.examples.controlservergui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Console;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Record;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopRecord;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.process.ProcessExecution;
import cz.cuni.amis.utils.process.ProcessExecutionConfig;

/**
 *
 * @author Jimmy
 */
public class ControlServerGUI extends javax.swing.JFrame {

    public static final String PROPERTY_FILE_NAME = "UT2004ControlServerGUI.properties";
    
    public static final String UT2004_DIR_KEY = "ut2004.home.dir";

	public static final String UT2004_SELECTED_MAP_KEY = "ut2004.selected.map";
    
    private Properties properties = new Properties();
    private String mapSelected;    
    private File ut2004Dir;
    private File[] maps;
    private UCCWrapperConf conf;
    private boolean wrapperKilling = false;
    private UCCWrapper wrapper;
    private final Logger uccLogger;
    private final Handler serverLoggerHandler;
    private final UT2004ServerModule module;
    private final UT2004ServerFactory factory;
    private UT2004Server server;
    private boolean profiling = false;
    private boolean replay = false;
    private boolean players = false;
    private ProcessExecution process;
    private Logger processLogger = Logger.getAnonymousLogger();


    /**
     * Creates new form ControlServerGUI
     */
    public ControlServerGUI() {
        
        final File propertyFile = new File(PROPERTY_FILE_NAME); 
        if (propertyFile.exists() && propertyFile.isFile()) {
            try {
                properties.load(new FileInputStream(propertyFile));
            } catch (Exception e) {
                properties = new Properties();
            }
        }
        
        module = new UT2004ServerModule();
        factory = new UT2004ServerFactory(module);
        
        uccLogger = Logger.getAnonymousLogger();
        uccLogger.addHandler(new Handler() {

            @Override
            public void publish(LogRecord record) {
                logUCC(record.getMessage() + "\n");
            }

            @Override
            public void flush() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void close() throws SecurityException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            
        });
        
        serverLoggerHandler = new Handler() {

            @Override
            public void publish(LogRecord record) {
                jTextArea1.append(record.getMessage() + "\n");
                jTextArea1.setCaretPosition(jTextArea1.getText().length());
            }

            @Override
            public void flush() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void close() throws SecurityException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            
        };
        
        initComponents();
        
        addWindowListener(new WindowListener() {

            @Override
            public void windowOpened(WindowEvent e) {}

            @Override
            public void windowClosing(WindowEvent e) {
                File propertyFile = new File(PROPERTY_FILE_NAME); 
                try {
                    properties.store(new FileOutputStream(propertyFile), "ControlServerGUI.java properties");
                } catch (Exception ex) {
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {}

            @Override
            public void windowIconified(WindowEvent e) {}

            @Override
            public void windowDeiconified(WindowEvent e) {}

            @Override
            public void windowActivated(WindowEvent e) {}

            @Override
            public void windowDeactivated(WindowEvent e) {}
        }
        );
        
        String utHome = getProperty(UT2004_DIR_KEY, null);
        if (utHome != null) {
            final File file = new File(utHome);
            if (checkUT2004Dir(file, false)) {
                SwingUtilities.invokeLater(new Runnable() {
                    @Override
                    public void run() {
                         changeUT2004Dir(file);
                    }
                });
            }
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jToggleButton1 = new javax.swing.JToggleButton();
        jToggleButton3 = new javax.swing.JToggleButton();
        jToggleButton4 = new javax.swing.JToggleButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jTextField1 = new javax.swing.JTextField();
        jTextField2 = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();
        jComboBox1 = new javax.swing.JComboBox();
        jButton5 = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextArea2 = new javax.swing.JTextArea();
        jButton6 = new javax.swing.JButton();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jToggleButton1.setText("Toggle replay recording");
        jToggleButton1.setEnabled(false);
        jToggleButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton1ActionPerformed(evt);
            }
        });

        jToggleButton3.setText("Toggle profiling");
        jToggleButton3.setEnabled(false);
        jToggleButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton3ActionPerformed(evt);
            }
        });

        jToggleButton4.setText("Toggle players exporting");
        jToggleButton4.setEnabled(false);
        jToggleButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton4ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jToggleButton1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jToggleButton3, javax.swing.GroupLayout.DEFAULT_SIZE, 212, Short.MAX_VALUE)
                    .addComponent(jToggleButton4, javax.swing.GroupLayout.DEFAULT_SIZE, 212, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jToggleButton1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToggleButton3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToggleButton4)
                .addContainerGap(151, Short.MAX_VALUE))
        );

        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setRows(5);
        jTextArea1.setEnabled(false);
        jScrollPane1.setViewportView(jTextArea1);

        jButton1.setText("Send GB2004 Command");
        jButton1.setEnabled(false);
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton2.setText("Send UT2004 Console Command");
        jButton2.setEnabled(false);
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jTextField1.setEnabled(false);

        jTextField2.setEnabled(false);
        jTextField2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField2ActionPerformed(evt);
            }
        });

        jLabel1.setText("not set ...");

        jButton3.setText("Set UT2004 Home");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jButton4.setText("Start GB2004 DeathMatch");
        jButton4.setEnabled(false);
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Select Map..." }));
        jComboBox1.setEnabled(false);
        jComboBox1.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox1ItemStateChanged(evt);
            }
        });
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        jButton5.setText("Start GB2004 CaptureTheFlag");
        jButton5.setEnabled(false);
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });

        jLabel2.setText("GB2004 Control Server: not running...");
        jLabel2.setEnabled(false);

        jLabel3.setText("Bot port:");
        jLabel3.setEnabled(false);

        jLabel4.setText("Server port:");
        jLabel4.setEnabled(false);

        jLabel5.setText("Observer port:");
        jLabel5.setEnabled(false);

        jTextArea2.setColumns(20);
        jTextArea2.setRows(5);
        jScrollPane3.setViewportView(jTextArea2);

        jButton6.setText("Start UT2004 GUI");
        jButton6.setEnabled(false);
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton6ActionPerformed(evt);
            }
        });

        jMenu1.setText("File");

        jMenuItem1.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F4, java.awt.event.InputEvent.ALT_MASK));
        jMenuItem1.setText("Exit");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });
        jMenu1.add(jMenuItem1);

        jMenuBar1.add(jMenu1);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                .addGroup(layout.createSequentialGroup()
                                    .addComponent(jButton3, javax.swing.GroupLayout.PREFERRED_SIZE, 157, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                .addComponent(jComboBox1, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGroup(layout.createSequentialGroup()
                                    .addComponent(jButton4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(jButton5)))
                            .addComponent(jLabel4)
                            .addComponent(jLabel3)
                            .addComponent(jLabel5)
                            .addComponent(jButton6, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 340, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane3))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jButton2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 187, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextField2, javax.swing.GroupLayout.DEFAULT_SIZE, 625, Short.MAX_VALUE)
                            .addComponent(jTextField1)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane1))
                    .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel1)
                            .addComponent(jButton3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jButton4)
                            .addComponent(jButton5))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(jScrollPane3))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel2)
                .addGap(11, 11, 11)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jScrollPane1)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jButton1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jButton2)
                    .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jTextField2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField2ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextField2ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        if (wrapper == null) {
           jTextArea1.setText("");
           jTextArea2.setText("");
           startGB2004_DM();
       } else {
           jButton4.setText("Stopping...");
           jButton4.setEnabled(false);
           new Thread(new Runnable() {
                @Override
                public void run() {
                   jButton4.setText("Start GB2004 DeathMatch");
                   jButton4.setEnabled(true);
                   jComboBox1.setEnabled(true);
                   
                   stopUcc();
                }               
           }).start();
           
       }
    }//GEN-LAST:event_jButton4ActionPerformed

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
       if (wrapper == null) {
           jTextArea1.setText("");
           jTextArea2.setText("");
           startGB2004_CTF();
       } else {
           jButton4.setText("Stopping...");
           jButton4.setEnabled(false);
           new Thread(new Runnable() {
                @Override
                public void run() {
                   jButton4.setText("Start GB2004 DeathMatch");
                   jButton4.setEnabled(true);
                   jComboBox1.setEnabled(true);
                   
                   stopUcc();
                }               
           }).start();
           
       }
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = jFileChooser1.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
             File file = jFileChooser1.getSelectedFile();
             if (!checkUT2004Dir(file, true)) return;             
             changeUT2004Dir(file);
        }
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jComboBox1ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox1ItemStateChanged
        mapChanged();
    }//GEN-LAST:event_jComboBox1ItemStateChanged

    private void jToggleButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton3ActionPerformed
        toggleProfiling();
    }//GEN-LAST:event_jToggleButton3ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        sendServerMessage(jTextField1.getText());
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        sendConsoleCommand(jTextField2.getText());
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jToggleButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton1ActionPerformed
        toggleReplay();
    }//GEN-LAST:event_jToggleButton1ActionPerformed

    private void jToggleButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton4ActionPerformed
        togglePlayers();
    }//GEN-LAST:event_jToggleButton4ActionPerformed

    private void jButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton6ActionPerformed
        if (process == null) {
            openUT2004GUI();
        } else {
            closeUT2004GUI();
        }
    }//GEN-LAST:event_jButton6ActionPerformed

    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.dispose();
    }//GEN-LAST:event_jMenuItem1ActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /*
         * Set the Nimbus look and feel
         */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /*
         * If Nimbus (introduced in Java SE 6) is not available, stay with the
         * default look and feel. For details see
         * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(ControlServerGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(ControlServerGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(ControlServerGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(ControlServerGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /*
         * Create and display the form
         */
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new ControlServerGUI().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextArea jTextArea2;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JToggleButton jToggleButton1;
    private javax.swing.JToggleButton jToggleButton3;
    private javax.swing.JToggleButton jToggleButton4;
    // End of variables declaration//GEN-END:variables

    private boolean containsSystemDir(File file) {
        File system = new File(file, "System");
        return system.isDirectory() && system.exists();
    }

    private boolean containsUT2004Exe(File file) {
        File system = new File(file, "System");
        File ut2004Exe = new File(system, "UT2004.exe");
        return system.isDirectory() && system.exists() && ut2004Exe.isFile() && ut2004Exe.exists();
    }
    
    private boolean containsMaps(File file) {
        File maps = new File(file, "Maps");
        return maps.isDirectory() && maps.exists();
    }

    private boolean containsUCCExe(File file) {
        File system = new File(file, "System");
        File uccExe = new File(system, "UCC.exe");
        return system.isDirectory() && system.exists() && uccExe.isFile() && uccExe.exists();
    }

    private boolean containsGB2004(File file) {
        File system = new File(file, "System");
        File gb2004 = new File(system, "GameBots2004.u");
        return system.isDirectory() && system.exists() && gb2004.isFile() && gb2004.exists();
    }

    private void changeUT2004Dir(File file) {
        if (file == null) return;
        jLabel1.setText(file.getAbsolutePath());
        ut2004Dir = file;
        setProperty(UT2004_DIR_KEY, file.getAbsolutePath());
        if (file == null) {
            enableAll(false);
        } else {
            enableAll(false);
            enableUT2004Start();
        }
    }

    private void enableAll(boolean state) {
        jToggleButton1.setEnabled(state);
        jToggleButton3.setEnabled(state);
        jToggleButton4.setEnabled(state);
        jTextArea1.setEnabled(state);
        jButton1.setEnabled(state);
        jButton2.setEnabled(state);
        jTextField1.setEnabled(state);
        jTextField2.setEnabled(state);
        jButton4.setEnabled(state);
        jComboBox1.setEnabled(state);
        jButton5.setEnabled(state);
        jButton6.setEnabled(state);
        jTextArea2.setEnabled(state);
        jLabel2.setEnabled(state);        
        jLabel3.setEnabled(state);
        jLabel4.setEnabled(state);
        jLabel5.setEnabled(state);
    }

    private void enableUT2004Start() {
        jComboBox1.setEnabled(true);        
        
        this.maps = loadMaps();
        
        jComboBox1.setModel(new ComboBoxModel() {

            @Override
            public void setSelectedItem(Object anItem) {
                ControlServerGUI.this.mapSelected = (String)anItem;
            }

            @Override
            public Object getSelectedItem() {
                return ControlServerGUI.this.mapSelected;
            }

            @Override
            public int getSize() {
                return ControlServerGUI.this.maps.length;
            }

            @Override
            public Object getElementAt(int index) {
                return ControlServerGUI.this.maps[index].getName();
            }

            @Override
            public void addListDataListener(ListDataListener l) {                
            }

            @Override
            public void removeListDataListener(ListDataListener l) {                
            }
        });
        
        jComboBox1.setSelectedIndex(getMapSelectedIndex());     
    }    

	private File[] loadMaps() {
        File mapsDir = new File(ut2004Dir, "Maps");
        File[] files = mapsDir.listFiles();
        List<File> result = new ArrayList<File>();
        for (File file : files) {
        	if (file.isFile() && file.getName().toLowerCase().endsWith(".ut2")) {
        		result.add(file);
        	}
        }
        return result.toArray(new File[0]);
    }

    private int getMapSelectedIndex() {
    	String mapName = getProperty(UT2004_SELECTED_MAP_KEY, "DM-1on1-Albatross.ut2");
        int index = -1;
        for (File map : maps) {
            ++index;
            if (map.getName().contains(mapName)) return index;
        }
        for (File map : maps) {
            ++index;
            if (map.getName().contains("DM-1on1-Albatross")) {
            	setProperty(UT2004_SELECTED_MAP_KEY, map.getName());
            	return index;
            }
        }
        return 0;
    }

    private void mapChanged() {
        File map = getSelectedMap();
        if (map == null) {
            jButton4.setEnabled(false);
            jButton5.setEnabled(false);
        } else {
        	setProperty(UT2004_SELECTED_MAP_KEY, getSelectedMapName());
	        if (map.getName().startsWith("DM")) {
	            jButton4.setEnabled(true);
	            jButton5.setEnabled(false);
	        } else 
	        if (map.getName().startsWith("CTF")) {
	            jButton4.setEnabled(false);
	            jButton5.setEnabled(true);
	        } else {
	            jButton4.setEnabled(true);
	            jButton5.setEnabled(true);
	        }
        }
    }

    private File getSelectedMap() {
        if (jComboBox1.getSelectedIndex() < 0) return null;
        return maps[jComboBox1.getSelectedIndex()];
    }

    private void startGB2004_DM() {
        jComboBox1.setEnabled(false);
        jTextArea2.setEnabled(true);
        
        conf = new UCCWrapperConf();
        conf.setUnrealHome(ut2004Dir.getAbsolutePath());
        conf.setMapName(getSelectedMapName());
        conf.setGameType("GameBots2004.BotDeathMatch");
        conf.setLogger(uccLogger);
        conf.setStartOnUnusedPort(false);
        
        jButton4.setEnabled(false);
        jButton4.setText("Starting...");
        jButton5.setEnabled(false);
        
        new Thread(new Runnable() {

            @Override
            public void run() {
                startUcc();                
            }

        }).start();
    }

    private void startGB2004_CTF() {
        jComboBox1.setEnabled(false);
        jTextArea2.setEnabled(true);
        
        conf = new UCCWrapperConf();
        conf.setUnrealHome(ut2004Dir.getAbsolutePath());
        conf.setMapName(getSelectedMapName());
        conf.setGameType("GameBots2004.BotDeathMatch");
        conf.setLogger(uccLogger);
        conf.setStartOnUnusedPort(false);
        
        jButton5.setEnabled(false);
        jButton5.setText("Starting...");
        jButton4.setEnabled(false);
        
        new Thread(new Runnable() {

            @Override
            public void run() {
                startUcc();
            }

        }).start();
    }

    private void startUcc() {
        wrapper = new UCCWrapper(conf);
        jLabel3.setText("Bot port: " + wrapper.getBotPort());
        jLabel4.setText("Server port: " + wrapper.getControlPort());
        jLabel5.setText("Observer port: " + wrapper.getObserverPort());

        jLabel3.setEnabled(true);
        jLabel4.setEnabled(true);
        jLabel5.setEnabled(true);

        jButton4.setEnabled(true);
        jButton4.setText("Running (click to stop)");
        
        jButton6.setEnabled(true);

        startControlServer();
    
    }

    private String getSelectedMapName() {
        File map = getSelectedMap();
        if (map == null) return null;
        return map.getName().substring(0, map.getName().lastIndexOf("."));
    }

    private void startControlServer() {
        new Thread(new Runnable() {            

            @Override
            public void run() {
                UT2004ServerRunner runner = new UT2004ServerRunner(factory, "ControlServer", "localhost", wrapper.getControlPort());                
                try {
                    server = (UT2004Server) runner.setLogLevel(Level.FINE).startAgent();
                } catch (Exception e) {
                    displayError(e.getClass() + ": " + e.getMessage());
                    server = null;
                    return;
                }
                server.getLogger().setLevel(Level.FINE);
                server.getLogger().addDefaultHandler(serverLoggerHandler);                
                serverStarted();
                if (profiling) {
                    startProfiling();
                }
                if (replay) {
                    startReplay();
                }
                if (!players) {
                    endPlayers();
                }
            }

        }).start();
    }
    
    private void serverStarted() {
        jLabel2.setEnabled(true);
        jLabel2.setText("GB2004 Control Server: running");
        
        jToggleButton1.setEnabled(true);
        jToggleButton3.setEnabled(true);
        jToggleButton4.setEnabled(true);
        jTextArea1.setEnabled(true);
        
        jButton1.setEnabled(true);
        jButton2.setEnabled(true);
        
        jTextField1.setEditable(true);
        jTextField2.setEditable(true);
    }
    
    private void stopUcc() {
    	
    	wrapperKilling = true;
    	
    	try {
	    	jButton6.setEnabled(false);
	    	jLabel2.setEnabled(false);        
	    
	        jToggleButton1.setEnabled(false);
	        jToggleButton3.setEnabled(false);
	        jToggleButton4.setEnabled(false);
	        jTextArea1.setEditable(false);
	    
	        jButton1.setEnabled(false);
	        jButton2.setEnabled(false);
	    
	        jTextField1.setEditable(false);
	        jTextField2.setEditable(false);
	        
	        jLabel3.setEnabled(false);
	        jLabel4.setEnabled(false);
	        jLabel5.setEnabled(false);
	        
	    	if (process != null) {
	    		closeUT2004GUISync();
	    	}
	    	
	        if (server != null) {
	            try {
	                server.stop();                
	            } catch (Exception e) {                
	            } finally {
	                try {
	                    server.getLogger().removeDefaultHandler(serverLoggerHandler);
	                } catch (Exception e) {                    
	                }
	            }
	            server = null;
	            
	            logControlServer("STOPPED\n");
	        }
	        
	        jLabel2.setText("GB2004 Control Server: not running...");
	        
	        if (wrapper != null) {
	            try {
	                wrapper.stop();
	            } catch (Exception e) {                
	            }
	            wrapper = null;
	            
	            logUCC("STOPPED\n");
	        }
	        
	        jLabel3.setText("Bot port:");
	        jLabel4.setText("Server port:");
	        jLabel5.setText("Observer port:");
    	} finally {
    		wrapperKilling = false;
    	}
    }
    
    private void toggleProfiling() {
        if (profiling) {
            endProfiling();
        } else {
            startProfiling();
        }
    }
    
    private void startProfiling() {
         logControlServer("START PROFILING\n");
         sendConsoleCommand("PROFILESCRIPT START");
         profiling = true;
    }

    private void endProfiling() {
        logControlServer("STOP PROFILING\n");
        sendConsoleCommand("PROFILESCRIPT STOP");
        profiling = false;
    }

    private void logControlServer(String string) {
        jTextArea1.append(string);
        jTextArea1.setCaretPosition(jTextArea1.getText().length());
    }
 
    private void logUCC(String string) {
        jTextArea2.append(string);
        jTextArea2.setCaretPosition(jTextArea2.getText().length());
    }

    private void sendConsoleCommand(String command) {
        server.getAct().act(new Console().setCommand(command));
    }
    
     private void sendServerMessage(final String message) {
        server.getAct().act(new CommandMessage() {
            @Override
            public String toString() {
                return message;
            }             
        });
    }
     
    private void toggleReplay() {
        if (replay) {
            endReplay();
        } else {
            startReplay();
        }
    }
    
    private void startReplay() {
        if (server != null) {
            logControlServer("START REPLAY RECORDING\n");         
            server.getAct().act(new Record());
        }
        replay = true;
    }

    private void endReplay() {
        if (server != null) {
            logControlServer("STOP REPLAY RECORDING\n");
            server.getAct().act(new StopRecord());
        }
        replay = false;
    }
    
    private void togglePlayers() {
        if (players) {
            endPlayers();
        } else {
            startPlayers();
        }
    }
    
    private void startPlayers() {
        if (server != null) {
            logControlServer("START EXPORTING PLAYERS LOCATIONS\n");         
            server.getAct().act(new StartPlayers().setGBBots(true).setHumans(true).setUnrealBots(true));
        }
        players = true;
    }

    private void endPlayers() {
        if (server != null) {
            logControlServer("STOP EXPORTING PLAYERS LOCATIONS\n");
            server.getAct().act(new StartPlayers().setGBBots(false).setHumans(false).setUnrealBots(false));            
        }
        players = false;
    }

    private void openUT2004GUI() {
        final ProcessExecutionConfig config = new ProcessExecutionConfig();
        config.setExecutionDir(getUT2004SystemDir());
        config.setPathToProgram(getUT2004ExeFile());
        List<String> args = new ArrayList<String>(1);
        args.add("127.0.0.1");
        config.setArgs(args);
        
        config.setRedirectStdErr(false);
        config.setRedirectStdOut(false);
        
        jButton6.setEnabled(false);
        
        new Thread(new Runnable() {
            
            @Override
            public void run() {
                process = new ProcessExecution(config, processLogger);
                process.start();
                jButton6.setEnabled(true);
                changeText(jButton6, "UT2004 GUI running (click to close)");                
            }
            
        }).start();
    }

    private String getUT2004SystemDir() {
        return new File(ut2004Dir, "System").getAbsolutePath();
    }

    private String getUT2004ExeFile() {
        return new File(new File(ut2004Dir, "System"), "UT2004.exe").getAbsolutePath();
    }

    private void closeUT2004GUI() {
        if (process == null) return;
        jButton6.setEnabled(false);
        new Thread(new Runnable() {

            @Override
            public void run() {
                closeUT2004GUISync();                
            }
            
        }).start();
    }
    
    private void closeUT2004GUISync() {
    	if (process == null) return;
    	jButton6.setEnabled(false);
		try {
        	process.stop();
        } catch (Exception e) {                	
        }
        changeText(jButton6, "Start UT2004 GUI");
        process = null;
        if (!wrapperKilling) {
        	jButton6.setEnabled(true);
        }
	}
    
    private String getProperty(String key, String defaultValue) {
        Object valueObj = properties.get(key);
        if (valueObj == null) {
            if (defaultValue == null) return null;
            properties.put(key, defaultValue);
            return defaultValue;
        }
        return valueObj.toString();
    }
    
    private void setProperty(String key, String value) {
        properties.put(key, value);
    }

    private boolean checkUT2004Dir(File file, boolean warning) {
        if (!file.isDirectory()) {
            if (warning) JOptionPane.showMessageDialog(this, "Please select UT2004 directory, not a file.", "Error", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        if (!containsSystemDir(file)) {
            if (warning) JOptionPane.showMessageDialog(this, "Does not seem to be UT2004 directory, 'System' subdir not present.", "Error", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        if (!containsUT2004Exe(file)) {
            if (warning) JOptionPane.showMessageDialog(this, "Does not seem to be UT2004 directory, 'System\\UT2004.exe' file not present.", "Error", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        if (!containsMaps(file)) {
            if (warning) JOptionPane.showMessageDialog(this, "Does not seem to be UT2004 directory, 'Maps' subdir not present.", "Error", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        if (!containsUCCExe(file)) {
            if (warning) JOptionPane.showMessageDialog(this, "Does not seem to be UT2004 directory, 'System\\ucc.exe' file not present.", "Error", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        if (!containsGB2004(file)) {
            if (warning) JOptionPane.showMessageDialog(this, "GameBots2004 not installed, 'System\\GameBots2004.u' file not present.", "Error", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        return true;
    }
    
    private void displayError(String error) {
        JOptionPane.showMessageDialog(this, error, "Error", JOptionPane.ERROR_MESSAGE);
    }

    private void changeText(JButton button, String newText) {
        Dimension old = button.getSize();
        Dimension preffered = button.getPreferredSize();
        Point point = button.getLocation();
        button.setText(newText);
        button.setLocation(point);
        button.setSize(old);
        button.setPreferredSize(preffered);
    }
    
}


