
package cz.cuni.amis.pogamut.ut2004.examples.emotionalbot;


import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Category;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.*;

/**
 * In this class we will generate all the events our agent can encounter in the scenario.
 * We will send here notifications to emotion model to generate emotional events.
 *
 * @author Michal Bida
 */
public class EEventGenerator {

    /** Pointer to our agent */
    private EmotionalBot myAgent;
    /** Pointer to our emotion engine - ALMA */
    private ALMA myALMA;

    /** if we do not see instigator we will generated id ourselves*/
    int botDamagedId = 0;

    /**
     * Listener to bot damaged message.
     */
    public IWorldEventListener<BotDamaged> myBotDamagedListener = new IWorldEventListener<BotDamaged>() {
        public void notify(BotDamaged event) {
            // if we don't see attacking player the instigator will be null and we send our own generated id
            if (event.getInstigator() != null)
                myALMA.processAffectInput(myALMA.createAffectInputBasicEEC(myAgent.myName, -1, -1, 0, 0, 0, 0, event.getInstigator().getStringId(), "other"), "BotDamaged");
            else
                myALMA.processAffectInput(myALMA.createAffectInputBasicEEC(myAgent.myName, -1, -1, 0, 0, 0, 0, String.valueOf(botDamagedId++), "other"), "BotDamaged");
        }
    };

    /**
     * Listener to text messages.
     */
    public IWorldEventListener<GlobalChat> myTextMessageListener = new IWorldEventListener<GlobalChat>() {

        public void notify(GlobalChat event) {
            if (event.getText().toLowerCase().contains("positive"))
                myALMA.processAffectInput(myALMA.createAffectInputBasicEEC(myAgent.myName, 0.5, 0.5, 0, 0, 0, 0, event.getId().getStringId() + "positive", "other"), "PositiveMessageReceived");
            if (event.getText().toLowerCase().contains("negative"))
                myALMA.processAffectInput(myALMA.createAffectInputBasicEEC(myAgent.myName, -1, -1, 0, 0, 0, 0, event.getId().getStringId() + "negative", "other"), "NegativeMessageReceived");
            if (event.getText().toLowerCase().contains("happy"))
                myALMA.processAffectInput(myALMA.createAffectInputBasicEEC(myAgent.myName, 0.5, 0, 0, 0, 0, 0, event.getId().getStringId() + "happy", "other"), "HappyMessageReceived");
        }
        
    };

    /**
     * Constructor of this class.
     *
     * @param myAgent agent we generate events for
     * @param myALMA link to emotional model
     */
    public EEventGenerator(EmotionalBot myAgent, ALMA myALMA) {
        this.myAgent = myAgent;
        this.myALMA = myALMA;

        //register listeners
        myAgent.getWorldView().addEventListener(GlobalChat.class, myTextMessageListener);
        myAgent.getWorldView().addEventListener(BotDamaged.class, myBotDamagedListener);

    }
}
