/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.sposhpraybot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.sposh.SPOSHAction;
import cz.cuni.amis.pogamut.sposh.SPOSHSense;
import cz.cuni.amis.pogamut.sposh.context.UT2004Behaviour;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.Collection;
import java.util.logging.Level;

public class PreyBehaviour
extends UT2004Behaviour<UT2004Bot> {
    TabooSet<Item> unreachable = null;
    Item runningToHealth;
    UT2004PathAutoFixer autoFixer;

    public PreyBehaviour(String name, UT2004Bot bot) {
        super(name, bot);
        this.initializeBehaviour(bot);
    }

    protected void prepareBehaviour(UT2004Bot bot) {
        this.unreachable = new TabooSet(bot);
    }

    public void botInitialized(GameInfo info, ConfigChange config, InitedMessage init) {
        ((UT2004Bot)this.bot).getLogger().getCategory("SPOSH").setLevel(Level.ALL);
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004TimeStuckDetector((UT2004Bot)this.bot, 3000.0, 10000.0));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004PositionStuckDetector((UT2004Bot)this.bot));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004DistanceStuckDetector((UT2004Bot)this.bot));
        this.autoFixer = new UT2004PathAutoFixer((UT2004Bot)this.bot, (IUT2004PathExecutor)this.pathExecutor, this.fwMap, this.aStar, this.navBuilder);
        this.pathExecutor.getState().addListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                switch (changedValue.getState()) {
                    case PATH_COMPUTATION_FAILED: 
                    case STUCK: {
                        if (PreyBehaviour.this.runningToHealth != null) {
                            PreyBehaviour.this.unreachable.add((Object)PreyBehaviour.this.runningToHealth, 60.0);
                            PreyBehaviour.this.runningToHealth = null;
                        }
                        return;
                    }
                }
            }
        });
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
    }

    public void botKilled(BotKilled event) {
    }

    @EventListener(eventClass=ItemPickedUp.class)
    public void itemPickedUpListener(ItemPickedUp event) {
        this.log.warning("PICKED UP: " + event.toString());
    }

    @ObjectClassEventListener(objectClass=Item.class, eventClass=WorldObjectUpdatedEvent.class)
    public void itemUpdated(WorldObjectUpdatedEvent<Item> itemEvent) {
        this.log.warning("UPDATED: " + itemEvent.getObject());
    }

    @SPOSHSense
    public boolean hitWall() {
        this.log.info("hitWall() = " + this.senses.isColliding());
        return this.senses.isColliding();
    }

    @SPOSHSense
    public int health() {
        this.log.info("health() = " + this.info.getHealth());
        return this.info.getHealth();
    }

    @SPOSHSense
    public boolean fail() {
        this.log.info("fail() = false");
        return false;
    }

    @SPOSHSense
    public boolean succeed() {
        this.log.info("succeed() = true");
        return true;
    }

    @SPOSHAction
    public ActionResult doNothing() {
        this.log.info("doNothing()");
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ActionResult.FINISHED;
    }

    @SPOSHAction
    public ActionResult runMedkits() {
        this.log.info("runMedkits()");
        Item item = this.runningToHealth = this.fwMap.getNearestItem((Collection)this.unreachable.filter(this.items.getSpawnedItems(ItemType.Category.HEALTH).values()), this.info.getNearestNavPoint());
        if (item == null) {
            this.log.severe("No known spawned pickup!");
            this.navigation.stopNavigation();
            return ActionResult.FAILED;
        }
        this.log.warning("GOING FOR ITEM: " + item);
        this.log.warning("ITEM VISIBLE:   " + item.isVisible());
        this.navigation.navigate((ILocated)item);
        return ActionResult.RUNNING;
    }

    @SPOSHAction
    public ActionResult jump() {
        this.log.info("jump()");
        this.move.jump();
        return ActionResult.RUNNING_ONCE;
    }

    public void logicBeforePlan() {
        this.log.info("--- LOGIC ITERATION ---");
    }

    public void logicAfterPlan() {
        this.log.info("/// LOGIC END ///");
    }
}

