/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.deathmatch1vnative;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import java.io.File;

public class DeathMatch1vNative {
    public String getUT2004Home() {
        return "D:\\Games\\UT2004-Devel";
    }

    public String getMapName() {
        return "DM-1on1-Albatross";
    }

    public int getFragLimit() {
        return 20;
    }

    public int getTimeLimitInMinutes() {
        return 20;
    }

    public String getPogamutBotName() {
        return "PogamutBot";
    }

    public String getPogamutBotJarPath() {
        return "D:\\Programming\\Workspaces\\Pogamut-Trunk\\Addons\\UT2004Tournament\\bots\\HunterBot\\HunterBot.jar";
    }

    public String getNativeBotName() {
        return "NativeBot";
    }

    public int getNativeBotSkillLevel() {
        return 5;
    }

    public String getOutputDir() {
        return "C:\\UT2004-Match-Results";
    }

    public UT2004DeathMatch createMatch() {
        LogCategory log = new LogCategory("DeathMatch1v1");
        log.addConsoleHandler();
        UT2004DeathMatchConfig config = new UT2004DeathMatchConfig();
        config.getUccConf().setUnrealHome(this.getUT2004Home());
        config.getUccConf().setMapName(this.getMapName());
        config.setFragLimit(this.getFragLimit());
        config.setTimeLimit(this.getTimeLimitInMinutes());
        UT2004BotConfig botConfig = new UT2004BotConfig();
        botConfig.setBotId(this.getPogamutBotName());
        botConfig.setPathToBotJar(this.getPogamutBotJarPath());
        botConfig.setTeamNumber(255);
        botConfig.setRedirectStdErr(true);
        botConfig.setRedirectStdOut(true);
        config.addBot(new UT2004BotConfig[]{botConfig});
        UT2004NativeBotConfig nativeBotConfig = new UT2004NativeBotConfig();
        nativeBotConfig.setBotId(this.getNativeBotName());
        nativeBotConfig.setSkillLevel(this.getNativeBotSkillLevel());
        nativeBotConfig.setTeamNumber(255);
        config.addNativeBot(new UT2004NativeBotConfig[]{nativeBotConfig});
        config.setOutputDirectory(new File(this.getOutputDir()));
        UT2004DeathMatch match = new UT2004DeathMatch(config, log);
        return match;
    }

    public void run() {
        UT2004DeathMatch match = this.createMatch();
        match.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            DeathMatch1vNative match = new DeathMatch1vNative();
            match.run();
        }
        finally {
            Pogamut.getPlatform().close();
        }
    }
}

