package cz.cuni.amis.pogamut.ut2004.examples.sposhpraybot;

import java.util.logging.Level;

import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.sposh.SPOSHAction;
import cz.cuni.amis.pogamut.sposh.SPOSHSense;
import cz.cuni.amis.pogamut.sposh.ut2004.SposhLogicController;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.bot.sposh.UT2004Behaviour;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.collections.MyCollections;

/**
 * Behaviour definition for prey bot.
 * 
 * @author Honza
 */
public class PreyBehaviour extends UT2004Behaviour<UT2004Bot> {	
	
    public PreyBehaviour(String name, UT2004Bot bot) {
        super(name, bot);
        // IMPORTANT: modules won't work without call of this method.
        initializeBehaviour(bot);
    }

    /**
     * Called from {@link PreyLogic#prepareBot(UT2004Bot)}.
     */
    @Override
    protected void prepareBehaviour(UT2004Bot bot) {
    	// initialize your custom data structures here
    	// things like agent modules / TabooSet(s), etc. / weaponPrefs
    }
    
    /**
     * Called from {@link PreyLogic#botInitialized(GameInfo, ConfigChange, InitedMessage)}.
     */
    @Override
    public void botInitialized(GameInfo info, ConfigChange config, InitedMessage init) {
    	// This is a good place to setup SPOSH engine log level
    	bot.getLogger().getCategory(SposhLogicController.SPOSH_LOG_CATEGORY).setLevel(Level.ALL);
    	
    	// This is a correct place to use navBuilder (for instance)
    }

    /**
     * Called from {@link PreyLogic#botSpawned(GameInfo, ConfigChange, InitedMessage, Self)}.
     */
    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
    	// "BotFirstSpawned" will be called only once.
    	
        // examine 'self' to examine current bot's location and other stuff, initialize things 
    	// that depends on that
    }
    
    /**
     * Called every time this bot dies from {@link PreyLogic#botKilled(BotKilled)}.
     */
    @Override
	public void botKilled(BotKilled event) {
    	// bot was killed, clean up your data structures
	}
    
    //
    // ============
    // SPOSH SENSES
    // ============
    //
    
    /**
     * hitWall sense, used when bot bumps into wall due to
     * errors in pathfinding (like railing)
     */
    @SPOSHSense
    public boolean hitWall() {
    	// it is adviced to always log your senses in order for you to get a grasp on how SPOSH is evaluating the plan
    	log.info("hitWall() = " + senses.isColliding());
        return senses.isColliding();
    }

    /**
     * Get health of bot
     * @return how many points of health does bot have
     */
    @SPOSHSense
    public int health() {
        // it is adviced to always log your senses in order for you to get a grasp on how SPOSH is evaluating the plan
        log.info("health() = " + info.getHealth());
        return info.getHealth();
    }
    
    /**
     * Standard sense that has to be implemented everywhere.
     * @return false
     */
    @SPOSHSense
    public boolean fail() {
    	// it is adviced to always log your senses in order for you to get a grasp on how SPOSH is evaluating the plan
    	log.info("fail() = false");
        return false;
    }

    /**
     * Standard sense that has to be implemented everywhere.
     * @return true
     */
    @SPOSHSense
    public boolean succeed() {
    	// it is adviced to always log your senses in order for you to get a grasp on how SPOSH is evaluating the plan
    	log.info("succeed() = true");
        return true;
    }
    
    //
    // =============
    // SPOSH ACTIONS
    // =============
    //

    /**
     * Standard action that has to be implemented everywhere. Sleep for 250ms.
     * @return true
     */
    @SPOSHAction
    public boolean doNothing() {
    	// it is adviced to always log your actions as well in order for you to get a grasp on how SPOSH is evaluating the plan
    	log.info("doNothing()");
        try {
            Thread.sleep(50);
        } catch (InterruptedException e) {
        }
        return true;
    }
    
    /**
     * Run from one health vial to another using list of health vials. 
     * No intelligence involved, doesn't matter if they are spawned or far away.
     * @return
     */
    @SPOSHAction
    public boolean runMedkits() {
    	// it is adviced to always log your actions as well in order for you to get a grasp on how SPOSH is evaluating the plan
    	log.info("runMedkits()");
    	
        if (pathExecutor.isExecuting()) {
            return true;
        }
        
        if (!pathExecutor.isExecuting()) {
        	Item item = DistanceUtils.getNearest(items.getSpawnedItems(ItemType.Category.HEALTH).values(), info.getLocation());
        	if (item == null) {
        		log.warning("No spawned pickup known! Trying random one!");
        		item = MyCollections.getRandom(items.getKnownPickups(ItemType.Category.HEALTH).values());
        		if (item == null) {
        			log.severe("No known health pickup pooint!");
        			return false;
        		}
        	}
            pathExecutor.followPath(pathPlanner.computePath(bot, item.getLocation()));
        }
        
        return true;
    }

    

    @SPOSHAction
    public boolean jump() {
    	// it is adviced to always log your actions as well in order for you to get a grasp on how SPOSH is evaluating the plan
    	log.info("jump()");
        move.jump();
        return true;
    }
    
    //
    // =====================
    // ADDITIONAL JAVA LOGIC
    // =====================
    //

    /**
     * This method can be used to execute anything that needs to be done BEFORE the plan evaluation takes place. E.g. {@link UT2004BotModuleController#logic()} 
     * method.
     */
    @Override
    public void logicBeforePlan() {   
    	log.info("--- LOGIC ITERATION ---");
    }
    
    /**
     * This method can be used to execute anything that needs to be done AFTER the plan evaluation takes place. E.g. {@link UT2004BotModuleController#logic()} 
     * method.
     */
    @Override
    public void logicAfterPlan() {
    	log.info("/// LOGIC END ///");
    }
}
