/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.sposhpraybot;

import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.sposh.SPOSHAction;
import cz.cuni.amis.pogamut.sposh.SPOSHSense;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.sposh.UT2004Behaviour;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.collections.MyCollections;
import java.util.logging.Level;

public class PreyBehaviour
extends UT2004Behaviour<UT2004Bot> {
    public PreyBehaviour(String name, UT2004Bot bot) {
        super(name, bot);
        this.initializeBehaviour(bot);
        this.prepareBehaviour(bot);
    }

    protected void prepareBehaviour(UT2004Bot bot) {
    }

    public void botInitialized(GameInfo info, ConfigChange config, InitedMessage init) {
        ((UT2004Bot)this.bot).getLogger().getCategory("SPOSH").setLevel(Level.ALL);
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
    }

    public void botKilled(BotKilled event) {
    }

    @SPOSHSense
    public boolean hitWall() {
        this.user.info("hitWall() = " + this.senses.isColliding());
        return this.senses.isColliding();
    }

    @SPOSHSense
    public int health() {
        this.user.info("health() = " + this.info.getHealth());
        return this.info.getHealth();
    }

    @SPOSHSense
    public boolean fail() {
        this.user.info("fail() = false");
        return false;
    }

    @SPOSHSense
    public boolean succeed() {
        this.user.info("succeed() = true");
        return true;
    }

    @SPOSHAction
    public boolean doNothing() {
        this.user.info("doNothing()");
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    @SPOSHAction
    public boolean runMedkits() {
        this.user.info("runMedkits()");
        if (this.pathExecutor.isExecuting()) {
            return true;
        }
        if (!this.pathExecutor.isExecuting()) {
            Item item = (Item)DistanceUtils.getNearest(this.items.getSpawnedItems(ItemType.Category.HEALTH).values(), (ILocated)this.info.getLocation());
            if (item == null) {
                this.user.warning("No spawned pickup known! Trying random one!");
                item = (Item)MyCollections.getRandom(this.items.getKnownPickups(ItemType.Category.HEALTH).values());
                if (item == null) {
                    this.user.severe("No known health pickup pooint!");
                    return false;
                }
            }
            this.pathExecutor.followPath(this.pathPlanner.computePath(this.bot, (Object)item.getLocation()));
        }
        return true;
    }

    @SPOSHAction
    public boolean jump() {
        this.user.info("jump()");
        this.move.jump();
        return true;
    }

    public void logicBeforePlan() {
        this.user.info("--- LOGIC ITERATION ---");
    }

    public void logicAfterPlan() {
        this.user.info("/// LOGIC END ///");
    }
}

