/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.examples.airrobot;

import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.configuration.ConfigAerial;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ConfigType;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.GeometryType;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.agent.module.geometry.GeoSensorEffecter;
import cz.cuni.amis.pogamut.usar2004.agent.module.logic.USAR2004BotLogicController;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.ConfigMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.GeometryMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.ResponseModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.SensorMasterModuleQueued;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.StateMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.response.ResponseSensorEffecter;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorGroundTruth;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorINS;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorLaser;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorRange;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.SensorMount;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.StartPose;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveAerial;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Initialize;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.SetSensorEffecter;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.Record;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.RiskLevel;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.ScanPreview;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.ToolBox;
import cz.cuni.amis.pogamut.usar2004.utils.USAR2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

@AgentScoped
public class AirRobot
extends USAR2004BotLogicController<USAR2004Bot> {
    private final Location destCenter = new Location(11.0, -50.0);
    private final double destWidth = 174.0;
    private final double destHeight = 174.0;
    private final boolean shouldWriteDatFile = false;
    private final double seaLevel = 3.0;
    private final Map<String, Point2D> highRiskAction = new HashMap<String, Point2D>(){
        {
            this.put("L4", new math.geom2d.Point2D(-0.95, 0.31));
            this.put("R4", new math.geom2d.Point2D(-0.95, -0.31));
            this.put("L3", new math.geom2d.Point2D(-0.81, 0.59));
            this.put("R3", new math.geom2d.Point2D(-0.81, -0.59));
            this.put("L2", new math.geom2d.Point2D(-0.59, 0.81));
            this.put("R2", new math.geom2d.Point2D(-0.59, -0.81));
            this.put("L1", new math.geom2d.Point2D(-0.31, 0.95));
            this.put("R1", new math.geom2d.Point2D(-0.31, -0.95));
            this.put("M0", new math.geom2d.Point2D(-1.0, 0.0));
        }
    };
    private final Map<String, Double> highRisk = new HashMap<String, Double>(){
        {
            this.put("L4", 0.47);
            this.put("R4", 0.47);
            this.put("L3", 0.61);
            this.put("R3", 0.61);
            this.put("L2", 0.86);
            this.put("R2", 0.86);
            this.put("L1", 1.22);
            this.put("R1", 1.22);
            this.put("M0", 1.5);
        }
    };
    private final Map<String, Double> lowRisk = new HashMap<String, Double>(){
        {
            this.put("L4", 1.57);
            this.put("R4", 1.57);
            this.put("L3", 1.91);
            this.put("R3", 1.91);
            this.put("L2", 2.72);
            this.put("R2", 2.72);
            this.put("L1", 3.5);
            this.put("R1", 3.5);
            this.put("M0", 4.2);
        }
    };
    private final String[] sonarOrder = new String[]{"L4", "L3", "L2", "L1", "M0", "R1", "R2", "R3", "R4"};
    private final Location zeroPoint = new Location(0.0, 0.0, 0.0);
    private final int numOfRays = 10;
    private final double minDensity = 15.0;
    private final double scanAltitude = 6.0;
    private final int dockWaitPenalty = 8;
    private final double scanningSpeed = 0.2;
    private final double flyingSpeed = 0.35;
    private final int jammedLimit = 35;
    private boolean singleFlight = true;
    private Location destination = this.destCenter;
    private double dWidth = 174.0;
    private double dHeight = 174.0;
    private Location longStep;
    private Location shortStep;
    private double altitude = 6.0;
    private double actAlt = 0.0;
    private Location actLoc;
    private Rotation actRot;
    private Location nextLoc;
    private State state = State.DEFAULT;
    private double speed = 0.0;
    private double rotSpeed = 0.0;
    private double minDev = 0.9;
    private boolean parametersObtained = false;
    private boolean scanning = false;
    private double maxLateralVelocity = 0.0;
    private double maxLinearVelocity = 0.0;
    private double maxRotationalVelocity = 0.0;
    private double maxAltitudeVelocity = 0.0;
    private boolean risen = false;
    private int offset = 0;
    private int cycle = 0;
    private int cycleStop = 0;
    private Location startLoc;
    private String infoToShow = "";
    private String infoToWrite = "";
    private SensorLaser laser;
    private SensorGroundTruth truth;
    private SensorINS ins;
    private SensorRange sonar;
    private double timeStamp = -1.0;
    private double time = 0.0;
    private long startTime = 0L;
    private double trip = 0.0;
    private Location prevLoc = null;
    private int battFull = 0;
    private final int battLife = 500;
    private int battFills = 0;
    private State stallState = State.DEFAULT;
    private Location stallActLoc = null;
    private Location stallNextLoc = null;
    private int multipleRunCount = 0;
    private double multipleMargin = 10.0;
    Location tempNextLoc;
    State tempState;
    List<SensorMount> sonarGeo;
    Map.Entry<String, Double> greatestRiskSonar;
    private final double sonarThreashold = 4.91;
    private boolean shouldGoWithIt = true;
    int noriskCount = 0;
    int riskCount = 0;
    private SensorMasterModuleQueued senModule;
    private GeometryMasterModule geoModule;
    private ConfigMasterModule confModule;
    private ResponseModule resModule;
    private StateMasterModule staModule;
    static ScanPreview lf = null;

    public void robotInitialized(NfoMessage nfom) {
        super.robotInitialized(nfom);
        this.logicInitialize((LogicModule)this.logicModule);
        this.getAct().act((CommandMessage)new Initialize("USARBot.AirRobot", "AirRobot - aierial sample robot", ((StartPose)nfom.getStartPoses().get(0)).getName()));
        System.out.println(this.logicModule.isRunning());
    }

    public void initializeController(USAR2004Bot bot) {
        super.initializeController(bot);
    }

    public void logic() throws PogamutException {
        try {
            super.logic();
            if (lf == null) {
                return;
            }
            this.time = this.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getTime();
            this.issueInfos();
            while (this.resModule.size() > 0) {
                System.out.println(((ResponseSensorEffecter)this.resModule.pull()).getStatus());
            }
            if (!this.parametersObtained) {
                if (!this.acceptSensorMessage()) {
                    return;
                }
                this.getConfig();
                return;
            }
            this.acceptSensorMessages();
            this.checkBattery();
            if (!this.risen) {
                this.rise();
            } else {
                this.move();
            }
            lf.setInfo(this.infoToShow);
            lf.setPostInfo(this.infoToWrite);
        }
        catch (Exception e) {
            System.out.println("ERROR LOGIC. " + e.getMessage());
        }
    }

    private void issueInfos() {
        this.infoToShow = "";
        this.infoToShow = this.infoToShow + "\nRobot State: " + this.state.toString();
        this.infoToShow = this.infoToShow + "\nTime Elapsed: " + ToolBox.getTime((long)(System.currentTimeMillis() - this.startTime));
        this.infoToShow = this.infoToShow + "\n\nnoRiskCount: " + this.noriskCount;
        this.infoToShow = this.infoToShow + "\nriskCount: " + this.riskCount;
        this.infoToWrite = "";
        this.infoToWrite = this.infoToWrite + "Elapsed: " + ToolBox.getTime((long)(System.currentTimeMillis() - this.startTime));
        this.infoToWrite = this.infoToWrite + "\nBattery Cycles: " + this.battFills;
    }

    private boolean acceptSensorMessage() {
        if (!(this.senModule.isSensorReady(SensorType.LASER_SENSOR) && this.senModule.isSensorReady(SensorType.INS_SENSOR) && this.senModule.isSensorReady(SensorType.GROUND_TRUTH) && this.senModule.isSensorReady(SensorType.RANGE_SENSOR))) {
            return false;
        }
        this.laser = (SensorLaser)this.senModule.getSensorsBySensorType(SensorType.LASER_SENSOR).get(0);
        this.ins = (SensorINS)this.senModule.getSensorsBySensorType(SensorType.INS_SENSOR).get(0);
        this.sonar = (SensorRange)this.senModule.getSensorsBySensorType(SensorType.RANGE_SENSOR).get(0);
        this.truth = (SensorGroundTruth)this.senModule.getSensorsBySensorType(SensorType.GROUND_TRUTH).get(0);
        return true;
    }

    private void acceptSensorMessages() {
        List lasers = this.senModule.getSensorsBySensorType(SensorType.LASER_SENSOR);
        List inses = this.senModule.getSensorsBySensorType(SensorType.INS_SENSOR);
        List sonars = this.senModule.getSensorsBySensorType(SensorType.RANGE_SENSOR);
        List truths = this.senModule.getSensorsBySensorType(SensorType.GROUND_TRUTH);
        int minIndex = ToolBox.getMin((int)lasers.size(), (int)inses.size(), (int)sonars.size(), (int)truths.size());
        for (int i = 0; i < minIndex; ++i) {
            this.laser = (SensorLaser)lasers.get(i);
            this.truth = (SensorGroundTruth)truths.get(i);
            this.ins = (SensorINS)inses.get(i);
            this.sonar = (SensorRange)sonars.get(i);
            this.refreshScanProcedure();
        }
    }

    private void refreshScanProcedure() {
        this.actLoc = Location.sub((Location)this.startLoc, (Location)this.ins.getLocation());
        this.actRot = this.ins.getOrientation();
        lf.setRecord(new Record(this.laser.getRanges(), null, this.laser.getFOV()));
        lf.setLocation(this.actLoc);
        lf.setOrientation(this.actRot);
        lf.refreshGraphics();
    }

    private void checkBattery() {
        this.trip += Location.getDistance2D((Location)this.actLoc, (Location)this.prevLoc);
        this.prevLoc = this.actLoc;
        double battUsed = this.battFull - this.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
        double range = (500.0 - battUsed) * (this.trip / battUsed);
        double distanceFromHome = Location.getDistance2D((Location)this.actLoc, (Location)this.zeroPoint);
        this.infoToShow = this.infoToShow + "\n\nBatteryLife: 500";
        this.infoToShow = this.infoToShow + "\nBatteryUsed: " + battUsed;
        this.infoToShow = this.infoToShow + "\n\nDistance From Home: " + ToolBox.getTwoDecimalPlaces((double)distanceFromHome);
        this.infoToShow = this.infoToShow + "\nDistance From Next: " + ToolBox.getTwoDecimalPlaces((double)Location.getDistance2D((Location)this.actLoc, (Location)this.nextLoc));
        this.infoToShow = this.infoToShow + "\nRange: " + ToolBox.getTwoDecimalPlaces((double)range);
        if (this.state == State.CHARGE || this.state == State.CHARGING || this.state == State.TERMINATE || this.state == State.LAND || this.tempState == State.TERMINATE || this.tempState == State.CHARGE || this.trip < 5.0) {
            return;
        }
        if (distanceFromHome > range * 0.85) {
            if (this.state == State.CONTINUE) {
                this.finishGoalToStart();
                return;
            }
            if (this.state == State.AVOIDING && this.tempState == State.CHARGE) {
                return;
            }
            if (this.state == State.AVOIDING) {
                this.stallState = this.tempState;
                this.stallNextLoc = this.tempNextLoc;
                this.tempNextLoc = null;
                this.stallActLoc = Location.getDistance2D((Location)this.actLoc, (Location)this.stallNextLoc) < 15.0 ? this.stallNextLoc : this.actLoc;
            } else {
                this.stallState = this.state;
                this.stallNextLoc = this.nextLoc;
                this.stallActLoc = Location.getDistance2D((Location)this.actLoc, (Location)this.nextLoc) < 15.0 ? this.nextLoc : this.actLoc;
            }
            this.state = State.CHARGE;
            this.nextLoc = this.zeroPoint;
            this.minDev = 1.5;
            lf.setRechargeBreakPoint(this.actLoc);
        }
    }

    private Location getClosestCorner(Location center, double width, double height, Location actual) {
        Location closest = new Location(center.x - width / 2.0, center.y + height / 2.0);
        Location rt = new Location(center.x + width / 2.0, center.y + height / 2.0);
        Location lb = new Location(center.x - width / 2.0, center.y - height / 2.0);
        Location rb = new Location(center.x + width / 2.0, center.y - height / 2.0);
        if (Location.getDistance2D((Location)closest, (Location)actual) > Location.getDistance2D((Location)rt, (Location)actual)) {
            closest = rt;
        }
        if (Location.getDistance2D((Location)closest, (Location)actual) > Location.getDistance2D((Location)lb, (Location)actual)) {
            closest = lb;
        }
        if (Location.getDistance2D((Location)closest, (Location)actual) > Location.getDistance2D((Location)rb, (Location)actual)) {
            closest = rb;
        }
        return closest;
    }

    private void setupSteps(Location center, Location corner) {
        if (this.dHeight > this.dWidth) {
            double density = this.dWidth / Math.ceil(this.dWidth / this.minDensity);
            this.longStep = new Location(0.0, this.dHeight * Math.signum(center.y - corner.y));
            this.shortStep = new Location(density * Math.signum(center.x - corner.x), 0.0);
            this.cycleStop = (int)(this.dWidth / density);
        } else {
            double density = this.dHeight / Math.ceil(this.dHeight / this.minDensity);
            this.longStep = new Location(this.dWidth * Math.signum(center.x - corner.x), 0.0);
            this.shortStep = new Location(0.0, density * Math.signum(center.y - corner.y));
            this.cycleStop = (int)(this.dHeight / density);
        }
    }

    private void checkAltitudeFromLaser() {
        this.offset = (int)(this.actRot.roll >= Math.PI ? 360.0 - this.actRot.roll * 180.0 / Math.PI : -this.actRot.roll * 180.0 / Math.PI);
        this.actAlt = this.laser.getNMidAvg(10, this.offset);
        lf.setOffset(this.offset);
    }

    private void rise() {
        if (this.altitude == 0.0) {
            return;
        }
        this.actAlt = this.laser.getNMidAvg(10);
        this.bot.getAct().act((CommandMessage)new DriveAerial(this.maxAltitudeVelocity / 4.0, 0.0, 0.0, 0.0, false));
        if (this.altitude - this.actAlt < 0.0) {
            this.risen = true;
            this.bot.getAct().act((CommandMessage)new DriveAerial(0.0, 0.0, 0.0, 0.0, false));
        }
    }

    private void move() {
        this.checkAltitudeFromLaser();
        if (this.state != State.CHARGING && this.state != State.LAND && this.checkSonars() == RiskLevel.HIGHRISK) {
            return;
        }
        this.approachNext();
        boolean bl = this.scanning = this.state == State.AVOIDING ? this.isScanning(this.tempState) : this.isScanning(this.state);
        if (this.state == State.CHARGING || this.state == State.LAND) {
            if (this.wait(8)) {
                if (this.state == State.CHARGING) {
                    this.setResumeState();
                } else if (!this.singleFlight && this.wait(8)) {
                    this.setupMultiple();
                }
            }
            return;
        }
        if (this.hasReachedTarget(this.actLoc, this.nextLoc)) {
            this.state = State.getNextState((State)this.state);
            this.computeNext(this.state);
        }
        this.carryOnIfJammed();
    }

    private boolean isScanning(State state) {
        return state == State.LONGFORTH || state == State.SHORTFORTH || state == State.LONGBACK || state == State.SHORTBACK;
    }

    private boolean hasReachedTarget(Location actual, Location target) {
        return !(Location.getDistance2D((Location)actual, (Location)target) > this.minDev);
    }

    private void finishGoalToStart() {
        this.state = State.TERMINATE;
        this.nextLoc = new Location(0.0, 0.0, 0.0);
    }

    private void computeNext(State state) {
        switch (state) {
            case DEFAULT: 
            case LONGFORTH: {
                this.nextLoc = this.nextLoc.add(this.longStep);
                break;
            }
            case SHORTFORTH: 
            case SHORTBACK: {
                this.nextLoc = this.nextLoc.add(this.shortStep);
                if (this.cycle >= this.cycleStop) {
                    this.finishGoalToStart();
                }
                ++this.cycle;
                break;
            }
            case LONGBACK: {
                this.nextLoc = this.nextLoc.sub(this.longStep);
                break;
            }
            case TERMINATE: {
                break;
            }
            case LAND: 
            case CHARGING: {
                this.altitude = 0.0;
                break;
            }
            case CONTINUED: {
                this.continueScanning();
                break;
            }
            case AVOIDED: {
                this.tryReleaseDiversion();
                break;
            }
            default: {
                System.out.println("Unexpected STATE");
            }
        }
    }

    private void setupMultiple() {
        switch (this.multipleRunCount) {
            case 1: {
                this.destination = new Location(this.destCenter.x - this.dWidth / 2.0 - this.multipleMargin, this.destCenter.y + this.dHeight / 2.0 + this.multipleMargin);
                break;
            }
            case 2: {
                this.destination = new Location(this.destCenter.x - this.dWidth / 2.0 - this.multipleMargin, this.destCenter.y - this.dHeight / 2.0 - this.multipleMargin);
                break;
            }
            case 3: {
                this.destination = new Location(this.destCenter.x + this.dWidth / 2.0 + this.multipleMargin, this.destCenter.y - this.dHeight / 2.0 - this.multipleMargin);
                break;
            }
            case 4: {
                this.altitude = 0.0;
            }
        }
        if (this.multipleRunCount < 4) {
            this.resetINS();
            this.nextLoc = this.getClosestCorner(this.destination, this.dWidth, this.dHeight, new Location(0.0, 0.0, 0.0));
            this.setupSteps(this.destination, this.nextLoc);
            this.cycle = 0;
            this.state = State.DEFAULT;
            ++this.multipleRunCount;
            this.prepareForTakeof();
        }
    }

    private void initMultipleRun() {
        this.dWidth = 87.0 - this.multipleMargin;
        this.dHeight = 87.0 - this.multipleMargin;
        this.destination = new Location(this.destCenter.x + this.dWidth / 2.0 + this.multipleMargin, this.destCenter.y + this.dHeight / 2.0 + this.multipleMargin);
    }

    private boolean wait(int timeSpan) {
        if (this.timeStamp == -1.0) {
            this.timeStamp = this.time;
        } else if (this.time - this.timeStamp > (double)timeSpan) {
            return true;
        }
        return false;
    }

    private void tryReleaseDiversion() {
        if (this.state == State.AVOIDING || this.state == State.AVOIDED) {
            this.nextLoc = this.tempNextLoc;
            this.tempNextLoc = null;
            this.state = this.tempState;
        }
    }

    private void continueScanning() {
        this.state = this.stallState;
        this.nextLoc = this.stallNextLoc;
        this.stallNextLoc = null;
        this.minDev = 0.9;
    }

    private void setResumeState() {
        this.resetINS();
        this.state = State.CONTINUE;
        this.nextLoc = this.stallActLoc;
        this.stallActLoc = null;
        this.prepareForTakeof();
    }

    private void prepareForTakeof() {
        this.risen = false;
        ++this.battFills;
        double battUsed = this.battFull - this.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
        double range = (500.0 - battUsed) * (this.trip / battUsed);
        System.out.println("range left: " + range + " trip odometer: " + this.trip + " battery used: " + battUsed);
        this.battFull = this.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
        this.trip = 0.0;
        this.timeStamp = -1.0;
        this.altitude = 6.0;
    }

    private void resetINS() {
        Location truthLoc = this.truth.getLocation();
        Rotation truthRot = this.truth.getOrientation();
        lf.setStartLocation(Location.sub((Location)this.startLoc, (Location)truthLoc.getLocation()));
        StringBuilder sb = new StringBuilder();
        sb.append(truthLoc.x).append(',').append(truthLoc.y).append(',').append(truthLoc.z).append(',');
        sb.append(truthRot.roll).append(',').append(truthRot.pitch).append(',').append(truthRot.yaw);
        this.bot.getAct().act((CommandMessage)new SetSensorEffecter("INS", "INS", "POSE", sb.toString()));
    }

    private double getAngle(double sx, double cx) {
        if (sx > 0.0 && cx > 0.0) {
            return Math.acos(Math.abs(cx)) * 180.0 / Math.PI;
        }
        if (sx > 0.0 && cx <= 0.0) {
            return 180.0 - Math.acos(Math.abs(cx)) * 180.0 / Math.PI;
        }
        if (sx <= 0.0 && cx <= 0.0) {
            return 180.0 + Math.acos(Math.abs(cx)) * 180.0 / Math.PI;
        }
        return 360.0 - Math.acos(Math.abs(cx)) * 180.0 / Math.PI;
    }

    private void approachNext() {
        this.speed = this.scanning ? 0.2 : 0.35;
        this.rotSpeed = this.scanning ? 0.2 : 0.2333333333333333;
        double linVel = this.maxLinearVelocity * this.speed;
        double diff = this.getTargetAngle(false);
        double rotVel = Math.signum(-diff) * Math.min(Math.abs(this.maxRotationalVelocity * (-diff / 90.0)), this.rotSpeed);
        double altVel = this.actLoc.z < 4.0 && this.actAlt > 6.0 && this.state != State.LAND && this.state != State.CHARGING ? this.maxAltitudeVelocity * (3.0 - this.actLoc.z) / 6.0 : this.maxAltitudeVelocity * (this.altitude - this.actAlt) / 5.0;
        linVel = this.state == State.AVOIDING || Location.getDistance2D((Location)this.actLoc, (Location)this.nextLoc) < 2.7 ? (Math.abs(rotVel) >= this.rotSpeed ? 0.0 : linVel) : (Math.abs(rotVel) >= this.rotSpeed ? linVel * 3.0 / 5.0 : linVel);
        this.shouldGoWithIt = true;
        if (Math.abs(rotVel) >= this.rotSpeed) {
            this.noriskCount = Math.max(0, this.noriskCount - 1);
            if (this.state == State.AVOIDING) {
                this.shouldGoWithIt = false;
            }
        }
        if (this.state == State.TERMINATE || this.state == State.CHARGE) {
            linVel *= Math.min(Location.getDistance2D((Location)this.actLoc, (Location)this.nextLoc) / 6.0, 1.0);
        }
        if (this.state == State.LAND || this.state == State.CHARGING) {
            this.bot.getAct().act((CommandMessage)new DriveAerial(altVel, 0.0, 0.0, 0.0, false));
        } else {
            altVel = Math.abs(rotVel) >= this.rotSpeed ? 0.0 : altVel;
            this.bot.getAct().act((CommandMessage)new DriveAerial(altVel, linVel, 0.0, rotVel, false));
        }
    }

    private void computeDiversion(Map<String, Double> sonars) {
        RiskLevel targetRiskLevel;
        boolean leftSide = true;
        double leftWM = 0.0;
        double rightWM = 0.0;
        double leftFittest = 0.0;
        double rightFittest = 0.0;
        int leftFindex = 0;
        int rightFindex = 0;
        int greatestRiskIndex = -1;
        for (int i = 0; i < sonars.size(); ++i) {
            Double entry = sonars.get(this.sonarOrder[i]);
            if (this.sonarOrder[i].equals(this.greatestRiskSonar.getKey())) {
                greatestRiskIndex = i;
                leftSide = false;
                continue;
            }
            if (leftSide) {
                leftWM += entry * entry;
                if (!(leftFittest < entry) && !(entry > 4.91)) continue;
                leftFittest = entry;
                leftFindex = i;
                continue;
            }
            rightWM += entry * entry;
            if (!(rightFittest < entry) || !(rightFittest < 4.91)) continue;
            rightFittest = entry;
            rightFindex = i;
        }
        if (leftWM < rightWM) {
            RiskLevel righterRisk;
            if (rightFindex < 7 && sonars.get(this.sonarOrder[rightFindex - 1]) < 2.5) {
                RiskLevel righterRisk2 = this.getRiskLevel(this.sonarOrder[rightFindex + 2], sonars.get(this.sonarOrder[rightFindex + 2]));
                if (righterRisk2 == RiskLevel.NORISK) {
                    rightFindex += 2;
                }
            } else if (rightFindex < 8 && (righterRisk = this.getRiskLevel(this.sonarOrder[rightFindex + 1], sonars.get(this.sonarOrder[rightFindex + 1]))) == RiskLevel.NORISK) {
                ++rightFindex;
            }
            int targetIndex = this.getSonarTargetIndex();
            if (targetIndex > rightFindex && targetIndex < 8 && (targetRiskLevel = this.getRiskLevel(this.sonarOrder[targetIndex], sonars.get(this.sonarOrder[targetIndex]))) == RiskLevel.NORISK) {
                rightFindex = targetIndex;
                this.tryReleaseDiversion();
                return;
            }
            this.setDiversionPoint(rightFindex, rightFittest);
        } else {
            RiskLevel lefterRisk;
            if (leftFindex > 1 && sonars.get(this.sonarOrder[leftFindex + 1]) < 1.5) {
                RiskLevel lefterRisk2 = this.getRiskLevel(this.sonarOrder[leftFindex - 2], sonars.get(this.sonarOrder[leftFindex - 2]));
                if (lefterRisk2 == RiskLevel.NORISK) {
                    leftFindex -= 2;
                }
            } else if (leftFindex > 0 && (lefterRisk = this.getRiskLevel(this.sonarOrder[leftFindex - 1], sonars.get(this.sonarOrder[leftFindex - 1]))) == RiskLevel.NORISK) {
                --leftFindex;
            }
            int targetIndex = this.getSonarTargetIndex();
            if (targetIndex < leftFindex && targetIndex > 0 && (targetRiskLevel = this.getRiskLevel(this.sonarOrder[targetIndex], sonars.get(this.sonarOrder[targetIndex]))) == RiskLevel.NORISK) {
                leftFindex = targetIndex;
                this.tryReleaseDiversion();
                return;
            }
            this.setDiversionPoint(leftFindex, leftFittest);
        }
    }

    private void setDiversionPoint(int index, double fittest) {
        Rotation sonarRot = this.sonarGeo.get(index).getOrientation();
        double angle = 1.5707963267948966 - (sonarRot.yaw + this.actRot.yaw) + (this.greatestRiskSonar.getKey().charAt(0) == 'L' ? -0.3 : (this.greatestRiskSonar.getKey().charAt(0) == 'R' ? 0.3 : 0.0));
        Location actDiv = new Location(-Math.sin(angle) * fittest, -Math.cos(angle) * fittest);
        Location diversion = this.actLoc.add(actDiv);
        lf.setDivPoint(diversion);
        if (this.state != State.AVOIDING) {
            this.tempState = this.state;
            this.tempNextLoc = this.nextLoc;
        }
        this.state = State.AVOIDING;
        this.nextLoc = diversion;
    }

    private double getTargetAngle(boolean actual) {
        double v1y;
        double v1x;
        if (actual && this.state == State.AVOIDING && this.tempNextLoc != null) {
            v1x = this.tempNextLoc.x - this.actLoc.x;
            v1y = this.tempNextLoc.y - this.actLoc.y;
        } else {
            v1x = this.nextLoc.x - this.actLoc.x;
            v1y = this.nextLoc.y - this.actLoc.y;
        }
        double v1l = Math.sqrt(v1x * v1x + v1y * v1y);
        double sinv1 = v1y / v1l;
        double cosv1 = v1x / v1l;
        double v1Theta = (this.getAngle(sinv1, cosv1) + 180.0) % 360.0;
        double v2Theta = this.actRot.yaw * 180.0 / Math.PI;
        double diff = v2Theta - v1Theta;
        if (diff > 180.0) {
            diff -= 360.0;
        } else if (diff < -180.0) {
            diff += 360.0;
        }
        return diff;
    }

    private int getSonarTargetIndex() {
        int sonarIndex = -1;
        int count = 0;
        double v1Theta = this.getTargetAngle(true) / 180.0 * Math.PI;
        double minDiv = 7.0;
        for (SensorMount sensorMount : this.sonarGeo) {
            if (minDiv > Math.abs(v1Theta - sensorMount.getOrientation().yaw)) {
                minDiv = Math.abs(v1Theta - sensorMount.getOrientation().yaw);
                sonarIndex = count;
            }
            ++count;
        }
        return sonarIndex;
    }

    private void abortAim() {
        String key = this.greatestRiskSonar.getKey();
        Point2D velocity = this.highRiskAction.get(key);
        this.getAct().act((CommandMessage)new DriveAerial(0.0, velocity.getX() * 40.0, velocity.getY() * 40.0, 0.0, true));
    }

    private RiskLevel checkSonars() {
        RiskLevel worstThread = this.getRiskLevel(this.sonar.getRanges());
        if (worstThread != RiskLevel.NORISK && this.greatestRiskSonar.getValue() > Location.getDistance2D((Location)this.actLoc, (Location)this.nextLoc)) {
            return RiskLevel.NORISK;
        }
        switch (worstThread) {
            case NORISK: {
                ++this.noriskCount;
                if (this.noriskCount > 6) {
                    this.tryReleaseDiversion();
                }
                if (this.noriskCount <= 15) break;
                this.riskCount = 0;
                break;
            }
            case LOWRISK: {
                if (this.shouldGoWithIt) {
                    this.computeDiversion(this.sonar.getRanges());
                }
                this.noriskCount = 0;
                ++this.riskCount;
                lf.setLowRiskPoint(this.actLoc);
                break;
            }
            case HIGHRISK: {
                this.abortAim();
                this.noriskCount = 0;
                lf.setHighRiskPoint(this.actLoc);
                ++this.riskCount;
            }
        }
        return worstThread;
    }

    private void carryOnIfJammed() {
        if ((double)this.riskCount > 35.0 * (0.35 / this.speed)) {
            if (this.state == State.CHARGE || this.tempState == State.CHARGE || this.tempState == State.TERMINATE || this.state == State.TERMINATE) {
                this.getAct().act((CommandMessage)new DriveAerial(0.0, -this.maxLinearVelocity, 0.0, 0.0, false));
                this.riskCount = 0;
                return;
            }
            if (this.state == State.AVOIDING) {
                this.tryReleaseDiversion();
            } else if (this.state == State.CONTINUE) {
                this.continueScanning();
            }
            this.state = State.getNextState((State)this.state);
            this.computeNext(this.state);
            this.riskCount = 0;
        }
    }

    private RiskLevel getRiskLevel(Map<String, Double> sonars) {
        LinkedList<Double> sonarValues = new LinkedList<Double>();
        for (int i = 0; i < sonars.size(); ++i) {
            sonarValues.add(sonars.get(this.sonarOrder[i]));
        }
        lf.setSonars(sonarValues);
        RiskLevel globalRisk = RiskLevel.NORISK;
        double riskValue = 4.91;
        for (Map.Entry<String, Double> entry : sonars.entrySet()) {
            RiskLevel risk = this.getRiskLevel(entry);
            if (risk.isGreaterRisk(globalRisk)) {
                globalRisk = risk;
                riskValue = entry.getValue();
                this.greatestRiskSonar = entry;
                continue;
            }
            if (risk != globalRisk || !(entry.getValue() < riskValue)) continue;
            riskValue = entry.getValue();
            this.greatestRiskSonar = entry;
        }
        return globalRisk;
    }

    private RiskLevel getRiskLevel(Map.Entry<String, Double> sonar) {
        return sonar.getValue() < this.lowRisk.get(sonar.getKey()) ? (sonar.getValue() < this.highRisk.get(sonar.getKey()) ? RiskLevel.HIGHRISK : RiskLevel.LOWRISK) : RiskLevel.NORISK;
    }

    private RiskLevel getRiskLevel(String sonar, double value) {
        return value < this.lowRisk.get(sonar) ? (value < this.highRisk.get(sonar) ? RiskLevel.HIGHRISK : RiskLevel.LOWRISK) : RiskLevel.NORISK;
    }

    private boolean isLargeSpace() {
        return true;
    }

    private void getConfig() {
        if (!this.confModule.isReady().booleanValue()) {
            this.confModule.queryConfigurationByType("Robot");
        } else if (!this.geoModule.isReady().booleanValue()) {
            this.geoModule.queryGeometryByType("Sonar");
        } else if (this.senModule.isReady().booleanValue()) {
            ConfigAerial robotCfg = (ConfigAerial)this.confModule.getConfigurationsByConfigType(ConfigType.AERIAL_VEHICLE).get(0);
            this.maxLateralVelocity = Double.parseDouble(robotCfg.getFeatureValueBy("MaxLateralVelocity"));
            this.maxLinearVelocity = Double.parseDouble(robotCfg.getFeatureValueBy("MaxLinearVelocity"));
            this.maxAltitudeVelocity = Double.parseDouble(robotCfg.getFeatureValueBy("MaxAltitudeVelocity"));
            this.maxRotationalVelocity = Double.parseDouble(robotCfg.getFeatureValueBy("MaxRotationalVelocity"));
            this.startLoc = this.ins.getLocation();
            this.singleFlight = !this.isLargeSpace();
            this.actLoc = this.zeroPoint;
            this.prevLoc = this.zeroPoint;
            lf.setStartLocation(this.zeroPoint);
            lf.setDatFile(false);
            if (this.singleFlight) {
                this.nextLoc = this.getClosestCorner(this.destination, 174.0, 174.0, new Location(0.0, 0.0, 0.0));
                this.setupSteps(this.destination, this.nextLoc);
            } else {
                this.initMultipleRun();
                this.setupMultiple();
            }
            this.battFull = this.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
            this.startTime = System.currentTimeMillis();
            this.sonarGeo = ((GeoSensorEffecter)this.geoModule.getGeometriesByGeometryType(GeometryType.SENSOR_EFFECTER).get(0)).getSensorMountCollection();
            this.parametersObtained = true;
        }
    }

    public void prepareBot(USAR2004Bot bot) {
        super.prepareBot(bot);
        this.senModule = SensorMasterModuleQueued.getModuleInstance((USAR2004Bot)bot);
        this.geoModule = GeometryMasterModule.getModuleInstance((USAR2004Bot)bot);
        this.confModule = ConfigMasterModule.getModuleInstance((USAR2004Bot)bot);
        this.resModule = ResponseModule.getModuleInstance((USAR2004Bot)bot);
        this.staModule = StateMasterModule.getModuleInstance((USAR2004Bot)bot);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    lf = new ScanPreview();
                    lf.runScanPreview();
                    lf.show();
                }
                catch (Exception e) {
                    System.out.println("error");
                }
            }
        });
        try {
            new USAR2004BotRunner(AirRobot.class, "PogamutBotBot", "127.0.0.1", 3000).setMain(true).setLogLevel(Level.OFF).startAgent();
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
    }
}

