package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;

/**
 * Sense that shows wether the robot is heading towards home for recharge or
 * not. The robot could be currently avoiding an obstacle or the range counter
 * could have improved due to faster home-approach flying speed.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "HeadingHome", description = "Is the robot heading towards the base?")
public class HeadingHome extends StateSense<AirRobotContext, Boolean>
{
    public HeadingHome(AirRobotContext ctx)
    {
        super("HeadingHome", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        //System.out.println("HeadingHome");
        return isHeadingHome();
    }
    
    /**
     * Checks wether the robot is returning to recharge or not.
     *
     * @return Returns true if robots next goal is its start position.
     */
    public boolean isHeadingHome()
    {
        if(ctx.state == State.CHARGE || ctx.state == State.TERMINATE || ctx.tempState == State.TERMINATE || ctx.tempState == State.CHARGE || ctx.isLanding() || ctx.trip < 5)//trip<5->range not credible
        {
            return true;
        }
        return false;
    }
}
