package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Action that triggers events that causes robot to return back to base for a
 * recharge and to remember current scanning state.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "SuspendScanProcedure", description = "Causes the robot to return for a recharge.")
public class SuspendScanProcedure extends StateAction<AirRobotContext>
{
    public SuspendScanProcedure(AirRobotContext ctx)
    {
        super("SuspendScanProcedure", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("suspend");
        ctx.setStallState();
        ctx.setRechargePoint();
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext params)
    {
        //before the run() call.
    }

    @Override
    public void done(VariableContext params)
    {
        //after last call - a new rule applied.
    }
}
