/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.context.Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.RiskLevel;

@PrimitiveInfo(name="CurrentThreatLevel", description="Is the robot near some obstacle?")
public class CurrentThreatLevel
extends StateSense<AirRobotContext, Integer> {
    public CurrentThreatLevel(AirRobotContext ctx) {
        super("CurrentThreatLevel", (Context)ctx);
    }

    public Integer query(VariableContext params) {
        RiskLevel risk = this.getGreatesRiskLevel();
        if (risk == RiskLevel.HIGHRISK) {
            return 2;
        }
        if (risk == RiskLevel.LOWRISK) {
            return 1;
        }
        return 0;
    }

    public RiskLevel getGreatesRiskLevel() {
        String worstSonar = ((AirRobotContext)this.ctx).getGreatestRiskSensor(((AirRobotContext)this.ctx).sonar.getRanges());
        if (worstSonar == null) {
            return RiskLevel.NORISK;
        }
        Double worstValue = ((AirRobotContext)this.ctx).sonar.getRangeByName(worstSonar);
        RiskLevel worstThreat = ((AirRobotContext)this.ctx).getRiskLevel(worstSonar, worstValue);
        if (worstThreat == RiskLevel.LOWRISK && worstValue > Location.getDistance2D((Location)((AirRobotContext)this.ctx).actLoc, (Location)((AirRobotContext)this.ctx).nextLoc)) {
            return RiskLevel.NORISK;
        }
        return worstThreat;
    }
}

