/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.sposh.context.Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveAerial;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.ScanAreaAnalysis;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.Wait;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;

@PrimitiveInfo(name="DockRobot", description="Robot will go straight down.")
public class DockRobot
extends StateAction<AirRobotContext> {
    public DockRobot(AirRobotContext ctx) {
        super("DockRobot", (Context)ctx);
    }

    public ActionResult run(VariableContext vc) {
        try {
            ((AirRobotContext)this.ctx).issueNoRisk();
            this.dockRobot();
            return ActionResult.FINISHED;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return ActionResult.FAILED;
        }
    }

    public void init(VariableContext vc) {
    }

    public void done(VariableContext vc) {
    }

    public void dockRobot() {
        double time;
        double altVel = ((AirRobotContext)this.ctx).maxAltitudeVelocity * (((AirRobotContext)this.ctx).altitude - ((AirRobotContext)this.ctx).actAlt) / 5.0;
        if (((AirRobotContext)this.ctx).isLanding()) {
            ((AirRobotContext)this.ctx).getAct().act((CommandMessage)new DriveAerial(altVel, 0.0, 0.0, 0.0, false));
        }
        if (Wait.wait(time = ((AirRobotContext)this.ctx).staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getTime(), ((AirRobotContext)this.ctx).dockWaitPenalty)) {
            if (((AirRobotContext)this.ctx).state == State.CHARGING) {
                this.setResumeState();
            } else if (ScanAreaAnalysis.isLargeSpace()) {
                ((AirRobotContext)this.ctx).setupMultiple(((AirRobotContext)this.ctx).multipleRunCount);
            }
        }
    }

    public void setResumeState() {
        ((AirRobotContext)this.ctx).resetINS();
        System.out.println("afterINSReset");
        ((AirRobotContext)this.ctx).state = State.CONTINUE;
        if (((AirRobotContext)this.ctx).stallActLoc == null) {
            return;
        }
        ((AirRobotContext)this.ctx).nextLoc = ((AirRobotContext)this.ctx).stallActLoc;
        if (((AirRobotContext)this.ctx).tempState != null) {
            System.out.println("stallActLoc: " + ((AirRobotContext)this.ctx).stallActLoc.toString());
            System.out.println("tempState: " + ((AirRobotContext)this.ctx).tempState.toString());
        } else {
            System.out.println("stallActLoc: " + ((AirRobotContext)this.ctx).stallActLoc.toString());
            System.out.println("tempState is null");
        }
        System.out.println("afterInfoIssued");
        ((AirRobotContext)this.ctx).prepareForTakeof();
        System.out.println("altPrepareForTakeof");
    }
}

