package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Sense for deciding wether the robot should go fill the battery and resset or
 * not.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "LowRange", description = "Is there enough battery to continue scanning?")
public class LowRange extends StateSense<AirRobotContext, Boolean>
{
    public LowRange(AirRobotContext ctx)
    {
        super("LowRange", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        //System.out.println("LowRange");
        return !hasEnoughRange();
    }
    
    /**
     * Checks the battery and updates range and trip.
     * @return Returns true if the battery level is high enough. False if not.
     */
    public boolean hasEnoughRange()
    {
        ctx.trip += Location.getDistance2D(ctx.actLoc, ctx.prevLoc);
        ctx.prevLoc = ctx.actLoc;
        double battUsed = ctx.battFull - ctx.staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
        double range = (ctx.battLife - battUsed) * (ctx.trip / battUsed);
        double distanceFromHome = Location.getDistance2D(ctx.actLoc, Location.ZERO);
        if(distanceFromHome > range * ctx.rangeCoeficient)
        {
            return false;
        }
        return true;
    }
}
