package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveAerial;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;

/**
 * Action that causes aborting purstuit of the current chase point and moves on
 * to the next in line.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "FollowNextCheckpoint", description = "Robot will leave its current pursuit point and try to go for the next one.")
public class FollowNextCheckpoint extends StateAction<AirRobotContext>
{
    public FollowNextCheckpoint(AirRobotContext ctx)
    {
        super("FollowNextCheckpoint", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("FollowNext");
        chaseNextCheckpoint();
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
    /**
     * *
     * If the Robot is avoiding some obstacle for a long time(edge of the world,
     * target Location in the middle of a tree/house etc.), there is probably no
     * point trying any further. Next Location to go after the one currently
     * pursued is computed and given to the robot to chase. The robot simply
     * leaves out its original goal after some time trying to avoid an obstacle.
     */
    public void chaseNextCheckpoint()
    {
        if(ctx.state == State.CHARGE || ctx.tempState == State.CHARGE || ctx.tempState == State.TERMINATE || ctx.state == State.TERMINATE)
        {
            //the robot has to go home - no next checkpoint.
            ctx.getAct().act(new DriveAerial(0, -ctx.maxLinearVelocity, 0, 0, false));
            ctx.riskCount = 0;
            return;
        }
        if(ctx.state == State.AVOIDING)
        {
            ctx.tryReleaseDiversion();
        }
        else if(ctx.state == State.CONTINUE)
        {
            ctx.continueScanning();
        }
        ctx.state = State.getNextState(ctx.state);
        ctx.computeNext(ctx.state);
        ctx.riskCount = 0;
    }
}
