package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;

/**
 * Action that aborts the procedure of scaning. If the robot is returning to
 * scan some distant area and during the return the battery goes low, it is
 * obvioust that the robot can not scan area that far. So there is no need to
 * keep coming back and forth to recharge.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "AbortMission", description = "Robot will abort current action and return back to base.")
public class AbortMission extends StateAction<AirRobotContext>
{
    public AbortMission(AirRobotContext ctx)
    {
        super("AbortMission", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("Abort!");
        
        //terminate the scanning process
        ctx.state = State.TERMINATE;
        ctx.nextLoc = new Location(0, 0, 0);
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
}
