package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.RiskLevel;

/**
 * Sense that tests the level of risk from the sonars.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "CurrentThreatLevel", description = "Is the robot near some obstacle?")
public class CurrentThreatLevel extends StateSense<AirRobotContext, Integer>
{
    public CurrentThreatLevel(AirRobotContext ctx)
    {
        super("CurrentThreatLevel", ctx);
    }

    @Override
    public Integer query(VariableContext params)
    {
        RiskLevel risk = getGreatesRiskLevel();
        if(risk == RiskLevel.HIGHRISK)
        {
            return 2;
        }
        if(risk == RiskLevel.LOWRISK)
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }
    
    /**
     * Checks the sonar ring for obstacles.
     * @return Returns a risk of the obstacle that is relatively closest.
     */
    public RiskLevel getGreatesRiskLevel()
    {
        String worstSonar = ctx.getGreatestRiskSensor(ctx.sonar.getRanges());
        if(worstSonar == null)
        {
            return RiskLevel.NORISK;
        }
        Double worstValue = ctx.sonar.getRangeByName(worstSonar);
        RiskLevel worstThreat = ctx.getRiskLevel(worstSonar, worstValue);

        //if the robots goal is closer than some obstacle we treat it as if it was not in danger.
        if(worstThreat == RiskLevel.LOWRISK && worstValue > Location.getDistance2D(ctx.actLoc, ctx.nextLoc))
        {
            return RiskLevel.NORISK;
        }
        return worstThreat;
    }
}
