package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;

/**
 * Sense that tells us that the robot is returning from recharge to re-enter the
 * scanning procedure.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "Continuing", description = "Is the robot heading towards the point where it needed a recharge?")
public class Continuing extends StateSense<AirRobotContext, Boolean>
{
    public Continuing(AirRobotContext ctx)
    {
        super("Continuing", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        //System.out.println("Continuing");
        return ctx.state == State.CONTINUE || ctx.tempState == State.CONTINUE;
    }
}
