package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.State;

/**
 * This action gets next state and redirects the robot to its next destination.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "ComputeNext", description = "This will compute next location to pursue.")
public class ComputeNext extends StateAction<AirRobotContext>
{
    public ComputeNext(AirRobotContext ctx)
    {
        super("ComputeNext", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("ComputeNext");
        if(ctx.tempState == null && ctx.state == State.AVOIDING)
        {
            System.out.println("state null");
        }
        //ctx.issueNoRisk();
        ctx.state = State.getNextState(ctx.state);
        ctx.computeNext(ctx.state);
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
}
