package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Sense for releasing the robot from a qandary. If the robot is avoiding some
 * obstacle for a long time it is taken as a stuck situation, where the robot
 * can't get to the desired location.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "StuckForALongTime", description = "Is the robot stuck at one place for some time?")
public class StuckForALongTime extends StateSense<AirRobotContext, Boolean>
{
    public StuckForALongTime(AirRobotContext ctx)
    {
        super("StuckForALongTime", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        //System.out.println("stuckForALongTime");
        return isStuckForALongTime();
    }
    
    /**
     * Method for checking whether the robot is trying to avoid an obstacle for far to long.
     * @return Returns true if the robot is presumably jammed.
     */
    public boolean isStuckForALongTime()
    {
        return (ctx.speed > 0) && (ctx.riskCount > ctx.jammedLimit * (ctx.flyingSpeed / ctx.speed));
    }
}
