package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Sense for initial configuration, We need to recieve configuration message
 * from the server(requires GetConfig command) to be able to proceed. We're
 * asking about the robot configuration to be able to establish maximum
 * velocities for propper behaviour.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "ConfigMessageRecieved", description = "Has the configuration module recieved a message yet?")
public class ConfigMessageRecieved extends StateSense<AirRobotContext, Boolean>
{
    public ConfigMessageRecieved(AirRobotContext ctx)
    {
        super("ConfigMessageRecieved", ctx);
    }

    @Override
    public Boolean query(VariableContext params)
    {
        //System.out.println("GotCfg?");
        //isReady returns false if there are no messages to get from the module
        return ctx.confModule.isReady();
    }
}
