/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.senses;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.context.Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorGroundTruth;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorINS;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorLaser;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorRange;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.Record;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.ToolBox;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@PrimitiveInfo(name="RobotReady", description="Is there enough battery to continue?")
public class RobotReady
extends StateSense<AirRobotContext, Boolean> {
    StringBuilder infoToShow = new StringBuilder();
    StringBuilder infoToSave = new StringBuilder();

    public RobotReady(AirRobotContext ctx) {
        super("RobotReady", (Context)ctx);
    }

    public Boolean query(VariableContext params) {
        boolean robotReady = ((AirRobotContext)this.ctx).parametersObtained;
        if (robotReady) {
            this.acceptSensorMessages();
        }
        return robotReady;
    }

    public boolean acceptSensorMessages() {
        List lasers = ((AirRobotContext)this.ctx).senModule.getSensorsBySensorType(SensorType.LASER_SENSOR);
        List inses = ((AirRobotContext)this.ctx).senModule.getSensorsBySensorType(SensorType.INS_SENSOR);
        List sonars = ((AirRobotContext)this.ctx).senModule.getSensorsBySensorType(SensorType.RANGE_SENSOR);
        List truths = ((AirRobotContext)this.ctx).senModule.getSensorsBySensorType(SensorType.GROUND_TRUTH);
        int minIndex = ToolBox.getMin((int)lasers.size(), (int)inses.size(), (int)sonars.size(), (int)truths.size());
        if (minIndex < 1) {
            return false;
        }
        for (int i = 0; i < minIndex; ++i) {
            ((AirRobotContext)this.ctx).laser = (SensorLaser)lasers.get(i);
            ((AirRobotContext)this.ctx).truth = (SensorGroundTruth)truths.get(i);
            ((AirRobotContext)this.ctx).ins = (SensorINS)inses.get(i);
            ((AirRobotContext)this.ctx).sonar = (SensorRange)sonars.get(i);
            this.refreshScanProcedure();
        }
        this.setSonarPreview(((AirRobotContext)this.ctx).sonar.getRanges());
        this.setInfos();
        this.issueInfos();
        return true;
    }

    public void issueInfos() {
        if (((AirRobotContext)this.ctx).state == null) {
            return;
        }
        this.addInfoToShow("Robot State", ((AirRobotContext)this.ctx).state.toString());
        this.addInfoToShow("Time Elapsed", ToolBox.getTime((long)(System.currentTimeMillis() - ((AirRobotContext)this.ctx).startTime)));
        this.addInfoToShow("\nnoRiskCount", String.valueOf(((AirRobotContext)this.ctx).noriskCount));
        this.addInfoToShow("riskCount", String.valueOf(((AirRobotContext)this.ctx).riskCount));
        double battUsed = ((AirRobotContext)this.ctx).battFull - ((AirRobotContext)this.ctx).staModule.getStatesByVehilceType(VehicleType.AERIAL_VEHICLE).getBattery();
        double range = ((double)((AirRobotContext)this.ctx).battLife - battUsed) * (((AirRobotContext)this.ctx).trip / battUsed);
        double distanceFromHome = Location.getDistance2D((Location)((AirRobotContext)this.ctx).actLoc, (Location)Location.ZERO);
        this.addInfoToShow("\nBatteryLife", String.valueOf(((AirRobotContext)this.ctx).battLife));
        this.addInfoToShow("BatteryUsed", String.valueOf(battUsed));
        this.addInfoToShow("Battery Cycles", String.valueOf(((AirRobotContext)this.ctx).battFills));
        this.addInfoToShow("\nDistance From Home", ToolBox.getTwoDecimalPlaces((double)distanceFromHome));
        this.addInfoToShow("Distance From Next", ToolBox.getTwoDecimalPlaces((double)Location.getDistance2D((Location)((AirRobotContext)this.ctx).actLoc, (Location)((AirRobotContext)this.ctx).nextLoc)));
        this.addInfoToShow("Range", ToolBox.getTwoDecimalPlaces((double)range));
        this.addInfoToSave("Elapsed: ", ToolBox.getTime((long)(System.currentTimeMillis() - ((AirRobotContext)this.ctx).startTime)));
        this.addInfoToSave("Battery Cycles", String.valueOf(((AirRobotContext)this.ctx).battFills));
    }

    public void setSonarPreview(Map<String, Double> sonars) {
        LinkedList<Double> sonarValues = new LinkedList<Double>();
        for (int i = 0; i < sonars.size(); ++i) {
            sonarValues.add(sonars.get(((AirRobotContext)this.ctx).sonarOrder[i]));
        }
        ((AirRobotContext)this.ctx).previewForm.setSonars(sonarValues);
    }

    public void setInfos() {
        ((AirRobotContext)this.ctx).previewForm.setInfo(this.infoToShow.toString());
        ((AirRobotContext)this.ctx).previewForm.setPostInfo(this.infoToSave.toString());
        this.infoToShow.delete(0, Math.max(this.infoToShow.length(), 0));
        this.infoToSave.delete(0, Math.max(this.infoToSave.length(), 0));
    }

    public void refreshScanProcedure() {
        ((AirRobotContext)this.ctx).actLoc = Location.sub((Location)((AirRobotContext)this.ctx).startLoc, (Location)((AirRobotContext)this.ctx).ins.getLocation());
        ((AirRobotContext)this.ctx).actRot = ((AirRobotContext)this.ctx).ins.getOrientation();
        ((AirRobotContext)this.ctx).checkAltitudeFromLaser();
        ((AirRobotContext)this.ctx).previewForm.setRecord(new Record(((AirRobotContext)this.ctx).laser.getRanges(), null, ((AirRobotContext)this.ctx).laser.getFOV()));
        ((AirRobotContext)this.ctx).previewForm.setLocation(((AirRobotContext)this.ctx).actLoc);
        ((AirRobotContext)this.ctx).previewForm.setOrientation(((AirRobotContext)this.ctx).actRot);
        ((AirRobotContext)this.ctx).previewForm.refreshGraphics();
    }

    public void addInfoToShow(String name, String value) {
        this.infoToShow.append("\n").append(name).append(": ").append(value);
    }

    public void addInfoToSave(String name, String value) {
        this.infoToSave.append("\n").append(name).append(": ").append(value);
    }
}

