package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;

/**
 * Action that issues a Command to the server asking about configuration of the
 * robot. This involves max. speed and so forth. Using POSH to do this in
 * combination of collecting geometry and sensor data is "spot on". We need to
 * issue just one query at a time for the server not to ignore multiple tasks.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "GetRobotConfiguration", description = "Asks the server about basic information about the Robot.")
public class GetRobotConfiguration extends StateAction<AirRobotContext>
{
    public GetRobotConfiguration(AirRobotContext ctx)
    {
        super("GetRobotConfiguration", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("GetGeo");
        ctx.confModule.queryConfigurationByType("Robot");
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
}
