package cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.actions;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveAerial;
import cz.cuni.amis.pogamut.usar2004.examples.sposhairrobot.AirRobotContext;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

/**
 * Action that flys the robot away from an obstacle. This action is a reponse
 * to High risk level thread.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "BackOff", description = "Robot will try to fly directly away from obstacle")
public class BackOff extends StateAction<AirRobotContext>
{
    public BackOff(AirRobotContext ctx)
    {
        super("BackOff", ctx);
    }

    @Override
    public ActionResult run(VariableContext vc)
    {
        //System.out.println("BackOff");
        issueHighRisk();
        return ActionResult.FINISHED;
    }

    @Override
    public void init(VariableContext vc)
    {
    }

    @Override
    public void done(VariableContext vc)
    {
    }
    
    /**
     * Will dodge an obstacle in a rashly manner.
     */
    public void issueHighRisk()
    {
        abortAim();
        ctx.noriskCount = 0;
        ctx.previewForm.setHighRiskPoint(ctx.actLoc);
        ctx.riskCount++;
    }
    
    /**
     * This will move the robot exactly opposite direction than the biggest threat location is.
     */
    public void abortAim()
    {
        String key = ctx.getGreatestRiskSensor(ctx.sonar.getRanges());
        Point2D velocity;
        if(key == null)
        {
            velocity = new math.geom2d.Point2D(0.1, 0);
        }
        else
        {
            velocity = highRiskAction.get(key);
        }
        ctx.getAct().act(new DriveAerial(0, velocity.getX() * 40, velocity.getY() * 40, 0, true));//*40 na procenta
        //TODO: //otočit o 180 nebo 360 a vybrat nejlepší cestu ven, nebo zhasnout.
    }
    
    final Map<String, Point2D> highRiskAction = new HashMap<String, Point2D>()
    {
        
        {//name, linear and lateral velocity coeficient
            put("L4", new math.geom2d.Point2D(-0.95, 0.31));
            put("R4", new math.geom2d.Point2D(-0.95, -0.31));
            put("L3", new math.geom2d.Point2D(-0.81, 0.59));
            put("R3", new math.geom2d.Point2D(-0.81, -0.59));
            put("L2", new math.geom2d.Point2D(-0.59, 0.81));
            put("R2", new math.geom2d.Point2D(-0.59, -0.81));
            put("L1", new math.geom2d.Point2D(-0.31, 0.95));
            put("R1", new math.geom2d.Point2D(-0.31, -0.95));
            put("M0", new math.geom2d.Point2D(-1, 0));
        }
    };
}
