package actions;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveSkid;
import cz.cuni.amis.pogamut.usar2004.examples.sposhp2dxrobot.P2DXContext;

/**
 * Action that causes robot to move to the side.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "DriveRight", description = "The robot will drive right.")
public class DriveRight extends StateAction<P2DXContext>
{
    public DriveRight(P2DXContext ctx)
    {
        super("DriveRight", ctx);
    }

    @Override
    public void init(VariableContext params)
    {
    }

    @Override
    public ActionResult run(VariableContext params)
    {
        ctx.getAct().act(new DriveSkid(ctx.speedSlow, ctx.speedTurn, false, false, false));
        return ActionResult.FINISHED;
    }

    @Override
    public void done(VariableContext params)
    {
    }
}
