/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.examples.p2dxrobot;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.DriveDirection;
import cz.cuni.amis.pogamut.usar2004.agent.module.logic.USAR2004BotLogicController;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.SensorSpecificModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorLaser;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.StartPose;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveSkid;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Initialize;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.utils.USAR2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.logging.Level;

@AgentScoped
public class P2DXRobot
extends USAR2004BotLogicController<USAR2004Bot> {
    private USAR2004BotLogicController log;
    public SensorSpecificModule<SensorLaser> laserModule;
    IWorldEventListener<NfoMessage> nfoList = new IWorldEventListener<NfoMessage>(){

        public void notify(NfoMessage t) {
            System.out.println("INFO INFO FOR STARTERS" + t.toString());
            if (!P2DXRobot.this.first) {
                P2DXRobot.this.first = true;
            }
        }
    };
    boolean first = false;
    int left = 0;
    int right = 0;
    private int step = 20;
    boolean reversActive = false;

    public void robotInitialized(NfoMessage nfom) {
        this.getAct().act((CommandMessage)new Initialize("USARBot.P2DX", "P2DX sample robot", ((StartPose)nfom.getStartPoses().get(0)).getName()));
    }

    public void initializeController(USAR2004Bot bot) {
        super.initializeController(bot);
    }

    public void prepareBot(USAR2004Bot bot) {
        super.prepareBot(bot);
        this.log = new USAR2004BotLogicController();
        this.laserModule = new SensorSpecificModule(bot, SensorLaser.class);
        this.getWorldView().addEventListener(NfoMessage.class, this.nfoList);
    }

    public void logic() throws PogamutException {
        if (!this.laserModule.isReady().booleanValue()) {
            return;
        }
        DriveDirection d = ((SensorLaser)this.laserModule.getModule()).getMostOpenDirection(200);
        switch (d) {
            case BACKWARD: {
                this.driveBackwards();
                break;
            }
            case FORWARD: {
                this.driveStraight();
                break;
            }
            case LEFT: {
                this.driveLeft();
                break;
            }
            case RIGHT: {
                this.driveRight();
                break;
            }
        }
    }

    private void driveLeft() {
        System.out.println("left");
        this.right = 10;
        this.left = 5;
        this.getAct().act((CommandMessage)new DriveSkid((double)this.left, (double)this.right, false, false, false));
    }

    private void driveRight() {
        System.out.println("right");
        this.right = 5;
        this.left = 10;
        this.getAct().act((CommandMessage)new DriveSkid((double)this.left, (double)this.right, false, false, false));
    }

    private void driveStraight() {
        System.out.println("straight");
        this.right = 15;
        this.left = 15;
        this.getAct().act((CommandMessage)new DriveSkid((double)this.left, (double)this.right, false, false, false));
    }

    private void driveBackwards() {
        System.out.println("back");
        if (this.step > 10) {
            this.right = -3;
            this.left = -3;
        } else {
            this.right = -3;
            this.left = 3;
        }
        --this.step;
        if (this.step == 0) {
            this.step = 20;
            this.reversActive = false;
        }
        this.getAct().act((CommandMessage)new DriveSkid((double)this.left, (double)this.right, false, false, false));
    }

    public static void main(String[] args) {
        new USAR2004BotRunner(P2DXRobot.class, "PogamutBotBot", "127.0.0.1", 3000).setMain(true).setLogLevel(Level.WARNING).startAgent();
    }
}

