package cz.cuni.amis.pogamut.usar2004.examples.p2dxrobot;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.usar2004.agent.*;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.DriveDirection;
import cz.cuni.amis.pogamut.usar2004.agent.module.logic.USAR2004BotLogicController;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.SensorSpecificModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorLaser;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveSkid;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Initialize;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.utils.*;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.logging.Level;

/**
 *
 * @author vejmanm
 */
@AgentScoped
public class P2DXRobot extends USAR2004BotLogicController<USAR2004Bot>
{
    /**
     * Method triggered after Game is initialized and STARTPOSES obtained. Tt
     * will spawn the robot into the environment.
     *
     * @param nfom NfoMessge containing STARTPOSES
     */
    @Override
    public void robotInitialized(NfoMessage nfom)
    {
        getAct().act(new Initialize("USARBot.P2DX", "P2DX sample robot", nfom.getStartPoses().get(0).getName()));
    }

    @Override
    public void initializeController(USAR2004Bot bot)
    {
        super.initializeController(bot);
        //startPoses = new NfoStartPoses(bot);
        //begin = new NfoBeginMapInfo(bot);
    }

    /**
     * Initialization of modules used within this robot.
     *
     * @param bot Necessary parameter for hooking listeners and for sending
     * commands
     */
    @Override
    public void prepareBot(USAR2004Bot bot)
    {
        super.prepareBot(bot);
        //laserSensor = new SensorLaser(bot);
        log = new USAR2004BotLogicController();
        laserModule = new SensorSpecificModule<SensorLaser>(bot, SensorLaser.class);
        getWorldView().addEventListener(NfoMessage.class, nfoList);

        //Map<Class, Map<WorldObjectId, IViewable>> allVisible = getWorldView().getAllVisible();
    }
    //private NfoBeginMapInfo begin;
    private USAR2004BotLogicController log;
    public SensorSpecificModule<SensorLaser> laserModule;

    /**
     * this method is triggered by receipt of STA message. This is where all
     * behaviour is controlled
     *
     * @throws PogamutException
     */
    @Override
    public void logic() throws PogamutException
    {
        if(!laserModule.isReady())
        {
            return;
        }
        DriveDirection d = laserModule.getModule().getMostOpenDirection(200);
        switch(d)
        {
            case BACKWARD:
                driveBackwards();
                break;
            case FORWARD:
                driveStraight();
                break;
            case LEFT:
                driveLeft();
                break;
            case RIGHT:
                driveRight();
                break;
            default:
                break;
        }
    }
    IWorldEventListener<NfoMessage> nfoList = new IWorldEventListener<NfoMessage>()
    {
        @Override
        public void notify(NfoMessage t)
        {
            System.out.println("INFO INFO FOR STARTERS" + t.toString());
            if(!first)
            {
                //INIT {ClassName USARBot.P2DX} {Location 4.5,1.9,1.8}
                //getAct().act(new Initialize("USARBot.P2DX", "Blimp", new Location(4.5,1.9,1.8), null));

                //getAct().act(new Initialize("USARBot.AirRobot", "Item" ,new Location(0.6903,4.7984, 7.8320),null));
                first = true;
            }//new Location(-4.2861,40.1280,4.6800),null));//0.76,2.3,1.8),null));
        }
    };
    boolean first = false;
    int left = 0, right = 0;

    /**
     * Sets higher speed for right motor and lower speed for left motor.
     */
    private void driveLeft()
    {
        System.out.println("left");
        right = 10;
        left = 5;
        getAct().act(new DriveSkid(left, right, false, false, false));
    }

    /**
     * Sets higher speed for left motor and lower speed for right motor.
     */
    private void driveRight()
    {
        System.out.println("right");
        right = 5;
        left = 10;
        getAct().act(new DriveSkid(left, right, false, false, false));
    }

    /**
     * Sets equal speeds for both side motors.
     */
    private void driveStraight()
    {
        System.out.println("straight");
        right = 15;
        left = 15;
        getAct().act(new DriveSkid(left, right, false, false, false));
    }

    /**
     * For ten cycles it reverses slowly backwards and then for ten cycles it
     * turns around.
     */
    private void driveBackwards()
    {
        System.out.println("back");
        if(step > 10)
        {
            right = -3;
            left = -3;
        }
        else
        {
            right = -3;
            left = 3;
        }
        step--;
        if(step == 0)
        {
            step = 20;
            reversActive = false;
        }
        getAct().act(new DriveSkid(left, right, false, false, false));

    }
    private int step = 20;
    boolean reversActive = false;

    public static void main(String[] args)
    {
        new USAR2004BotRunner(P2DXRobot.class, "PogamutBotBot", "127.0.0.1", 3000).setMain(true).setLogLevel(Level.WARNING).startAgent();
    }
}
