package cz.cuni.amis.pogamut.ut3.factory.guice.remoteagent;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.params.IRemoteAgentParameters;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut3.factory.guice.remoteagent.UT3BotModule;

/**
 * Guice-base {@link IUT2004Bot} factory. It needs {@link UT2004BotModule} to work correctly and the module is required
 * to bound {@link IAgent} to the {@link IUT2004Bot}, otherwise the method {@link UT3BotFactory#newAgent(IRemoteAgentParameters)}
 * will throw {@link ClassCastException}.
 * <p><p>
 * For more info about the factory, see {@link GuiceAgentFactory}.
 *
 * @author Jimmy
 *
 * @param <BOT>
 * @param <PARAMS>
 */
public class UT3BotFactory<BOT extends IUT2004Bot, PARAMS extends UT2004BotParameters> extends GuiceAgentFactory<BOT, PARAMS> {

	public UT3BotFactory(UT3BotModule<PARAMS> agentModule) {
		super(agentModule);
	}
	
	@Override
	protected UT3BotModule<PARAMS> getAgentModule() {
		return (UT3BotModule<PARAMS>) super.getAgentModule();
	}
	
}
