package cz.cuni.amis.pogamut.ut3.bot.impl;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;

public class UT3AgentInfo extends AgentInfo {

	public UT3AgentInfo(UT2004Bot bot, Game game, Logger log) {
		super(bot, game, log);
		// TODO Auto-generated constructor stub
	}

	public UT3AgentInfo(UT2004Bot bot, Game game) {
		this(bot, game, null);
	}

	public ItemType getCurrentWeaponType() {
		if (getSelf() == null)
			return null;
		return UT3ItemType.getItemType(getCurrentWeaponName());
	}
        
        /**
         * Tells how much helmet armor the agent is wearing.
         * 
         * <p>Armor rating of the helmet. Maximum is 20 points of protection,
         * removing 50% of damage or completely blocking a single headshot.
         * </p>
         * 
         * @return Value of the helmet armor (0 - 20).
         */
        public Integer getHelmetArmor()
        {
                if (getSelf() == null)
                        return null;
                return getSelf().getHelmetArmor();
        }
        
        /**
         * Tells how much vest armor the agent is wearing.
         * 
         * <p>Armor rating of the vest. Maximum provides 50 points of
         * protection, removing 75% of damage.
         * </p>
         * 
         * @return Value of the vest armor (0 - 50).
         */
        public Integer getVestArmor()
        {
                if (getSelf() == null)
                        return null;
                return getSelf().getVestArmor();
        }   
        
        /**
         * Tells how much thighpad armor the agent is wearing.
         * 
         * <p>Armor rating of the thighpad. Maximum provide 30 points of 
         * protection, removing 50% of damage.
         * </p>
         * 
         * @return Value of the thighpad armor (0 - 30).
         */
        public Integer getThighpadArmor()
        {
                if (getSelf() == null)
                        return null;
                return getSelf().getThighpadArmor();
        } 
        
        /**
         * Tells how much shieldbelt armor the agent is wearing.
         * 
         * <p>Armor rating of the shieldbelt. Maximum provides 100 points of
         * protection, removing 100% of damage.
         * </p>
         * 
         * @return Value of the shieldbelt armor (0 - 100).
         */
        public Integer getShieldBeltArmor()
        {
                if (getSelf() == null)
                        return null;
                return getSelf().getShieldBeltArmor();
        }

//	/**
//	 * TODO: Refactor Pogamut, removing the hasUDamage, hasInvisibility, etc.
//	 * for the generic hasPowerUp
//	 **/
//	/**
//	 * TODO: Agent can have multiple power-ups! Very rare but must be taken care
//	 * of (In GameBots and protocol)
//	 **/
//
//	/**
//	 * Tells whether the agent has a powerup boost.
//	 * 
//	 * <p>
//	 * Type of powerups are invisibility, invulnerability, berserk and
//	 * slowfield.
//	 * </p>
//	 * 
//	 * @return true if agent has a powerup, otherwise false.
//	 */
//	public boolean hasPowerUp() {
//		return !getPowerUp().equals(NONE_WEAPON_ID);
//	}
//
	/**
	 * Tells which powerup the agent got.
	 * 
	 * <p>
	 * Type of powerups are invisibility, invulnerability, berserk and
	 * slowfield.
	 * </p>
	 * 
	 * @return name of the powerup.
	 */
	public String getPowerUp() {
		return this.getSelf().getPowerUp();
	}

	/**
	 * If the agent got a powerup, this returns the remaining time of the
	 * powerup.
	 * 
	 * <p>
	 * Type of powerups are invisibility, invulnerability, berserk and
	 * slowfield.
	 * </p>
	 * 
	 * @return Time remaining for powerup bonus boost. When this value is
	 *         positive, the agent has the powerup bonus boost currently
	 *         activated. When this value is negative, the agent does not have
	 *         the powerup activated.
	 */
	public double getPowerUpTime() {
		return this.getSelf().getPowerUpTime();
	}
}
