/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshBoundary;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshVertex;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.PolygonPathSmoothingFunnelAlgorithm;
import java.awt.geom.Point2D;
import math.geom2d.line.LineSegment2D;
import math.geom3d.Point3D;
import math.geom3d.line.LineSegment3D;

public class FunnelRay {
    protected ILocated vantagePoint;
    protected NavMeshBoundary boundary;
    protected NavMeshVertex vertex;
    protected int index;
    protected boolean isLeft;

    public static FunnelRay createLeftRay(ILocated vantagePoint, NavMeshBoundary boundary, int index, NavMeshVertex vertex) {
        return new FunnelRay(vantagePoint, boundary, index, vertex, true);
    }

    public static FunnelRay createRightRay(ILocated vantagePoint, NavMeshBoundary boundary, int index, NavMeshVertex vertex) {
        return new FunnelRay(vantagePoint, boundary, index, vertex, false);
    }

    protected FunnelRay(ILocated vantagePoint, NavMeshBoundary boundary, int index, NavMeshVertex vertex, boolean isLeft) {
        assert (boundary.getSourceVertex() == vertex || boundary.getDestinationVertex() == vertex);
        this.vantagePoint = vantagePoint;
        this.boundary = boundary;
        this.vertex = vertex;
        this.index = index;
        this.isLeft = isLeft;
    }

    public ILocated getVantagePoint() {
        return this.vantagePoint;
    }

    public Location getCrossing() {
        if (!this.getVertex().isOnWalkableAreaEdge()) {
            return this.getVertex().getLocation().addZ(NavMeshConstants.liftPolygonLocation);
        }
        if (this.boundary.asLineSegment3D().getLength() <= 2.0 * NavMeshConstants.agentRadius) {
            return Location.interpolate((Location)this.getVertex().getLocation(), (Location)this.getOppositeVertexOfBoundary().getLocation(), (double)0.5).addZ(NavMeshConstants.liftPolygonLocation);
        }
        Location vectorFromVertexToOppositeVertex = this.getOppositeVertexOfBoundary().getLocation().sub(this.getVertex().getLocation());
        return this.getVertex().getLocation().add(vectorFromVertexToOppositeVertex.getNormalized().scale(NavMeshConstants.agentRadius)).addZ(NavMeshConstants.liftPolygonLocation);
    }

    public LineSegment2D asLineSegment2D() {
        return PolygonPathSmoothingFunnelAlgorithm.xyPlaneSubsystem.project(new LineSegment3D(this.vantagePoint.getLocation().asPoint3D(), this.getCrossing().getLocation().asPoint3D()));
    }

    public boolean isOnOutsideSide(Point3D point) {
        double signedDistanceToRay = this.asLineSegment2D().getSignedDistance((Point2D)PolygonPathSmoothingFunnelAlgorithm.xyPlaneSubsystem.project(point));
        if (signedDistanceToRay < 0.0) {
            return !this.isLeft;
        }
        return this.isLeft;
    }

    public int getIndex() {
        return this.index;
    }

    protected NavMeshVertex getVertex() {
        return this.vertex;
    }

    protected NavMeshVertex getOppositeVertexOfBoundary() {
        if (this.boundary.getSourceVertex() == this.vertex) {
            return this.boundary.getDestinationVertex();
        }
        return this.boundary.getSourceVertex();
    }
}

