/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.execution;

import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class UT2004BotExecutionConfig {
    private IToken botId;
    private String pathToBotJar = null;
    private boolean redirectStdErr = true;
    private boolean redirectStdOut = true;
    private File fileToJar;
    private File execDir;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public IToken getBotId() {
        return this.botId;
    }

    public UT2004BotExecutionConfig() {
    }

    public UT2004BotExecutionConfig(IToken botId, String pathToBotJar, boolean redirectStdOut, boolean redirectStdErr) {
        this.botId = botId;
        this.setPathToBotJar(pathToBotJar);
        this.redirectStdOut = redirectStdOut;
        this.redirectStdErr = redirectStdErr;
    }

    public UT2004BotExecutionConfig setBotId(String botId) {
        NullCheck.check((Object)botId, (String)"botId");
        this.botId = Tokens.get((String)botId);
        return this;
    }

    public UT2004BotExecutionConfig setBotId(IToken botId) {
        NullCheck.check((Object)botId, (String)"botId");
        this.botId = botId;
        return this;
    }

    public File getExecDir() {
        return this.execDir;
    }

    public void setExecDir(File execDir) {
        this.execDir = execDir;
    }

    public boolean isExecDirExists() {
        return this.execDir != null && this.execDir.exists() && this.execDir.isDirectory();
    }

    public String getPathToBotJar() {
        return this.pathToBotJar;
    }

    public UT2004BotExecutionConfig setPathToBotJar(String pathToBotJar) {
        this.fileToJar = pathToBotJar != null ? new File(pathToBotJar) : null;
        this.pathToBotJar = pathToBotJar;
        return this;
    }

    public boolean isBotJarExist() {
        if (this.pathToBotJar == null) {
            return false;
        }
        File file = this.getJarFile();
        return file.exists() && file.isFile();
    }

    public File getJarFile() {
        return this.fileToJar;
    }

    public boolean isRedirectStdErr() {
        return this.redirectStdErr;
    }

    public UT2004BotExecutionConfig setRedirectStdErr(boolean redirectStdErr) {
        this.redirectStdErr = redirectStdErr;
        return this;
    }

    public boolean isRedirectStdOut() {
        return this.redirectStdOut;
    }

    public UT2004BotExecutionConfig setRedirectStdOut(boolean redirectStdOut) {
        this.redirectStdOut = redirectStdOut;
        return this;
    }

    public Object setParameter(String key, Object value) {
        return this.parameters.put(key, value.toString());
    }

    public Object removeParameter(String key) {
        Object result = this.parameters.remove(key);
        return result;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, ?> parameters) {
        this.parameters = parameters;
    }

    public String getBotName() {
        return (String)this.parameters.get(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_NAME.getKey());
    }

    public UT2004BotExecutionConfig setBotName(String name) {
        if (name == null) {
            this.removeParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_NAME.getKey());
        } else {
            this.setParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_OVERRIDE_PARAMS.getKey(), true);
            this.setParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_NAME.getKey(), name);
        }
        return this;
    }

    public Integer getBotTeam() {
        Object teamObj = this.parameters.get(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_TEAM.getKey());
        if (teamObj == null) {
            return 0;
        }
        String team = teamObj.toString();
        return Integer.parseInt(team);
    }

    public UT2004BotExecutionConfig setBotTeam(Integer team) {
        if (team == null) {
            this.removeParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_TEAM.getKey());
        } else {
            this.setParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_OVERRIDE_PARAMS.getKey(), true);
            this.setParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_TEAM.getKey(), team);
        }
        return this;
    }

    public String getBotSkin() {
        return (String)this.parameters.get(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_SKIN.getKey());
    }

    public UT2004BotExecutionConfig setBotSkin(String skin) {
        if (skin == null) {
            this.removeParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_SKIN.getKey());
        } else {
            this.setParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_OVERRIDE_PARAMS.getKey(), true);
            this.setParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_SKIN.getKey(), skin);
        }
        return this;
    }

    public Integer getBotSkill() {
        return (Integer)this.parameters.get(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_SKILL.getKey());
    }

    public UT2004BotExecutionConfig setBotSkill(Integer skill) {
        if (skill != null) {
            skill = skill < 0 ? 0 : (skill > 7 ? 7 : skill);
        }
        if (skill == null) {
            this.removeParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_SKILL.getKey());
        } else {
            this.setParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_OVERRIDE_PARAMS.getKey(), true);
            this.setParameter(PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_SKILL.getKey(), skill);
        }
        return this;
    }

    public String toString() {
        return "UT2004BotExecutionConfig[botId=" + this.botId.getToken() + ", jar=" + this.pathToBotJar + "]";
    }
}

