/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004multi.communication.worldview;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.worldview.ILocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.BatchAwareLocalWorldView;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.component.ComponentStub;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.TestCompositeViewableObject;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.TestCompositeViewableObjectMessage;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.stubs.MediatorStub;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.stubs.UT2004TestLocalWorldView;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.stubs.UT2004TestSharedWorldView;
import cz.cuni.amis.tests.BaseTest;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class Test02_UT2004VisionLocalWorldView_visibilityTest
extends BaseTest {
    private static final long GLOBAL_TIMEOUT_IN_MINUTES = 10L;
    public static FileHandler fh;
    public static Logger global;
    public static List<IAgentLogger> agentLogs;
    public static ISharedWorldView sharedWV;
    public static Random rand;
    static boolean failure;
    static CountDownLatch latch;
    static CountDownLatch latch2;

    static {
        rand = new Random(System.currentTimeMillis());
        failure = false;
    }

    public static void setLogLevel(Level level) {
        global.setLevel(level);
        for (IAgentLogger log : agentLogs) {
            log.setLevel(level);
        }
    }

    public static void initSWV() {
        try {
            fh = new FileHandler("./log01");
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SimpleFormatter f = new SimpleFormatter();
        fh.setFormatter(f);
        agentLogs = new LinkedList<IAgentLogger>();
        global = Logger.getLogger("Global");
        global.setLevel(Level.FINER);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINER);
        global.addHandler(consoleHandler);
        global.addHandler(fh);
        sharedWV = new UT2004TestSharedWorldView(global);
    }

    @Test
    public void simpleTest() {
    }

    public static void totalCountDown2() {
        while (latch2.getCount() > 0L) {
            latch2.countDown();
        }
    }

    public static void totalCountDown() {
        while (latch.getCount() > 0L) {
            latch.countDown();
        }
    }

    public static class EventGenerator
    extends Thread {
        int events;
        long time;
        ILocalWorldView localWV;
        TeamedAgentId agentId;
        VisibilityChecker checker;

        public EventGenerator(int events, long time, ILocalWorldView localWV, VisibilityChecker visChecker) {
            this.events = events;
            this.time = time;
            this.localWV = localWV;
            this.agentId = (TeamedAgentId)localWV.getAgentId();
            this.checker = visChecker;
        }

        protected void generateEvents() {
            System.out.println(this.agentId + " : generating Events [Time:" + this.time + "]");
            this.localWV.notify((IWorldChangeEvent)new BeginMessage((double)this.time, true));
            int i = 0;
            while (i < this.events) {
                if (rand.nextInt() % 100 > 30) {
                    WorldObjectId id = WorldObjectId.get((String)("TestObject[" + i + "]"));
                    TestCompositeViewableObjectMessage obj = new TestCompositeViewableObjectMessage(id, this.time, "LS:" + this.agentId.toString() + "[" + i + "]" + "(" + this.time + ")", (long)i + this.time, "ShS:" + this.agentId.getTeamId().toString() + "[" + i + "]" + "(" + this.time + ")", (long)(i + 1000) + this.time, "StaticString[" + i + "]", Long.valueOf(i), true);
                    this.checker.addVisible(id, this.time);
                    this.localWV.notify((IWorldChangeEvent)obj.createUpdateEvent(this.time, this.agentId.getTeamId()));
                }
                ++i;
            }
            this.localWV.notify((IWorldChangeEvent)new EndMessage((double)this.time, true));
            System.out.println(this.agentId + ": generating end");
        }

        @Override
        public void run() {
            try {
                this.generateEvents();
            }
            catch (Exception e) {
                e.printStackTrace();
                failure = true;
                Test02_UT2004VisionLocalWorldView_visibilityTest.totalCountDown2();
                return;
            }
            latch2.countDown();
        }
    }

    public static class EventGeneratorHandler
    extends Thread {
        Map<TeamedAgentId, ILocalWorldView> localWorldViews;
        Map<TeamedAgentId, VisibilityChecker> checkers;
        int eventsPerCycle;
        long currentTime;
        Handler handler;
        long sleepTime;

        public EventGeneratorHandler(int eventsPerCycle, long initTime, long sleepTime, Handler handlerInstance) {
            this.eventsPerCycle = eventsPerCycle;
            this.currentTime = initTime;
            this.handler = handlerInstance;
            this.sleepTime = sleepTime;
            this.localWorldViews = new HashMap<TeamedAgentId, ILocalWorldView>();
            this.checkers = new HashMap<TeamedAgentId, VisibilityChecker>();
        }

        public void addWorldView(ILocalWorldView wv, VisibilityChecker checker) {
            this.localWorldViews.put((TeamedAgentId)wv.getAgentId(), wv);
            this.checkers.put((TeamedAgentId)wv.getAgentId(), checker);
        }

        @Override
        public void run() {
            try {
                while (!this.handler.allFinished()) {
                    if (failure) {
                        throw new RuntimeException("FAILURE DETECTED!");
                    }
                    LinkedList<EventGenerator> thrds = new LinkedList<EventGenerator>();
                    for (TeamedAgentId teamedAgentId : this.localWorldViews.keySet()) {
                        if (this.handler.cyclesToRun((IAgentId)teamedAgentId) < 0) continue;
                        thrds.add(new EventGenerator(this.eventsPerCycle, this.currentTime, this.localWorldViews.get(teamedAgentId), this.checkers.get(teamedAgentId)));
                    }
                    latch2 = new CountDownLatch(thrds.size());
                    for (Thread thread : thrds) {
                        thread.start();
                    }
                    latch2.await(10L, TimeUnit.MINUTES);
                    if (latch2.getCount() > 0L || failure) {
                        throw new RuntimeException("FAILURE DETECTED!");
                    }
                    ++this.currentTime;
                    EventGeneratorHandler.sleep(this.sleepTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                failure = true;
                Test02_UT2004VisionLocalWorldView_visibilityTest.totalCountDown();
                return;
            }
            latch.countDown();
        }
    }

    public static class Handler {
        Map<IAgentId, Integer> cycles = new HashMap<IAgentId, Integer>();

        public void addNew(IAgentId id, int cycles) {
            this.cycles.put(id, cycles);
        }

        public boolean allFinished() {
            for (Integer i : this.cycles.values()) {
                if (i < 0) continue;
                return false;
            }
            return true;
        }

        public synchronized void setEnd(IAgentId id) {
            this.cycles.put(id, -1);
        }

        public synchronized void decrease(IAgentId id) {
            int n = this.cycles.get(id);
            this.cycles.put(id, --n);
        }

        public int cyclesToRun(IAgentId id) {
            return this.cycles.get(id);
        }
    }

    public static class LogicRunner
    extends Thread {
        protected BatchAwareLocalWorldView wv;
        protected ITeamedAgentId id;
        int runs;
        int objects;
        long sleepTime;
        Handler handler;
        ComponentStub starter;
        VisibilityChecker checker;

        public LogicRunner(ITeamedAgentId id, int runs, int objects, long sleepTime, Handler handler, VisibilityChecker visChecker) {
            AgentLogger log = new AgentLogger((IAgentId)id);
            agentLogs.add((IAgentLogger)log);
            log.setLevel(Level.ALL);
            log.addDefaultConsoleHandler();
            log.addDefaultHandler((java.util.logging.Handler)fh);
            LifecycleBus bus = new LifecycleBus((IAgentLogger)log);
            this.starter = new ComponentStub((IAgentLogger)log, (IComponentBus)bus);
            MediatorStub m = new MediatorStub((IAgentLogger)log);
            try {
                this.wv = new UT2004TestLocalWorldView(new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)this.starter), m, (ILifecycleBus)bus, (IAgentLogger)log, sharedWV, id);
            }
            catch (Exception e) {
                failure = true;
                e.printStackTrace();
            }
            this.id = id;
            this.runs = runs;
            this.objects = objects;
            this.sleepTime = sleepTime;
            this.handler = handler;
            this.checker = visChecker;
            handler.addNew((IAgentId)id, runs);
        }

        public void startWV() {
            this.starter.getController().manualStart("Test");
        }

        public void setSleepTime(long newSleepTime) {
            this.sleepTime = newSleepTime;
        }

        @Override
        public void run() {
            try {
                System.out.println(this.id + " : Logic Runner run()");
                int r = 0;
                while (r <= this.runs) {
                    if (failure) {
                        throw new RuntimeException("FAILURE DETECTED!");
                    }
                    this.wv.lock();
                    System.out.println(this.id + "Runner run [" + r + "] remaining : time " + this.wv.getCurrentTimeKey().getTime() + ", remaining runs " + this.handler.cyclesToRun((IAgentId)this.id));
                    Set<WorldObjectId> shouldBeVisible = this.checker.getAllVisible(this.wv.getCurrentTimeKey().getTime());
                    Set areVisible = this.wv.getAllVisible(TestCompositeViewableObject.class).keySet();
                    if (areVisible.containsAll(shouldBeVisible) && areVisible.size() == shouldBeVisible.size()) {
                        System.out.println("VisibilityCheck OK ; visible : " + areVisible.size());
                    } else {
                        System.err.println(" ShouldBeVisible : " + shouldBeVisible.size() + " ; Visible : " + areVisible.size());
                        System.out.println("Should BE VISIBLE :");
                        for (WorldObjectId id : shouldBeVisible) {
                            System.out.println(id);
                        }
                        System.out.println("VISIBLE :");
                        for (WorldObjectId id : areVisible) {
                            System.out.println(id);
                        }
                        failure = true;
                        Assert.fail((String)"VisibilityFail");
                    }
                    LogicRunner.sleep(this.sleepTime);
                    this.wv.unlock();
                    this.handler.decrease((IAgentId)this.id);
                    ++r;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                failure = true;
                Test02_UT2004VisionLocalWorldView_visibilityTest.totalCountDown();
                return;
            }
            latch.countDown();
        }
    }

    public static class VisibilityChecker {
        TeamedAgentId agentId;
        Map<TimeKey, Set<WorldObjectId>> visibleObjects = new WeakHashMap<TimeKey, Set<WorldObjectId>>();

        public VisibilityChecker(TeamedAgentId agentId) {
            this.agentId = agentId;
        }

        public Set<WorldObjectId> getAllVisible(long time) {
            return this.visibleObjects.get(TimeKey.get((long)time));
        }

        public void addVisible(WorldObjectId id, long time) {
            Set<WorldObjectId> set = this.visibleObjects.get(TimeKey.get((long)time));
            if (set == null) {
                set = new HashSet<WorldObjectId>();
                this.visibleObjects.put(TimeKey.get((long)time), set);
            }
            set.add(id);
        }
    }
}

