/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.exception.CommunicationException;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemTypeTranslator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemCategory;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.AdrenalineDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.AdrenalineDescriptorFactory;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.AmmoDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.AmmoDescriptorFactory;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ArmorDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ArmorDescriptorFactory;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.GeneralDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.HealthDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.HealthDescriptorFactory;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.IDescriptorFactory;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemTyped;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.OtherDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.OtherDescriptorFactory;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ShieldDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ShieldDescriptorFactory;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptorFactory;
import java.util.HashMap;

@AgentScoped
public class ItemTranslator {
    private HashMap<ItemType, ItemDescriptor> descriptors = new HashMap();
    private HashMap<ItemType, GeneralDescriptor> userDescriptors = new HashMap();
    private final IDescriptorFactory<WeaponDescriptor> weaponDescriptorFactory;
    private final IDescriptorFactory<AdrenalineDescriptor> adrenalineDescriptorFactory = new AdrenalineDescriptorFactory();
    private final IDescriptorFactory<ShieldDescriptor> shieldDescriptorFactory = new ShieldDescriptorFactory();
    private final IDescriptorFactory<HealthDescriptor> healthDescriptorFactory = new HealthDescriptorFactory();
    private final IDescriptorFactory<OtherDescriptor> otherDescriptorFactory = new OtherDescriptorFactory();
    private final IDescriptorFactory<ArmorDescriptor> armorDescriptorFactory = new ArmorDescriptorFactory();
    private final IDescriptorFactory<AmmoDescriptor> ammoDescriptorFactory = new AmmoDescriptorFactory();
    private final ItemTypeTranslator itemTypeTranslator;

    @Inject
    public ItemTranslator(ItemTypeTranslator translator) {
        this.itemTypeTranslator = translator;
        this.weaponDescriptorFactory = new WeaponDescriptorFactory(this.itemTypeTranslator);
    }

    public ItemType[] getItemTypes() {
        return this.descriptors.values().toArray(new ItemType[0]);
    }

    public ItemDescriptor getDescriptor(ItemTyped msg) {
        return this.getDescriptor(msg.getType());
    }

    public ItemDescriptor getDescriptor(ItemType type) {
        if (this.userDescriptors.containsKey(type)) {
            return this.userDescriptors.get(type);
        }
        return this.descriptors.get(type);
    }

    public ItemDescriptor getDefaultDescriptor(ItemType type) {
        return this.descriptors.get(type);
    }

    public void addCustomUserDescriptor(GeneralDescriptor userDescriptor) {
        this.userDescriptors.put(userDescriptor.getPickupType(), userDescriptor);
    }

    public ItemDescriptor createDescriptor(ItemCategory message) {
        ItemDescriptor result = null;
        switch (message.getType().getCategory()) {
            case AMMO: {
                result = this.ammoDescriptorFactory.getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            case ARMOR: {
                result = this.armorDescriptorFactory.getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            case OTHER: {
                result = this.otherDescriptorFactory.getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            case HEALTH: {
                result = this.healthDescriptorFactory.getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            case SHIELD: {
                result = this.shieldDescriptorFactory.getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            case ADRENALINE: {
                result = this.adrenalineDescriptorFactory.getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            case WEAPON: {
                result = this.weaponDescriptorFactory.getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            default: {
                throw new CommunicationException("should not reach here - new ItemType.Category has been added and not handled inside the ItemTranslator, item type = " + message.getType(), (Object)this);
            }
        }
        return result;
    }
}

