/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.impl;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UT2004BotName {
    private UT2004Bot bot;
    private String base;
    private Map<String, String> infos = new HashMap<String, String>();
    private String nullKeyValue = null;

    public UT2004BotName(UT2004Bot bot, String base) {
        this.bot = bot;
        this.base = base;
    }

    public void setNameBase(String base) {
        this.base = base;
        this.updateName();
    }

    public void setTag(String tag) {
        this.setInfo(null, tag);
    }

    public void deleteTag(String tag) {
        this.deleteInfo(tag);
    }

    public void setInfo(String value) {
        this.setInfo(null, value);
    }

    public void setInfo(String key, String value) {
        if (key == null) {
            this.nullKeyValue = value;
        } else {
            this.infos.put(key, value);
        }
        this.updateName();
    }

    public void deleteInfo(String key) {
        if (key == null) {
            if (this.nullKeyValue == null) {
                return;
            }
            this.nullKeyValue = null;
            this.updateName();
        } else if (this.infos.remove(key) != null) {
            this.updateName();
        }
    }

    public void updateName() {
        ArrayList<String> keys = new ArrayList<String>(this.infos.keySet());
        Collections.sort(keys);
        StringBuffer name = new StringBuffer();
        name.append(this.base);
        if (this.nullKeyValue != null) {
            name.append(" [");
            name.append(this.nullKeyValue);
            name.append("]");
        }
        for (String key : keys) {
            String value = this.infos.get(key);
            name.append(" [");
            name.append(key);
            if (value != null) {
                name.append(": ");
                name.append(value);
            }
            name.append("]");
        }
        this.bot.getAct().act((CommandMessage)new Configuration().setName(name.toString()));
    }
}

