/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.analyzer;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerFullObserverParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ConfigurationObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.InitializeObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AddInventoryMsg;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AdrenalineGained;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Bumped;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ChangedWeapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ComboStarted;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FallEdge;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameRestarted;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GlobalChat;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.HearNoise;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.HearPickup;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.JumpPerformed;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Landed;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.LostChild;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.RecordingEnded;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.RecordingStarted;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ShootingStarted;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ShootingStopped;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Spawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Thrown;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WallCollision;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WeaponUpdate;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.observer.impl.UT2004Observer;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.File;
import java.io.PrintWriter;

public class UT2004AnalyzerFullObserver
extends UT2004Observer
implements IUT2004AnalyzerObserver {
    private UnrealId observedBotId;
    private IWorldEventListener<GameRestarted> gameRestartedListener = new IWorldEventListener<GameRestarted>(){

        public void notify(GameRestarted event) {
            if (event.isStarted()) {
                UT2004AnalyzerFullObserver.this.gameRestartStarted();
            } else if (event.isFinished()) {
                UT2004AnalyzerFullObserver.this.gameRestartEnd();
            } else {
                throw new PogamutException("GameRestarted has started==false && finished==false as well, invalid!", (Object)this);
            }
        }
    };
    private Player humanLike_enemy = null;
    private String humanLike_playerName;
    private PrintWriter humanLike_writer;
    public static final String humanLike_DELIMITER = "$";
    IWorldEventListener<AddInventoryMsg> humanLike_addInventoryMsgListener = new IWorldEventListener<AddInventoryMsg>(){

        public void notify(AddInventoryMsg event) {
            UT2004AnalyzerFullObserver.this.processAddInventoryMsgEvent(event);
        }
    };
    IWorldEventListener<AdrenalineGained> humanLike_adrenalineGainedListener = new IWorldEventListener<AdrenalineGained>(){

        public void notify(AdrenalineGained event) {
            UT2004AnalyzerFullObserver.this.processAdrenalineGainedEvent(event);
        }
    };
    IWorldEventListener<Bumped> humanLike_bumpedListener = new IWorldEventListener<Bumped>(){

        public void notify(Bumped event) {
            UT2004AnalyzerFullObserver.this.processBumpedEvent(event);
        }
    };
    IWorldEventListener<ChangedWeapon> humanLike_changedWeaponListener = new IWorldEventListener<ChangedWeapon>(){

        public void notify(ChangedWeapon event) {
            UT2004AnalyzerFullObserver.this.processChangedWeaponEvent(event);
        }
    };
    IWorldEventListener<ComboStarted> humanLike_comboStartedListener = new IWorldEventListener<ComboStarted>(){

        public void notify(ComboStarted event) {
            UT2004AnalyzerFullObserver.this.processComboStartedEvent(event);
        }
    };
    IWorldEventListener<FallEdge> humanLike_fallEdgeListener = new IWorldEventListener<FallEdge>(){

        public void notify(FallEdge event) {
            UT2004AnalyzerFullObserver.this.processFallEdgeEvent(event);
        }
    };
    IWorldEventListener<GameInfo> humanLike_gameInfoListener = new IWorldEventListener<GameInfo>(){

        public void notify(GameInfo event) {
            UT2004AnalyzerFullObserver.this.processGameInfoEvent(event);
        }
    };
    IWorldEventListener<GlobalChat> humanLike_globalChatListener = new IWorldEventListener<GlobalChat>(){

        public void notify(GlobalChat event) {
            UT2004AnalyzerFullObserver.this.processGlobalChatEvent(event);
        }
    };
    IWorldEventListener<HearNoise> humanLike_hearNoiseListener = new IWorldEventListener<HearNoise>(){

        public void notify(HearNoise event) {
            UT2004AnalyzerFullObserver.this.processHearNoiseEvent(event);
        }
    };
    IWorldEventListener<HearPickup> humanLike_hearPickupListener = new IWorldEventListener<HearPickup>(){

        public void notify(HearPickup event) {
            UT2004AnalyzerFullObserver.this.processHearPickupEvent(event);
        }
    };
    IWorldEventListener<IncomingProjectile> humanLike_incomingProjectileListener = new IWorldEventListener<IncomingProjectile>(){

        public void notify(IncomingProjectile event) {
            UT2004AnalyzerFullObserver.this.processIncomingProjectileEvent(event);
        }
    };
    IWorldEventListener<ItemPickedUp> humanLike_itemPickedUpListener = new IWorldEventListener<ItemPickedUp>(){

        public void notify(ItemPickedUp event) {
            UT2004AnalyzerFullObserver.this.processItemPickedUpEvent(event);
        }
    };
    IWorldEventListener<JumpPerformed> humanLike_jumpPerformedListener = new IWorldEventListener<JumpPerformed>(){

        public void notify(JumpPerformed event) {
            UT2004AnalyzerFullObserver.this.processJumpPerformedEvent(event);
        }
    };
    IWorldEventListener<Landed> humanLike_landedListener = new IWorldEventListener<Landed>(){

        public void notify(Landed event) {
            UT2004AnalyzerFullObserver.this.processLandedEvent(event);
        }
    };
    IWorldEventListener<LostChild> humanLike_lostChildListener = new IWorldEventListener<LostChild>(){

        public void notify(LostChild event) {
            UT2004AnalyzerFullObserver.this.processLostChildEvent(event);
        }
    };
    IWorldEventListener<PlayerDamaged> humanLike_playerDamagedListener = new IWorldEventListener<PlayerDamaged>(){

        public void notify(PlayerDamaged event) {
            UT2004AnalyzerFullObserver.this.processPlayerDamagedEvent(event);
        }
    };
    IWorldEventListener<PlayerJoinsGame> humanLike_playerJoinsGameListener = new IWorldEventListener<PlayerJoinsGame>(){

        public void notify(PlayerJoinsGame event) {
            UT2004AnalyzerFullObserver.this.processPlayerJoinsGameEvent(event);
        }
    };
    IWorldEventListener<PlayerKilled> humanLike_playerKilledListener = new IWorldEventListener<PlayerKilled>(){

        public void notify(PlayerKilled event) {
            UT2004AnalyzerFullObserver.this.processPlayerKilledEvent(event);
        }
    };
    IWorldEventListener<PlayerLeft> humanLike_playerLeftListener = new IWorldEventListener<PlayerLeft>(){

        public void notify(PlayerLeft event) {
            UT2004AnalyzerFullObserver.this.processPlayerLeftEvent(event);
        }
    };
    IWorldEventListener<PlayerScore> humanLike_playerScoreListener = new IWorldEventListener<PlayerScore>(){

        public void notify(PlayerScore event) {
            UT2004AnalyzerFullObserver.this.processPlayerScoreEvent(event);
        }
    };
    IWorldEventListener<RecordingEnded> humanLike_recordingEndedListener = new IWorldEventListener<RecordingEnded>(){

        public void notify(RecordingEnded event) {
            UT2004AnalyzerFullObserver.this.processRecordingEndedEvent(event);
        }
    };
    IWorldEventListener<RecordingStarted> humanLike_recordingStartedListener = new IWorldEventListener<RecordingStarted>(){

        public void notify(RecordingStarted event) {
            UT2004AnalyzerFullObserver.this.processRecordingStartedEvent(event);
        }
    };
    IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> humanLike_selfListener = new IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>>(){

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            UT2004AnalyzerFullObserver.this.processSelfEvent((WorldObjectUpdatedEvent<Self>)event);
        }
    };
    IWorldEventListener<ShootingStarted> humanLike_shootingStartedListener = new IWorldEventListener<ShootingStarted>(){

        public void notify(ShootingStarted event) {
            UT2004AnalyzerFullObserver.this.processShootingStartedEvent(event);
        }
    };
    IWorldEventListener<ShootingStopped> humanLike_shootingStoppedListener = new IWorldEventListener<ShootingStopped>(){

        public void notify(ShootingStopped event) {
            UT2004AnalyzerFullObserver.this.processShootingStoppedEvent(event);
        }
    };
    IWorldEventListener<Spawn> humanLike_spawnListener = new IWorldEventListener<Spawn>(){

        public void notify(Spawn event) {
            UT2004AnalyzerFullObserver.this.processSpawnEvent(event);
        }
    };
    IWorldEventListener<Thrown> humanLike_thrownListener = new IWorldEventListener<Thrown>(){

        public void notify(Thrown event) {
            UT2004AnalyzerFullObserver.this.processThrownEvent(event);
        }
    };
    IWorldEventListener<WallCollision> humanLike_wallCollisionListener = new IWorldEventListener<WallCollision>(){

        public void notify(WallCollision event) {
            UT2004AnalyzerFullObserver.this.processWallCollisionEvent(event);
        }
    };
    IWorldEventListener<WeaponUpdate> humanLike_weaponUpdateListener = new IWorldEventListener<WeaponUpdate>(){

        public void notify(WeaponUpdate event) {
            UT2004AnalyzerFullObserver.this.processWeaponUpdateEvent(event);
        }
    };

    @Inject
    public UT2004AnalyzerFullObserver(UT2004AnalyzerFullObserverParameters params, IComponentBus bus, IAgentLogger agentLogger, UT2004WorldView worldView, IAct act) {
        super(params, bus, agentLogger, worldView, act);
        this.observedBotId = UnrealId.get((String)params.getObservedAgentId());
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(GameRestarted.class, this.gameRestartedListener);
        if (params.isHumanLikeObservingEnabled().booleanValue()) {
            this.initializeHumanLikeObserving(params.getHumanLikeBotName(), params.getHumanLikeWriter());
        }
    }

    @Override
    public UT2004AnalyzerFullObserverParameters getParams() {
        return (UT2004AnalyzerFullObserverParameters)super.getParams();
    }

    @Override
    public UnrealId getObservedBotId() {
        return this.observedBotId;
    }

    public String getOutputFilePath() {
        String path = this.getParams().getOutputPath();
        if (path == null) {
            path = ".";
        }
        path = path + File.separator;
        if (this.getParams().getFileName() != null) {
            path = path + this.getParams().getFileName();
        } else {
            path = path + this.getObservedBotId().getStringId();
            path = path + ".csv";
        }
        return path;
    }

    protected void gameRestartStarted() {
    }

    protected void gameRestartEnd() {
    }

    @Override
    protected void startAgent() {
        super.startAgent();
        this.getAct().act((CommandMessage)new InitializeObserver().setId(this.getParams().getObservedAgentId()));
        this.configureObserver();
    }

    @Override
    protected void startPausedAgent() {
        super.startPausedAgent();
        this.getAct().act((CommandMessage)new InitializeObserver().setId(this.getParams().getObservedAgentId()));
        this.configureObserver();
    }

    protected void configureObserver() {
        if (this.getParams().isHumanLikeObservingEnabled().booleanValue()) {
            this.getAct().act((CommandMessage)new ConfigurationObserver().setUpdate(0.2).setAll(true).setSelf(true).setAsync(true).setGame(true).setSee(false).setSpecial(false));
        } else {
            this.getAct().act((CommandMessage)new ConfigurationObserver().setUpdate(0.2).setAll(true).setSelf(true).setAsync(true).setGame(false).setSee(false).setSpecial(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String name, Long time, String type, String message) {
        String output = name + humanLike_DELIMITER + time.toString() + humanLike_DELIMITER + type + humanLike_DELIMITER + message + "\n";
        PrintWriter printWriter = this.humanLike_writer;
        synchronized (printWriter) {
            this.humanLike_writer.print(output);
        }
    }

    private void processAddInventoryMsgEvent(AddInventoryMsg event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "AddInventoryMsg", event.toString());
    }

    private void processAdrenalineGainedEvent(AdrenalineGained event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "AdrenalineGained", event.toString());
    }

    private void processBumpedEvent(Bumped event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "Bumped", event.toString());
    }

    private void processChangedWeaponEvent(ChangedWeapon event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "ChangedWeapon", event.toString());
    }

    private void processComboStartedEvent(ComboStarted event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "ComboStarted", event.toString());
    }

    private void processFallEdgeEvent(FallEdge event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "FallEdge", event.toString());
    }

    private void processGameInfoEvent(GameInfo event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "GameInfo", event.toString());
    }

    private void processGlobalChatEvent(GlobalChat event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "GlobalChat", event.toString());
    }

    private void processHearNoiseEvent(HearNoise event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "HearNoise", event.toString());
    }

    private void processHearPickupEvent(HearPickup event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "HearPickup", event.toString());
    }

    private void processIncomingProjectileEvent(IncomingProjectile event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "IncomingProjectile", event.toString());
    }

    private void processItemPickedUpEvent(ItemPickedUp event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "ItemPickedUp", event.toString());
    }

    private void processJumpPerformedEvent(JumpPerformed event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "JumpPerformed", event.toString());
    }

    private void processLandedEvent(Landed event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "Landed", event.toString());
    }

    private void processLostChildEvent(LostChild event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "LostChild", event.toString());
    }

    private void processPlayerDamagedEvent(PlayerDamaged event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "PlayerDamaged", event.toString());
    }

    private void processPlayerJoinsGameEvent(PlayerJoinsGame event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "PlayerJoinsGame", event.toString());
    }

    private void processPlayerKilledEvent(PlayerKilled event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "PlayerKilled", event.toString());
    }

    private void processPlayerLeftEvent(PlayerLeft event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "PlayerLeft", event.toString());
    }

    private void processPlayerScoreEvent(PlayerScore event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "PlayerScore", event.toString());
    }

    private void processRecordingEndedEvent(RecordingEnded event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "RecordingEnded", event.toString());
    }

    private void processRecordingStartedEvent(RecordingStarted event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "RecordingStarted", event.toString());
    }

    private void processSelfEvent(WorldObjectUpdatedEvent<Self> event) {
        this.save(this.humanLike_playerName, ((Self)event.getObject()).getSimTime(), "Self", ((Self)event.getObject()).toString());
        this.processEnemyEvent(event);
    }

    private void processShootingStartedEvent(ShootingStarted event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "ShootingStarted", event.toString());
    }

    private void processShootingStoppedEvent(ShootingStopped event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "ShootingStopped", event.toString());
    }

    private void processSpawnEvent(Spawn event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "Spawn", event.toString());
    }

    private void processThrownEvent(Thrown event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "Thrown", event.toString());
    }

    private void processWallCollisionEvent(WallCollision event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "WallCollision", event.toString());
    }

    private void processWeaponUpdateEvent(WeaponUpdate event) {
        this.save(this.humanLike_playerName, event.getSimTime(), "WeaponUpdate", event.toString());
    }

    private void processEnemyEvent(WorldObjectUpdatedEvent<Self> event) {
        this.locateEnemy(event);
        if (this.humanLike_enemy != null) {
            this.save(this.humanLike_playerName, ((Self)event.getObject()).getSimTime(), "Enemy", this.humanLike_enemy.toString());
        }
    }

    private void locateEnemy(WorldObjectUpdatedEvent<Self> event) {
        this.humanLike_enemy = (Player)DistanceUtils.getNearestVisible(((UT2004WorldView)((Object)this.getWorldView())).getAllVisible(Player.class).values(), (ILocated)((Self)event.getObject()).getLocation());
        if (this.humanLike_enemy != null && this.humanLike_enemy.getName().toString().equals(this.humanLike_playerName)) {
            this.humanLike_enemy = null;
        }
    }

    protected void initializeHumanLikeObserving(String observedPlayer, PrintWriter printWriter) {
        this.humanLike_writer = printWriter;
        if (this.humanLike_writer == null) {
            throw new RuntimeException("humanLike_writer is null! Invalid observer parameters passed...");
        }
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(AddInventoryMsg.class, this.humanLike_addInventoryMsgListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(AdrenalineGained.class, this.humanLike_adrenalineGainedListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(Bumped.class, this.humanLike_bumpedListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(ChangedWeapon.class, this.humanLike_changedWeaponListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(ComboStarted.class, this.humanLike_comboStartedListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(FallEdge.class, this.humanLike_fallEdgeListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(GameInfo.class, this.humanLike_gameInfoListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(GlobalChat.class, this.humanLike_globalChatListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(HearNoise.class, this.humanLike_hearNoiseListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(HearPickup.class, this.humanLike_hearPickupListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(IncomingProjectile.class, this.humanLike_incomingProjectileListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(ItemPickedUp.class, this.humanLike_itemPickedUpListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(JumpPerformed.class, this.humanLike_jumpPerformedListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(Landed.class, this.humanLike_landedListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(LostChild.class, this.humanLike_lostChildListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(PlayerDamaged.class, this.humanLike_playerDamagedListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(PlayerJoinsGame.class, this.humanLike_playerJoinsGameListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(PlayerKilled.class, this.humanLike_playerKilledListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(PlayerLeft.class, this.humanLike_playerLeftListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(PlayerScore.class, this.humanLike_playerScoreListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(RecordingEnded.class, this.humanLike_recordingEndedListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(RecordingStarted.class, this.humanLike_recordingStartedListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this.humanLike_selfListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(ShootingStarted.class, this.humanLike_shootingStartedListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(ShootingStopped.class, this.humanLike_shootingStoppedListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(Spawn.class, this.humanLike_spawnListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(Thrown.class, this.humanLike_thrownListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(WallCollision.class, this.humanLike_wallCollisionListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(WeaponUpdate.class, this.humanLike_weaponUpdateListener);
        this.humanLike_playerName = observedPlayer;
    }
}

