/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.ILocalGBViewable;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.TestCompositeViewableObject;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.TestLocalViewableObjectImpl;
import cz.cuni.amis.utils.exception.PogamutException;

public abstract class TestLocalViewableObject
implements ILocalWorldObject,
ILocalGBViewable {
    protected WorldObjectId id;
    protected long simTime;

    public abstract String getLocalString();

    public abstract long getLocalLong();

    protected TestLocalViewableObject(WorldObjectId id, long simTime) {
        this.id = id;
        this.simTime = simTime;
    }

    public abstract TestLocalViewableObject clone();

    public WorldObjectId getId() {
        return this.id;
    }

    public long getSimTime() {
        return this.simTime;
    }

    public Class getCompositeClass() {
        return TestCompositeViewableObject.class;
    }

    public String toString() {
        return "TestLocalObject[" + this.id + "] : long=" + this.getLocalLong() + " ; string=" + this.getLocalString() + " ;";
    }

    public TestLocalViewableObjectUpdatedEvent createUpdateEvent(long simTime) {
        return new TestLocalViewableObjectUpdatedEvent(this, simTime);
    }

    public static class TestLocalViewableObjectUpdatedEvent
    implements ILocalWorldObjectUpdatedEvent,
    IWorldObjectEvent<IWorldObject> {
        private TestLocalViewableObject data;
        private long simTime;

        public TestLocalViewableObjectUpdatedEvent(TestLocalViewableObject data, long simTime) {
            this.data = data;
            this.simTime = simTime;
        }

        public long getSimTime() {
            return this.simTime;
        }

        public WorldObjectId getId() {
            return this.data.getId();
        }

        public IWorldObjectUpdateResult<ILocalWorldObject> update(ILocalWorldObject object) {
            if (object == null) {
                TestLocalViewableObjectImpl ret = new TestLocalViewableObjectImpl(this.data);
                this.data = ret;
                return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.CREATED, (IWorldObject)this.data);
            }
            if (!(object instanceof TestLocalViewableObjectImpl)) {
                throw new PogamutException("Wrong object class provided for update, expected TestLocalObjectImpl", (Object)this);
            }
            TestLocalViewableObjectImpl toUpdate = (TestLocalViewableObjectImpl)object;
            boolean updated = false;
            if (toUpdate.longVal.longValue() != this.data.getLocalLong()) {
                toUpdate.longVal = this.data.getLocalLong();
                updated = true;
            }
            if (!toUpdate.stringVal.equals(this.data.getLocalString())) {
                toUpdate.stringVal = this.data.getLocalString();
                updated = true;
            }
            if (toUpdate.visible != this.data.isVisible()) {
                toUpdate.visible = this.data.isVisible();
                updated = true;
            }
            toUpdate.simTime = this.simTime;
            if (updated) {
                return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.UPDATED, (IWorldObject)toUpdate);
            }
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.SAME, (IWorldObject)toUpdate);
        }

        public IWorldObject getObject() {
            return this.data;
        }
    }
}

