/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;

public class NavigationGraphBuilder
extends SensorModule<UT2004Bot> {
    GameInfoListener gameInfoListener;
    GameInfo lastGameInfo = null;
    String mapNameLowerChar = null;
    private boolean autoPrefix = true;
    private boolean used;

    public NavigationGraphBuilder(UT2004Bot bot) {
        this(bot, null);
    }

    public NavigationGraphBuilder(UT2004Bot bot, Logger log) {
        this(bot, log, null);
    }

    public NavigationGraphBuilder(UT2004Bot bot, Logger log, ComponentDependencies dependencies) {
        super((IObservingAgent)bot, log, dependencies);
        this.gameInfoListener = new GameInfoListener((IWorldView)bot.getWorldView());
    }

    protected void cleanUp() {
        super.cleanUp();
        this.lastGameInfo = null;
        this.mapNameLowerChar = null;
    }

    public String getMapName() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getLevel();
    }

    public boolean isMapName(String name) {
        if (this.lastGameInfo == null) {
            return false;
        }
        if (name == null) {
            return false;
        }
        return this.lastGameInfo.getLevel().toLowerCase().equals(name.toLowerCase());
    }

    public boolean isAutoPrefix() {
        return this.autoPrefix;
    }

    public void setAutoPrefix(boolean autoPrefix) {
        this.autoPrefix = autoPrefix;
    }

    public String getPrefixed(String navPointId) {
        if (this.getMapName() == null) {
            throw new PogamutException("GameInfo was not received yet, can't auto-prefix name of the navpoint '" + navPointId + "'.", (Object)this);
        }
        if (navPointId.toLowerCase().startsWith(this.mapNameLowerChar + ".")) {
            if (!navPointId.startsWith(this.getMapName())) {
                navPointId = this.getMapName() + navPointId.substring(this.mapNameLowerChar.length());
            }
            return navPointId;
        }
        if (navPointId.contains(".")) {
            throw new PogamutException("navPointId '" + navPointId + "' is already prefixed with '" + navPointId.substring(0, navPointId.indexOf(".")) + "' which is different from current map name '" + this.getMapName() + "', map name validation fails!", (Object)this);
        }
        return this.getMapName() + "." + navPointId;
    }

    public String autoPrefix(String navPointId) {
        NullCheck.check((Object)navPointId, (String)"navPointId");
        if (this.autoPrefix) {
            return this.getPrefixed(navPointId);
        }
        return navPointId;
    }

    public NewNavPointBuilder newNavPoint() {
        this.used = true;
        return new NewNavPointBuilder();
    }

    public NewNavPointBuilder newNavPoint(String navPointId) {
        this.used = true;
        NullCheck.check((Object)navPointId, (String)"navPointId");
        return new NewNavPointBuilder().setId(navPointId);
    }

    public ExistingNavPointModifier modifyNavPoint(String navPointId) {
        this.used = true;
        NullCheck.check((Object)navPointId, (String)"navPointId");
        navPointId = this.autoPrefix(navPointId);
        IWorldObject np = ((UT2004Bot)this.agent).getWorldView().get((WorldObjectId)UnrealId.get((String)navPointId));
        if (np == null) {
            throw new PogamutException("Could not modify navpoint '" + navPointId + "' as it was not found in the worldview. No object under this id exists in worldview. Warning, id is case-sensitive the upper/lower cases of the id depends on the concrete spelling of the map that was passed to the GB2004 during startup (either from the command line or by the UT2004).", (Object)this);
        }
        if (!(np instanceof NavPoint)) {
            throw new PogamutException("Could not modify navpoint '" + navPointId + "' it does not point to an NavPoint instance but " + np.getClass().getSimpleName() + ". Wrong id specified?", (Object)this);
        }
        return new ExistingNavPointModifier((NavPoint)np);
    }

    public void createSimpleEdge(String fromNavPointId, String toNavPointId) {
        this.used = true;
        NullCheck.check((Object)fromNavPointId, (String)"fromNavPointId");
        NullCheck.check((Object)toNavPointId, (String)"toNavPointId");
        fromNavPointId = this.autoPrefix(fromNavPointId);
        toNavPointId = this.autoPrefix(toNavPointId);
        this.modifyNavPoint(fromNavPointId).modifyEdgeTo(toNavPointId).createEdge();
    }

    public void createSimpleEdgesBetween(String firstNavPointId, String secondNavPointId) {
        this.used = true;
        NullCheck.check((Object)firstNavPointId, (String)"firstNavPointId");
        NullCheck.check((Object)secondNavPointId, (String)"secondNavPointId");
        firstNavPointId = this.autoPrefix(firstNavPointId);
        secondNavPointId = this.autoPrefix(secondNavPointId);
        this.modifyNavPoint(firstNavPointId).modifyEdgeTo(secondNavPointId).createEdge();
        this.modifyNavPoint(secondNavPointId).modifyEdgeTo(firstNavPointId).createEdge();
    }

    public void removeEdge(String fromNavPointId, String toNavPointId) {
        this.used = true;
        NullCheck.check((Object)fromNavPointId, (String)"fromNavPointId");
        NullCheck.check((Object)toNavPointId, (String)"toNavPointId");
        fromNavPointId = this.autoPrefix(fromNavPointId);
        toNavPointId = this.autoPrefix(toNavPointId);
        this.modifyNavPoint(fromNavPointId).removeEdgeTo(toNavPointId);
    }

    public void removeEdgesBetween(String firstNavPointId, String secondNavPointId) {
        this.used = true;
        NullCheck.check((Object)firstNavPointId, (String)"firstNavPointId");
        NullCheck.check((Object)secondNavPointId, (String)"secondNavPointId");
        firstNavPointId = this.autoPrefix(firstNavPointId);
        secondNavPointId = this.autoPrefix(secondNavPointId);
        this.modifyNavPoint(firstNavPointId).removeEdgeTo(secondNavPointId);
        this.modifyNavPoint(secondNavPointId).removeEdgeTo(firstNavPointId);
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    private class GameInfoListener
    implements IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>> {
        public void notify(IWorldObjectEvent<GameInfo> event) {
            NavigationGraphBuilder.this.lastGameInfo = (GameInfo)event.getObject();
            if (NavigationGraphBuilder.this.lastGameInfo.getLevel() == null) {
                throw new PogamutException("GameInfo.getLevel() is null!!!", (Object)this);
            }
            NavigationGraphBuilder.this.mapNameLowerChar = NavigationGraphBuilder.this.lastGameInfo.getLevel().toLowerCase();
        }

        public GameInfoListener(IWorldView worldView) {
            worldView.addObjectListener(GameInfo.class, (IWorldObjectEventListener)this);
        }
    }

    public class ExistingNavPointEdgeBuilder
    extends NewNavPointEdgeBuilder<ExistingNavPointModifier> {
        private NavPointNeighbourLink parentLink;

        protected ExistingNavPointEdgeBuilder(ExistingNavPointModifier navPointModifier) {
            super(navPointModifier);
        }

        protected ExistingNavPointEdgeBuilder(ExistingNavPointModifier navPointModifier, NavPointNeighbourLink parent) {
            super(navPointModifier);
            this.parentLink = parent;
            if (this.parentLink != null) {
                this.collisionH = this.parentLink.getCollisionH();
                this.collisionR = this.parentLink.getCollisionR();
                this.flags = this.parentLink.getFlags();
                this.forceDoubleJump = this.parentLink.isForceDoubleJump();
                this.neededJump = this.parentLink.getNeededJump();
                this.toNavPointId = this.parentLink.getToNavPoint().getId();
            }
        }

        public ExistingNavPointEdgeBuilder setTo(String navPointId) {
            super.setTo(navPointId);
            return this;
        }

        public ExistingNavPointEdgeBuilder setTo(UnrealId navPointId) {
            super.setTo(navPointId);
            return this;
        }

        public ExistingNavPointEdgeBuilder setCollisionRadius(int collisionRadius) {
            super.setCollisionRadius(collisionRadius);
            return this;
        }

        public ExistingNavPointEdgeBuilder setCollisionHeight(int collisionHeight) {
            super.setCollisionHeight(collisionHeight);
            return this;
        }

        public ExistingNavPointEdgeBuilder setNeededJump(double x, double y, double z) {
            super.setNeededJump(x, y, z);
            return this;
        }

        public ExistingNavPointEdgeBuilder removeNeededJump() {
            this.neededJump = null;
            return this;
        }

        public ExistingNavPointEdgeBuilder setDoubleJump() {
            super.setDoubleJump();
            return this;
        }

        public ExistingNavPointEdgeBuilder removeDoubleJump() {
            this.forceDoubleJump = false;
            return this;
        }

        public ExistingNavPointEdgeBuilder setWalkFlag() {
            super.setWalkFlag();
            return this;
        }

        public ExistingNavPointEdgeBuilder removeWalkFlag() {
            this.flags = (this.flags | LinkFlag.WALK.get()) ^ LinkFlag.WALK.get();
            return this;
        }

        public ExistingNavPointEdgeBuilder setFlyFlag() {
            super.setFlyFlag();
            return this;
        }

        public ExistingNavPointEdgeBuilder removeFlyFlag() {
            this.flags = (this.flags | LinkFlag.FLY.get()) ^ LinkFlag.FLY.get();
            return this;
        }

        public ExistingNavPointEdgeBuilder setSwimFlag() {
            super.setSwimFlag();
            return this;
        }

        public ExistingNavPointEdgeBuilder removeSwimFlag() {
            this.flags = (this.flags | LinkFlag.SWIM.get()) ^ LinkFlag.SWIM.get();
            return this;
        }

        public ExistingNavPointEdgeBuilder setJumpFlag() {
            super.setJumpFlag();
            return this;
        }

        public ExistingNavPointEdgeBuilder removeJumpFlag() {
            this.flags = (this.flags | LinkFlag.JUMP.get()) ^ LinkFlag.JUMP.get();
            return this;
        }

        public ExistingNavPointEdgeBuilder setDoorFlag() {
            super.setDoorFlag();
            return this;
        }

        public ExistingNavPointEdgeBuilder removeDoorFlag() {
            this.flags = (this.flags | LinkFlag.DOOR.get()) ^ LinkFlag.DOOR.get();
            return this;
        }

        public ExistingNavPointEdgeBuilder setSpecialFlag() {
            super.setSpecialFlag();
            return this;
        }

        public ExistingNavPointEdgeBuilder removeSpecialFlag() {
            this.flags = (this.flags | LinkFlag.SPECIAL.get()) ^ LinkFlag.SPECIAL.get();
            return this;
        }

        public ExistingNavPointEdgeBuilder setLadderFlag() {
            super.setLadderFlag();
            return this;
        }

        public ExistingNavPointEdgeBuilder removeLadderFlag() {
            this.flags = (this.flags | LinkFlag.LADDER.get()) ^ LinkFlag.LADDER.get();
            return this;
        }

        public ExistingNavPointEdgeBuilder setProscribedFlag() {
            super.setProscribedFlag();
            return this;
        }

        public ExistingNavPointEdgeBuilder removeProscribedFlag() {
            this.flags = (this.flags | LinkFlag.PROSCRIBED.get()) ^ LinkFlag.PROSCRIBED.get();
            return this;
        }

        public ExistingNavPointEdgeBuilder setForcedFlag() {
            super.setForcedFlag();
            return this;
        }

        public ExistingNavPointEdgeBuilder removeForcedFlag() {
            this.flags = (this.flags | LinkFlag.FORCED.get()) ^ LinkFlag.FORCED.get();
            return this;
        }

        public ExistingNavPointEdgeBuilder setPlayerOnlyFlag() {
            super.setPlayerOnlyFlag();
            return this;
        }

        public ExistingNavPointEdgeBuilder removePlayerOnlyFlag() {
            this.flags = (this.flags | LinkFlag.PLAYERONLY.get()) ^ LinkFlag.PLAYERONLY.get();
            return this;
        }

        public ExistingNavPointEdgeBuilder clearFlags() {
            this.flags = 0;
            return this;
        }

        @Override
        public ExistingNavPointModifier createEdge() {
            if (this.toNavPointId == null) {
                throw new PogamutException("Could not create/modify edge from navpoint '" + ((ExistingNavPointModifier)this.owner).navPoint.getId().getStringId() + "' as toNavPoint not specified, you must call setTo() with non-null argument (to specify the other end of the edge) before calling this method.", (Object)this);
            }
            IWorldObject np = ((UT2004Bot)NavigationGraphBuilder.this.agent).getWorldView().get((WorldObjectId)this.toNavPointId);
            if (np == null) {
                throw new PogamutException("Could not create/modify navpoint edge from '" + ((ExistingNavPointModifier)this.owner).navPoint.getId().getStringId() + "' as the remote end (" + this.toNavPointId.getStringId() + ") could not be found in the bot's worldview. Warning, id is case-sensitive the upper/lower cases of the id depends on the concrete spelling of the map that was passed to the GB2004 during startup (either from the command line or by the UT2004).", (Object)this);
            }
            if (!(np instanceof NavPoint)) {
                throw new PogamutException("Could not create/modify navpoint edge from '" + ((ExistingNavPointModifier)this.owner).navPoint.getId().getStringId() + "' as the remote end '" + this.toNavPointId.getStringId() + "' is not an instance of NavPoint but " + np.getClass().getSimpleName() + ". Wrong id specified?", (Object)this);
            }
            NavPoint toNavPoint = (NavPoint)np;
            NavPointNeighbourLink link = null;
            link = this.parentLink == null ? new NavPointNeighbourLink(((ExistingNavPointModifier)this.owner).navPoint.getId(), this.flags, this.collisionR, this.collisionH, 0.0, null, false, this.forceDoubleJump, this.neededJump, false, false, 0.0, ((ExistingNavPointModifier)this.owner).navPoint, toNavPoint) : new NavPointNeighbourLink(((ExistingNavPointModifier)this.owner).navPoint.getId(), this.flags, this.collisionR, this.collisionH, this.parentLink.getTranslocZOffset(), this.parentLink.getTranslocTargetTag(), this.parentLink.isOnlyTranslocator(), this.forceDoubleJump, this.neededJump, this.parentLink.isNeverImpactJump(), this.parentLink.isNoLowGrav(), this.parentLink.getCalculatedGravityZ(), ((ExistingNavPointModifier)this.owner).navPoint, toNavPoint);
            ((ExistingNavPointModifier)this.owner).navPoint.getOutgoingEdges().put(link.getToNavPoint().getId(), link);
            link.getToNavPoint().getIncomingEdges().put(((ExistingNavPointModifier)this.owner).navPoint.getId(), link);
            return (ExistingNavPointModifier)this.owner;
        }

        public ExistingNavPointModifier modifyEdge() {
            return this.createEdge();
        }
    }

    public class ExistingNavPointModifier {
        private NavPoint navPoint;

        protected ExistingNavPointModifier(NavPoint navPoint) {
            this.navPoint = navPoint;
            NullCheck.check((Object)this.navPoint, (String)"navPoint");
        }

        public void removeEdgeTo(String navPointId) {
            NullCheck.check((Object)navPointId, (String)"navPointId");
            navPointId = NavigationGraphBuilder.this.autoPrefix(navPointId);
            UnrealId navPointUnrealId = UnrealId.get((String)navPointId);
            this.navPoint.getOutgoingEdges().remove(navPointUnrealId);
            IWorldObject np = ((UT2004Bot)NavigationGraphBuilder.this.agent).getWorldView().get((WorldObjectId)navPointUnrealId);
            if (np != null && np instanceof NavPoint) {
                ((NavPoint)np).getIncomingEdges().remove(this.navPoint.getId());
            }
        }

        public void removeEdgesBetween(String navPointId) {
            NullCheck.check((Object)navPointId, (String)"navPointId");
            navPointId = NavigationGraphBuilder.this.autoPrefix(navPointId);
            UnrealId toNavPointUnrealId = UnrealId.get((String)navPointId);
            IWorldObject np = ((UT2004Bot)NavigationGraphBuilder.this.agent).getWorldView().get((WorldObjectId)toNavPointUnrealId);
            NavPoint toNavPoint = null;
            if (np != null && np instanceof NavPoint) {
                toNavPoint = (NavPoint)np;
            }
            this.navPoint.getOutgoingEdges().remove(toNavPointUnrealId);
            this.navPoint.getIncomingEdges().remove(toNavPointUnrealId);
            if (toNavPoint != null) {
                toNavPoint.getOutgoingEdges().remove(this.navPoint.getId());
                toNavPoint.getIncomingEdges().remove(this.navPoint.getId());
            }
        }

        public ExistingNavPointEdgeBuilder modifyEdgeTo(String navPointId) {
            NullCheck.check((Object)navPointId, (String)"navPointId");
            navPointId = NavigationGraphBuilder.this.autoPrefix(navPointId);
            UnrealId navPointUnrealId = UnrealId.get((String)navPointId);
            NavPointNeighbourLink link = this.navPoint.getOutgoingEdges().get(navPointUnrealId);
            if (link != null) {
                return new ExistingNavPointEdgeBuilder(this, link);
            }
            return new ExistingNavPointEdgeBuilder(this).setTo(navPointId);
        }

        public ExistingNavPointEdgeBuilder createEdgeTo(String navPointId) {
            NullCheck.check((Object)navPointId, (String)"navPointId");
            navPointId = NavigationGraphBuilder.this.autoPrefix(navPointId);
            ExistingNavPointEdgeBuilder builder = new ExistingNavPointEdgeBuilder(this, null);
            builder.setTo(navPointId);
            return builder;
        }

        public ExistingNavPointEdgeBuilder createEdge() {
            return new ExistingNavPointEdgeBuilder(this, null);
        }

        public void createSimpleEdgeTo(String navPointId) {
            NullCheck.check((Object)navPointId, (String)"navPointId");
            this.createEdgeTo(navPointId).createEdge();
        }

        public void createSimpleEdgesBetween(String navPointId) {
            NullCheck.check((Object)navPointId, (String)"navPointId");
            this.createEdgeTo(navPointId).createEdge();
            NavigationGraphBuilder.this.modifyNavPoint(navPointId).createSimpleEdgeTo(this.navPoint.getId().getStringId());
        }
    }

    public class NewNavPointEdgeBuilder<OWNER> {
        protected OWNER owner;
        protected UnrealId toNavPointId;
        protected int collisionR = 50;
        protected int collisionH = 106;
        protected boolean forceDoubleJump = false;
        protected Vector3d neededJump;
        protected int flags = 0;

        protected NewNavPointEdgeBuilder(OWNER owner) {
            this.owner = owner;
            NullCheck.check(this.owner, (String)"owner");
        }

        public NewNavPointEdgeBuilder<OWNER> setTo(String navPointId) {
            NullCheck.check((Object)navPointId, (String)"navPointId");
            this.toNavPointId = UnrealId.get((String)NavigationGraphBuilder.this.autoPrefix(navPointId));
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setTo(UnrealId navPointId) {
            this.toNavPointId = navPointId;
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setCollisionRadius(int collisionRadius) {
            this.collisionR = collisionRadius;
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setCollisionHeight(int collisionHeight) {
            this.collisionH = collisionHeight;
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setNeededJump(double x, double y, double z) {
            this.neededJump = new Vector3d(x, y, z);
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setDoubleJump() {
            this.forceDoubleJump = true;
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setWalkFlag() {
            this.flags |= LinkFlag.WALK.get();
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setFlyFlag() {
            this.flags |= LinkFlag.FLY.get();
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setSwimFlag() {
            this.flags |= LinkFlag.SWIM.get();
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setJumpFlag() {
            this.flags |= LinkFlag.JUMP.get();
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setDoorFlag() {
            this.flags |= LinkFlag.DOOR.get();
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setSpecialFlag() {
            this.flags |= LinkFlag.SPECIAL.get();
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setLadderFlag() {
            this.flags |= LinkFlag.LADDER.get();
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setProscribedFlag() {
            this.flags |= LinkFlag.PROSCRIBED.get();
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setForcedFlag() {
            this.flags |= LinkFlag.FORCED.get();
            return this;
        }

        public NewNavPointEdgeBuilder<OWNER> setPlayerOnlyFlag() {
            this.flags |= LinkFlag.PLAYERONLY.get();
            return this;
        }

        public OWNER createEdge() {
            if (this.toNavPointId == null) {
                throw new PogamutException("Could not create edge - toNavPoint not specified, you must call setTo() with non-null argument (to specify the other end of the edge) before calling this method.", (Object)this);
            }
            ((NewNavPointBuilder)this.owner).addEdge(this);
            return this.owner;
        }
    }

    public class NewNavPointBuilder {
        private String id;
        private Location location;
        private List<NewNavPointEdgeBuilder> edges = new ArrayList<NewNavPointEdgeBuilder>();

        protected NewNavPointBuilder() {
        }

        public NewNavPointBuilder setId(String id) {
            NullCheck.check((Object)id, (String)"id");
            this.id = NavigationGraphBuilder.this.autoPrefix(id);
            return this;
        }

        public NewNavPointBuilder setLocation(double x, double y, double z) {
            this.location = new Location(x, y, z);
            return this;
        }

        public void createNavPoint() {
            if (this.id == null) {
                throw new PogamutException("Could not create navpoint, id is null, you must set it using setId() before calling this method.", (Object)this);
            }
            if (this.location == null) {
                throw new PogamutException("Could not create navpoint (" + this.id + "), location is null, you must set it using setLocation() before calling this method.", (Object)this);
            }
            NavPointMessage newNavPoint = new NavPointMessage(UnrealId.get((String)this.id), this.location, null, false, null, null, false, false, null, null, false, false, false, false, 255, false, 255, false, false, false, false, false, false, false, false, new Rotation(0.0, 0.0, 0.0), false, false, null, new HashMap<UnrealId, NavPointNeighbourLink>(), new HashMap<UnrealId, NavPointNeighbourLink>(), null);
            for (NewNavPointEdgeBuilder edge : this.edges) {
                IWorldObject np = ((UT2004Bot)NavigationGraphBuilder.this.agent).getWorldView().get((WorldObjectId)edge.toNavPointId);
                if (np == null) {
                    throw new PogamutException("Could not create navpoint (" + this.id + ") as the remote end (" + edge.toNavPointId + ") of one of its edges could not be found in the bot's worldview. Warning, id is case-sensitive the upper/lower cases of the id depends on the concrete spelling of the map that was passed to the GB2004 during startup (either from the command line or by the UT2004).", (Object)this);
                }
                if (!(np instanceof NavPoint)) {
                    throw new PogamutException("Could not create navpoint (" + this.id + ") as the remote end (" + edge.toNavPointId + ") of one of its edges is not an instance of NavPoint, but " + np.getClass().getSimpleName() + ". Wrong id used?", (Object)this);
                }
                NavPoint toNavPoint = (NavPoint)np;
                NavPointNeighbourLink link = new NavPointNeighbourLink(UnrealId.get((String)this.id), edge.flags, edge.collisionR, edge.collisionH, 0.0, null, false, edge.forceDoubleJump, edge.neededJump, false, false, 0.0, newNavPoint, toNavPoint);
                ((NavPoint)newNavPoint).getOutgoingEdges().put(link.getToNavPoint().getId(), link);
                link.getToNavPoint().getIncomingEdges().put(((NavPoint)newNavPoint).getId(), link);
            }
            ((UT2004Bot)NavigationGraphBuilder.this.agent).getWorldView().notifyImmediately((IWorldChangeEvent)newNavPoint);
        }

        public NewNavPointEdgeBuilder<NewNavPointBuilder> newEdge() {
            return new NewNavPointEdgeBuilder<NewNavPointBuilder>(this);
        }

        public NewNavPointEdgeBuilder<NewNavPointBuilder> newEdgeTo(String navPointId) {
            NullCheck.check((Object)navPointId, (String)"navPointId");
            NewNavPointEdgeBuilder<NewNavPointBuilder> edgeBuilder = new NewNavPointEdgeBuilder<NewNavPointBuilder>(this);
            edgeBuilder.setTo(navPointId);
            return edgeBuilder;
        }

        public void createSimpleEdgeTo(String navPointId) {
            NullCheck.check((Object)navPointId, (String)"navPointId");
            this.newEdgeTo(navPointId).createEdge();
        }

        protected void addEdge(NewNavPointEdgeBuilder newNavPointEdgeBuilder) {
            this.edges.add(newNavPointEdgeBuilder);
        }
    }
}

