/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.KefikRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004GetBackToNavGraph {
    public static final int CLOSE_ENOUGH = 50;
    public static final double MAX_ANGLE = 0.7853981633974483;
    protected UT2004Bot bot;
    protected AgentInfo info;
    protected IUT2004PathRunner runner;
    protected boolean executing;
    protected LogCategory log;
    protected IWorldEventListener<EndMessage> endListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            UT2004GetBackToNavGraph.this.getBackOnNavGraph();
        }
    };
    protected List<IStuckDetector> stuckDetectors = new ArrayList<IStuckDetector>();
    protected ILocated focus;
    protected TabooSet<NavPoint> tried;
    protected NavPoint tryingNav;
    protected Location initialLocation;

    public UT2004GetBackToNavGraph(UT2004Bot bot, AgentInfo info, AdvancedLocomotion move) {
        this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        this.bot = bot;
        this.info = info;
        this.runner = new KefikRunner(bot, info, move, (Logger)this.log);
        this.stuckDetectors.add(new UT2004TimeStuckDetector(bot, 3000.0, 10000.0));
        this.stuckDetectors.add(new UT2004PositionStuckDetector(bot));
        this.stuckDetectors.add(new UT2004DistanceStuckDetector(bot));
        bot.getWorldView().addEventListener(EndMessage.class, this.endListener);
    }

    public NavPoint getNearestNavPoint() {
        return this.info.getNearestNavPoint();
    }

    public boolean isOnNavGraph() {
        return this.info.isOnNavGraph();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void execute() {
        if (this.executing) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("STARTED");
        }
        this.reset();
        this.initialLocation = this.info.getLocation();
        for (IStuckDetector stuckDetector : this.stuckDetectors) {
            stuckDetector.reset();
            stuckDetector.setEnabled(true);
        }
        this.executing = true;
    }

    public void stop() {
        if (!this.executing) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("STOPPED");
        }
        this.executing = false;
        this.reset();
        for (IStuckDetector stuckDetector : this.stuckDetectors) {
            stuckDetector.setEnabled(false);
        }
    }

    protected void reset() {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Reset");
        }
        if (this.tried == null) {
            this.tried = new TabooSet(this.bot);
        } else {
            this.tried.clear();
        }
        this.tryingNav = null;
    }

    protected void getBackOnNavGraph() {
        if (!this.executing) {
            return;
        }
        if (this.isOnNavGraph()) {
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info("Got back to Navigation Graph.");
            }
            this.stop();
            return;
        }
        while (!this.runToNavPoint()) {
            while (this.tryingNav == null) {
                this.tryingNav = (NavPoint)DistanceUtils.getNearest(this.tried.filter(this.bot.getWorldView().getAll(NavPoint.class).values()), (ILocated)this.info.getLocation());
                if (this.tryingNav != null && !(this.info.getLocation().getDistance(this.tryingNav.getLocation()) > 2000.0)) continue;
                if (this.tried.size() == 0) {
                    this.stop();
                    return;
                }
                this.tried.clear();
                this.tryingNav = null;
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Trying to get to: " + this.tryingNav);
            }
            this.initialLocation = this.info.getLocation();
            for (IStuckDetector stuckDetector : this.stuckDetectors) {
                stuckDetector.reset();
                stuckDetector.setBotTarget((ILocated)this.tryingNav);
            }
            this.runner.reset();
        }
        return;
    }

    protected boolean runToNavPoint() {
        if (this.tryingNav == null) {
            return false;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Running to: " + this.tryingNav);
        }
        double hDistance = this.bot.getLocation().getDistance2D(this.tryingNav.getLocation());
        double vDistance = this.bot.getLocation().getDistanceZ(this.tryingNav.getLocation());
        double angle = Math.atan(Math.abs(vDistance) / hDistance);
        if (this.runner.runToLocation(this.initialLocation, this.tryingNav.getLocation(), null, (ILocated)(this.focus == null ? this.tryingNav.getLocation() : this.focus), null, angle < 0.7853981633974483)) {
            for (IStuckDetector stuckDetector : this.stuckDetectors) {
                if (!stuckDetector.isStuck()) continue;
                this.runFailed();
                return false;
            }
            return true;
        }
        this.runFailed();
        return false;
    }

    protected void runFailed() {
        this.tried.add(this.tryingNav);
        this.tryingNav = null;
    }

    public void setFocus(ILocated located) {
        this.focus = located;
    }
}

